/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.helper;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.plugin.rest.admin.controller.RestScmServerController;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;

@Component
public class ResourceLinksHelperAdmin {
    @Inject
    private BasePathAwareLinkBuildingService linkService;

    private boolean hasSelfLink(EntityModel<?> res) {
        return res.getLink(IanaLinkRelations.SELF.value()).isPresent();
    }

    public void addAllLinksForMilestone(EntityModel<Milestone> res) {
        Milestone milestone = (Milestone)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)milestone));
    }

    public void addAllLinkForProject(EntityModel<GenericProject> res) {
        GenericProject cfr_ignored_0 = (GenericProject)res.getContent();
    }

    public void addAllLinkForScmServer(PagedModel<EntityModel> res, Page<ScmServer> scmServerPage) {
        List scmServerList = scmServerPage.getContent();
        scmServerList.forEach(scmServer -> {
            try {
                res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestScmServerController)WebMvcLinkBuilder.methodOn(RestScmServerController.class, (Object[])new Object[0])).findScmServerById(scmServer.getId()))).withRel("scm-server"));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
    }
}

