/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.plugin.rest.admin.jackson.model.LicenseInfoDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.LicensePluginDto;
import org.squashtest.tm.plugin.rest.admin.licensevalidator.dto.LicenseInfo;
import org.squashtest.tm.plugin.rest.admin.service.RestLicenseInfoService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestLicenseInfoController
extends BaseRestController {
    @Inject
    private RestLicenseInfoService restLicenseInfoService;

    @GetMapping(value={"/license/info"})
    @DynamicFilterExpression(value="*,license_plugins[*]")
    public ResponseEntity<EntityModel<LicenseInfoDto>> getLicenseInfo() {
        LicenseInfo licenseInfo = this.restLicenseInfoService.getLicenseInfo();
        EntityModel<LicenseInfoDto> res = this.customToResource(licenseInfo);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    private EntityModel<LicenseInfoDto> customToResource(LicenseInfo licenseInfo) {
        LicenseInfoDto license = this.toLicenseInfoDto(licenseInfo);
        return EntityModel.of((Object)license);
    }

    private LicenseInfoDto toLicenseInfoDto(LicenseInfo licenseInfo) {
        ArrayList<LicensePluginDto> licensePlugins = new ArrayList<LicensePluginDto>();
        licenseInfo.getLicensePlugins().forEach((key, value) -> {
            boolean bl = licensePlugins.add(new LicensePluginDto((String)key, (boolean)value));
        });
        return new LicenseInfoDto(licenseInfo.getMaxUsers(), licenseInfo.getExpirationDate(), licensePlugins, licenseInfo.isValidLicense());
    }
}

