/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import javax.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemListItem;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.plugin.rest.admin.jackson.model.InfoListItemDto;
import org.squashtest.tm.plugin.rest.admin.service.RestInfoListService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController(value=InfoListItem.class)
@UseDefaultRestApiConfiguration
public class RestInfoListItemController
extends BaseRestController {
    @Inject
    RestInfoListService restInfoListService;

    @GetMapping(value={"/info-list-items/{id}"})
    @EntityGetter(value={UserListItem.class, SystemListItem.class})
    @DynamicFilterExpression(value="*,info_list[label,description,code]")
    public ResponseEntity<EntityModel<InfoListItem>> findInfoListItemById(@PathVariable(value="id") Long infoListItemId) {
        InfoListItem infoListItem = this.restInfoListService.findItemById(infoListItemId);
        EntityModel res = this.toEntityModel((Identified)infoListItem);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/info-lists/{id}/items"})
    @DynamicFilterExpression(value="*,info_list[label,code,description]")
    public ResponseEntity<EntityModel<InfoListItem>> addInfoListItem(@PathVariable(value="id") Long infoListId, @RequestBody InfoListItemDto infoListItemDto) {
        InfoListItem infoListItem = infoListItemDto.dtoToInfoListItem();
        InfoListItem list = this.restInfoListService.addInfolistItem(infoListId, infoListItem);
        EntityModel res = this.toEntityModel((Identified)list);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/info-list-items/{id}"})
    @DynamicFilterExpression(value="*,info_list[label,code,description]")
    public ResponseEntity<EntityModel<InfoListItem>> setDefaulInfoListItem(@PathVariable(value="id") Long infoListItemId, @RequestBody InfoListItemDto infoListItemDto) {
        InfoListItem item = this.restInfoListService.updateInfoListItem(infoListItemId, infoListItemDto);
        EntityModel res = this.toEntityModel((Identified)item);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/info-list-items/{id}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteInfoListItemById(@PathVariable(value="id") Long infoListItemId) {
        this.restInfoListService.deleteInfolistItem(infoListItemId);
        return ResponseEntity.noContent().build();
    }
}

