/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.service.RestAdminPartyService;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController(value=Team.class)
@UseDefaultRestApiConfiguration
public class RestAdminTeamController
extends RestAdminBaseController {
    @Inject
    private RestAdminPartyService restAdminPartyService;

    @GetMapping(value={"/teams/team-name/{teamName}/members"})
    @ResponseBody
    public ResponseEntity<PagedModel<EntityModel<User>>> findTeamMembers(@PathVariable(value="teamName") String teamName, Pageable pageable) {
        Page<User> users = this.restAdminPartyService.findAllTeamMembers(teamName, pageable);
        SingleRelPagedResources<EntityModel<User>> res = this.toPagedResourcesWithRel(users, "members");
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/teams/team-name/{teamName}/members"})
    @ResponseBody
    public ResponseEntity<Void> addMembersToTeam(@PathVariable(value="teamName") String teamName, @RequestParam(value="userLogins") List<String> userLogins) {
        this.restAdminPartyService.addMembersToTeam(teamName, userLogins);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/teams/team-name/{teamName}/members"})
    @ResponseBody
    public ResponseEntity<Void> removeMembersFromTeam(@PathVariable(value="teamName") String teamName, @RequestParam(value="userLogins") List<String> userLogins) {
        this.restAdminPartyService.removeMembersFromTeam(teamName, userLogins);
        return ResponseEntity.noContent().build();
    }
}

