/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.AttachReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Cuf;
import org.squashtest.tm.plugin.report.books.requirements.beans.Data;
import org.squashtest.tm.plugin.report.books.requirements.beans.LowReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.PrintOptions;
import org.squashtest.tm.plugin.report.books.requirements.beans.Project;
import org.squashtest.tm.plugin.report.books.requirements.beans.ReqLink;
import org.squashtest.tm.plugin.report.books.requirements.beans.Requirement;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.TestCase;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFinder;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFormatter;

public class RequirementsTreeQuery
implements ReportQuery,
InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTreeQuery.class);
    private static final Map<Resource, String> cache = new HashMap<Resource, String>();
    private static final String MILESTONES = "milestones";
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String REQUIREMENTS_SELECTION_MODE = "requirementsSelectionMode";
    private static final String REPORT_OPTIONS = "reportOptions";
    private static final String REQUIREMENTS_SORT_ORDER = "requirementsSortOrder";
    private static final String TEMPLATE_FILE_NAME = "templateFileName";
    private static final String PRINT_ONLY_LAST_VERSION = "printOnlyLastVersion";
    private static final String PRINT_FOLDER_INFO = "printFolderInfo";
    private static final String PRINT_TEST_CASE = "printTestCase";
    private static final String PRINT_LINKED_REQ = "printLinkedReq";
    private static final String REQUIREMENT_FOLDERS = "requirement-folders";
    private static final String REQUIREMENTS = "requirements";
    private static final String HIGH_LEVEL_REQUIREMENTS = "high-level-requirements";
    private static final Object TAGS = "tags";
    private static final String MILESTONE_PICKER = "MILESTONE_PICKER";
    private static final String DEFAULT_SORT_ORDER = "ALPHABETICAL";
    private static final String DEFAULT_TEMPLATE_VALUE = "defaultTemplate";
    private final RequirementTreeQueryFinder queryFinder = new RequirementTreeQueryFinder();
    private RequirementTreeQueryFormatter formatter = new RequirementTreeQueryFormatter();
    protected SqlQueryRunner runner;
    private CurrentUserHelper currentUserHelper;

    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void setFormater(RequirementTreeQueryFormatter formatter) {
        this.formatter = formatter;
    }

    public void setCurrentUserHelper(CurrentUserHelper currentUserHelper) {
        this.currentUserHelper = currentUserHelper;
    }

    public void afterPropertiesSet() throws Exception {
        this.queryFinder.setRunner(this.runner);
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        ArrayList<String> html = new ArrayList<String>();
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        Criteria options = crit.get(REPORT_OPTIONS);
        optionsMap.put(PRINT_ONLY_LAST_VERSION, false);
        optionsMap.put(PRINT_FOLDER_INFO, false);
        optionsMap.put(PRINT_TEST_CASE, false);
        optionsMap.put(PRINT_LINKED_REQ, false);
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        String requirementsSortOrder = Objects.nonNull(crit.get(REQUIREMENTS_SORT_ORDER)) ? (String)crit.get(REQUIREMENTS_SORT_ORDER).getValue() : DEFAULT_SORT_ORDER;
        String templateFileName = this.retrieveTemplateFileName(crit.get(TEMPLATE_FILE_NAME));
        Boolean printOnlyLastVersion = (Boolean)optionsMap.get(PRINT_ONLY_LAST_VERSION);
        Boolean printFolderInfo = (Boolean)optionsMap.get(PRINT_FOLDER_INFO);
        Boolean printTestCase = (Boolean)optionsMap.get(PRINT_TEST_CASE);
        Boolean printLinkedReq = (Boolean)optionsMap.get(PRINT_LINKED_REQ);
        ArrayList<RequirementVersion> previousVersionsData = new ArrayList();
        Collection<Long> nodeIds = this.getNodeIdList(crit);
        Collection<Object[]> rawProjectsData = this.getRawProjectsData(crit);
        Collection<Object[]> rawReqsData = this.queryFinder.getReqDataForRlnIds(nodeIds, requirementsSortOrder);
        Collection<Object[]> rawConfigurationData = this.queryFinder.getMilestoneConfigurationQuery();
        boolean printMilestones = this.formatter.rawMilestoneConfigToBoolean(rawConfigurationData);
        Collection<Project> projectDataList = this.formatter.toProjectData(rawProjectsData);
        Collection<Requirement> reqsDataList = this.formatter.toRequirementData(rawReqsData, html, printMilestones);
        Collection hlrDataList = reqsDataList.stream().filter(Requirement::isHlr).collect(Collectors.toList());
        Collection<Long> versionAndFolderIds = this.getCurrentVersionAndFolderIds(reqsDataList);
        ArrayList<RequirementVersion> allVersions = new ArrayList<RequirementVersion>();
        this.extractVersions(reqsDataList, allVersions);
        if (Boolean.FALSE.equals(printOnlyLastVersion)) {
            Collection<Object[]> rawPreviousVersionIds = this.queryFinder.getVersionIds(nodeIds);
            Collection<Long> previousVersionIds = this.formatter.getPreviousVersionIds(rawPreviousVersionIds);
            versionAndFolderIds.addAll(previousVersionIds);
            Collection<Object[]> rawVersionsData = this.queryFinder.getPreviousVersionsData(previousVersionIds);
            previousVersionsData = this.formatter.toRequirementVersionData(rawVersionsData, html);
            allVersions.addAll(previousVersionsData);
        }
        Collection<Object[]> rawCufs = this.queryFinder.getCufsDataForVersionIds(versionAndFolderIds);
        Collection<Object[]> rawTagCuf = this.queryFinder.getTagCufsDataForVersionIds(versionAndFolderIds);
        Map<Long, List<Cuf>> cufDataMap = this.formatter.toCufDataMap(rawCufs, html);
        Map<Long, List<Cuf>> tagCufDataMap = this.formatter.toCufDataMap(rawTagCuf, html);
        this.formatter.bindCufsToVersions(allVersions, cufDataMap);
        this.formatter.bindCufsToVersions(allVersions, tagCufDataMap);
        if (Boolean.TRUE.equals(printTestCase)) {
            Collection<Object[]> rawTestCase = this.queryFinder.getTestCasesDataForVersionIds(versionAndFolderIds);
            Map<Long, List<TestCase>> testCasesDataMap = this.formatter.toTestCaseDataMap(rawTestCase);
            this.formatter.bindTcToVersions(allVersions, testCasesDataMap);
        }
        if (Boolean.TRUE.equals(printLinkedReq)) {
            Collection<Object[]> rawAttachReq = this.queryFinder.getAttachReqForReqIds(nodeIds);
            Collection<Object[]> rawReqLinkedToHlr = this.queryFinder.getReqLinkedToHlrForHlrIds(nodeIds);
            Collection<Object[]> rawReqLink = this.queryFinder.getReqLinkDataQueryForVersionIds(versionAndFolderIds);
            Map<Long, List<AttachReq>> attachReqDataMap = this.formatter.toAttachReqDataMap(rawAttachReq);
            Map<Long, List<LowReq>> reqLinkedToHlrDataMap = this.formatter.toReqLinkedToHlrDataMap(rawReqLinkedToHlr);
            Map<Long, List<ReqLink>> reqLinkDataMap = this.formatter.toReqLinkDataMap(rawReqLink);
            this.formatter.bindAttachReqToReq(reqsDataList, attachReqDataMap);
            this.formatter.bindLowReqToHlr(hlrDataList, reqLinkedToHlrDataMap);
            this.formatter.bindReqLinkToVersions(allVersions, reqLinkDataMap);
        }
        if (Boolean.FALSE.equals(printOnlyLastVersion)) {
            this.formatter.bindVersionsToReq(reqsDataList, previousVersionsData);
        }
        if (Boolean.TRUE.equals(printTestCase)) {
            Collection<Object[]> rawTestCaseToHLR = this.queryFinder.getTestCasesDataForHLR(nodeIds);
            Map<Long, List<TestCase>> testCasesToHLRDataMap = this.formatter.toTestCaseDataMap(rawTestCaseToHLR);
            this.formatter.bindIndirectTestCaseToAllHighLevelRequirementVersions(hlrDataList, testCasesToHLRDataMap);
        }
        this.formatter.bindReqToProject(projectDataList, reqsDataList);
        String milestoneLabel = null;
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(MILESTONES).getValue();
            milestoneLabel = this.queryFinder.getMilestoneLabel((Integer)milestoneIds.get(0));
            res.put("milestoneLabel", milestoneLabel);
        }
        PrintOptions printOptions = new PrintOptions(requirementsSortOrder, templateFileName, printOnlyLastVersion, printFolderInfo, printTestCase, printLinkedReq);
        Data data = new Data(projectDataList, milestoneLabel, printOptions);
        res.put("fileName", data.getFileTitleRequirementsReport());
        res.put("data", data);
        res.put("html", html);
    }

    void extractVersions(Collection<Requirement> reqsDataList, Collection<RequirementVersion> allVersions) {
        for (Requirement req : reqsDataList) {
            allVersions.addAll(req.getVersions());
        }
    }

    Collection<Long> getCurrentVersionAndFolderIds(Collection<Requirement> reqsDataList) {
        return reqsDataList.stream().map(Requirement::getCurrentVersionId).collect(Collectors.toList());
    }

    public void setIdsByProjectQuery(Resource idsByProjectQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsByProjectQuery);
        this.queryFinder.setIdsByProjectQuery(query);
    }

    public void setIdsBySelectionQuery(Resource idsBySelectionQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsBySelectionQuery);
        this.queryFinder.setIdsBySelectionQuery(query);
    }

    public void setIdsByTagQuery(Resource idsByTagQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsByTagQuery);
        this.queryFinder.setIdsByTagQuery(query);
    }

    public void setIdsByMilestoneQuery(Resource idsByMilestoneQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsByMilestoneQuery);
        this.queryFinder.setIdsByMilestoneQuery(query);
    }

    public void setRequirementVersionDataQuery(Resource requirementVersionDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(requirementVersionDataQuery);
        this.queryFinder.setRequirementDataQuery(query);
    }

    public void setBoundTCDataQuery(Resource boundTCDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(boundTCDataQuery);
        this.queryFinder.setBoundTCDataQuery(query);
    }

    public void setCufsDataQuery(Resource cufsDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(cufsDataQuery);
        this.queryFinder.setCufsDataQuery(query);
    }

    public void setAttachReqDataQuery(Resource attachReqDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(attachReqDataQuery);
        this.queryFinder.setAttachReqDataQuery(query);
    }

    public void setTagCufsDataQuery(Resource tagCufsDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(tagCufsDataQuery);
        this.queryFinder.setTagCufsDataQuery(query);
    }

    public void setReqLinkDataQuery(Resource reqLinkDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(reqLinkDataQuery);
        this.queryFinder.setReqLinkDataQuery(query);
    }

    public void setAllProjectDataQuery(Resource allProjectDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(allProjectDataQuery);
        this.queryFinder.setAllProjects(query);
    }

    public void setProjectsByMilestone(Resource projectsByMilestone) {
        String query = RequirementsTreeQuery.loadQuery(projectsByMilestone);
        this.queryFinder.setProjectsByMilestone(query);
    }

    public void setProjectsByTag(Resource projectsByTag) {
        String query = RequirementsTreeQuery.loadQuery(projectsByTag);
        this.queryFinder.setProjectsByTags(query);
    }

    public void setProjectsBySelection(Resource projectsBySelection) {
        String query = RequirementsTreeQuery.loadQuery(projectsBySelection);
        this.queryFinder.setProjectsBySelection(query);
    }

    public void setReqVersionIds(Resource reqVersionIds) {
        String query = RequirementsTreeQuery.loadQuery(reqVersionIds);
        this.queryFinder.setReqVersionsIds(query);
    }

    public void setReqVersionsData(Resource reqVersionsData) {
        String query = RequirementsTreeQuery.loadQuery(reqVersionsData);
        this.queryFinder.setPreviousVersionDataQuery(query);
    }

    public void setReqLinkedToHlr(Resource reqLinkedToHlr) {
        String query = RequirementsTreeQuery.loadQuery(reqLinkedToHlr);
        this.queryFinder.setReqLinkedToHlr(query);
    }

    public void setBoundTCtoHLRDataQuery(Resource boundTCtoHLRDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(boundTCtoHLRDataQuery);
        this.queryFinder.setBoundTCtoHLRDataQuery(query);
    }

    public void setMilestoneConfigurationQuery(Resource milestoneConfigurationQuery) {
        String query = RequirementsTreeQuery.loadQuery(milestoneConfigurationQuery);
        this.queryFinder.setMilestoneConfigurationQuery(query);
    }

    protected SqlQueryRunner getRunner() {
        return this.runner;
    }

    private Collection<Object[]> getRawProjectsData(Map<String, Criteria> criteriaMap) {
        Collection<Object[]> rawProjects;
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        if ("PROJECT_PICKER".equals(selectionMode.getValue())) {
            Criteria criteria = criteriaMap.get(PROJECT_IDS);
            Collection projectIds = (Collection)criteria.getValue();
            rawProjects = this.queryFinder.findProjects(projectIds);
        } else if (MILESTONE_PICKER.equals(selectionMode.getValue())) {
            List milestoneIds = (List)criteriaMap.get(MILESTONES).getValue();
            rawProjects = this.queryFinder.findProjectsByMilestone(milestoneIds, this.currentUserHelper.findFilteredReadableProjectIds());
        } else if ("TAG_PICKER".equals(selectionMode.getValue())) {
            List tags = (List)criteriaMap.get(TAGS).getValue();
            rawProjects = this.queryFinder.findProjectsByTags(tags, this.currentUserHelper.findFilteredReadableProjectIds());
        } else {
            rawProjects = this.queryFinder.findProjectsBySelection(this.getAllNodesIds(criteriaMap));
        }
        return rawProjects;
    }

    private Collection<Long> getNodeIdList(Map<String, Criteria> criteriaMap) {
        Collection<Long> requirementIdList;
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        if ("PROJECT_PICKER".equals(selectionMode.getValue())) {
            List<Long> projectIds = ((Collection)criteriaMap.get(PROJECT_IDS).getValue()).stream().map(Long::valueOf).toList();
            readableProjectIds.retainAll(projectIds);
            requirementIdList = this.queryFinder.findIdsByProject(readableProjectIds);
        } else if (MILESTONE_PICKER.equals(selectionMode.getValue())) {
            List milestoneIds = (List)criteriaMap.get(MILESTONES).getValue();
            requirementIdList = this.queryFinder.findIdsByMilestone(milestoneIds, readableProjectIds);
        } else if ("TAG_PICKER".equals(selectionMode.getValue())) {
            List tags = (List)criteriaMap.get(TAGS).getValue();
            requirementIdList = this.queryFinder.findIdsByTags(tags, readableProjectIds);
        } else {
            requirementIdList = this.queryFinder.findIdsBySelection(this.getAllNodesIds(criteriaMap), readableProjectIds);
        }
        return requirementIdList;
    }

    private Collection<String> getAllNodesIds(Map<String, Criteria> criteriaMap) {
        ArrayList folderIds;
        Collection highLvlReqIds;
        Criteria criteria = criteriaMap.get(REQUIREMENTS_IDS);
        Map selectedIds = (Map)criteria.getValue();
        ArrayList<String> allStrIds = (ArrayList<String>)selectedIds.get(REQUIREMENTS);
        if (allStrIds == null) {
            allStrIds = new ArrayList<String>();
        }
        if ((highLvlReqIds = (Collection)selectedIds.get(HIGH_LEVEL_REQUIREMENTS)) != null && !highLvlReqIds.isEmpty()) {
            allStrIds.addAll(highLvlReqIds);
        }
        if ((folderIds = (ArrayList)selectedIds.get(REQUIREMENT_FOLDERS)) == null) {
            folderIds = new ArrayList();
        }
        allStrIds.addAll(folderIds);
        return allStrIds;
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        return MILESTONE_PICKER.equals(selectionMode.getValue());
    }

    protected static String loadQuery(Resource query) {
        if (cache.get(query) == null) {
            InputStream is;
            try {
                is = query.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Scanner scan = new Scanner(is, "UTF-8");
            String value = scan.useDelimiter("\\A").next();
            scan.close();
            cache.put(query, value);
        }
        return cache.get(query);
    }

    private String retrieveTemplateFileName(Criteria templateCriteria) {
        if (Objects.nonNull(templateCriteria)) {
            try {
                return (String)templateCriteria.getValue();
            }
            catch (ClassCastException cce) {
                LOGGER.trace("Custom template file does not exist anymore.", (Throwable)cce);
            }
        }
        return DEFAULT_TEMPLATE_VALUE;
    }
}

