/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.datatype.hibernate5.HibernateProxySerializer;
import java.io.IOException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.proxy.HibernateProxy;

public class TryUnwrappingWhenPossibleHibernateProxySerializer
extends HibernateProxySerializer {
    private boolean isUnwrapping = false;

    public TryUnwrappingWhenPossibleHibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping, BeanProperty property, boolean isUnwrapping) {
        super(forceLazyLoading, serializeIdentifier, false, mapping, property);
        this.isUnwrapping = isUnwrapping;
    }

    public TryUnwrappingWhenPossibleHibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping, BeanProperty property) {
        super(forceLazyLoading, serializeIdentifier, false, mapping, property);
    }

    public TryUnwrappingWhenPossibleHibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping) {
        super(forceLazyLoading, serializeIdentifier, mapping);
    }

    public TryUnwrappingWhenPossibleHibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier) {
        super(forceLazyLoading, serializeIdentifier);
    }

    public TryUnwrappingWhenPossibleHibernateProxySerializer(boolean forceLazyLoading) {
        super(forceLazyLoading);
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException {
        JsonSerializer serializer = super.findSerializer(provider, value);
        return this.isUnwrapping ? serializer.unwrappingSerializer(NameTransformer.NOP) : serializer;
    }

    public JsonSerializer<HibernateProxy> unwrappingSerializer(NameTransformer unwrapper) {
        return new TryUnwrappingWhenPossibleHibernateProxySerializer(this._forceLazyLoading, this._serializeIdentifier, this._mapping, this._property, true);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return new TryUnwrappingWhenPossibleHibernateProxySerializer(this._forceLazyLoading, this._serializeIdentifier, this._mapping, property, this.isUnwrapping);
    }

    public boolean isUnwrappingSerializer() {
        return this.isUnwrapping;
    }
}

