/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SquashRestSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> orderProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        JsonPropertyOrder annot = (JsonPropertyOrder)beanDesc.getClassInfo().getAnnotation(JsonPropertyOrder.class);
        if (annot == null) {
            return beanProperties;
        }
        String[] pptOrdered = annot.value();
        Map<String, BeanPropertyWriter> mappedWriters = this.mapByName(beanProperties);
        ArrayList<BeanPropertyWriter> newWriters = new ArrayList<BeanPropertyWriter>(beanProperties.size());
        String[] stringArray = pptOrdered;
        int n = pptOrdered.length;
        int n2 = 0;
        while (n2 < n) {
            String ppt = stringArray[n2];
            BeanPropertyWriter writer = mappedWriters.remove(ppt);
            if (writer != null) {
                newWriters.add(writer);
            }
            ++n2;
        }
        newWriters.addAll(mappedWriters.values());
        return newWriters;
    }

    private Map<String, BeanPropertyWriter> mapByName(List<BeanPropertyWriter> beanProperties) {
        LinkedHashMap<String, BeanPropertyWriter> mapped = new LinkedHashMap<String, BeanPropertyWriter>(beanProperties.size());
        for (BeanPropertyWriter writer : beanProperties) {
            mapped.put(writer.getName(), writer);
        }
        return mapped;
    }
}

