/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationDynamicFilter;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;

public class SquashRestDeserializerModifier
extends BeanDeserializerModifier {
    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        return super.updateProperties(config, beanDesc, propDefs);
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        return super.updateBuilder(config, beanDesc, builder);
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        if (this.canApply(config, beanDesc, deserializer)) {
            return new FilterableDeserializer((BeanDeserializerBase)((BeanDeserializer)deserializer), false, null);
        }
        return deserializer;
    }

    private boolean canApply(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        Class clazz = beanDesc.getBeanClass();
        Class mixin = config.findMixInClassFor(clazz);
        return deserializer instanceof BeanDeserializer && (this.hasFilter(mixin) || this.hasFilter(clazz));
    }

    private boolean hasFilter(Class<?> toInspect) {
        if (toInspect == null) {
            return false;
        }
        JsonFilter filter = (JsonFilter)AnnotationUtils.findAnnotation(toInspect, JsonFilter.class);
        return filter != null && "squashrest".equals(filter.value());
    }

    private static final class FilterableDeserializer
    extends BeanDeserializer {
        private boolean isUnwrapping = false;
        private String ctxtPropertyName = null;

        public FilterableDeserializer(BeanDeserializerBase src, boolean isUnwrapping, String ctxtPropertyName) {
            super(src);
            this.isUnwrapping = isUnwrapping;
            this.ctxtPropertyName = ctxtPropertyName;
        }

        public FilterableDeserializer(BeanDeserializerBase src, NameTransformer unwrapper, boolean isUnwrapping, String ctxtPropertyName) {
            super(src, unwrapper);
            this.isUnwrapping = isUnwrapping;
            this.ctxtPropertyName = ctxtPropertyName;
        }

        public FilterableDeserializer(BeanDeserializerBase src, ObjectIdReader oir, boolean isUnwrapping, String ctxtPropertyName) {
            super(src, oir);
            this.isUnwrapping = isUnwrapping;
            this.ctxtPropertyName = ctxtPropertyName;
        }

        public FilterableDeserializer(BeanDeserializerBase src, Set<String> ignorableProps, boolean isUnwrapping, String ctxtPropertyName) {
            super(src, ignorableProps);
            this.isUnwrapping = isUnwrapping;
            this.ctxtPropertyName = ctxtPropertyName;
        }

        public FilterableDeserializer(BeanDeserializerBase src, BeanPropertyMap props, boolean isUnwrapping, String ctxtPropertyName) {
            super(src, props);
            this.isUnwrapping = isUnwrapping;
            this.ctxtPropertyName = ctxtPropertyName;
        }

        public FilterableDeserializer withObjectIdReader(ObjectIdReader oir) {
            return new FilterableDeserializer((BeanDeserializerBase)this, oir, this.isUnwrapping, this.ctxtPropertyName);
        }

        public FilterableDeserializer withIgnorableProperties(Set<String> ignorableProps) {
            return new FilterableDeserializer((BeanDeserializerBase)this, ignorableProps, this.isUnwrapping, this.ctxtPropertyName);
        }

        public FilterableDeserializer withBeanProperties(BeanPropertyMap props) {
            return new FilterableDeserializer((BeanDeserializerBase)this, props, this.isUnwrapping, this.ctxtPropertyName);
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            if (property == null) {
                return this;
            }
            boolean isUnwrapping = this.isUnwrappingProperty(property);
            return new FilterableDeserializer((BeanDeserializerBase)this, isUnwrapping, property.getName());
        }

        public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
            return new FilterableDeserializer((BeanDeserializerBase)this, unwrapper, true, this.ctxtPropertyName);
        }

        private boolean isUnwrappingProperty(BeanProperty property) {
            JsonUnwrapped unwrapped = (JsonUnwrapped)property.getAnnotation(JsonUnwrapped.class);
            return unwrapped != null && unwrapped.enabled();
        }

        private boolean isContextual() {
            return this.ctxtPropertyName != null;
        }

        public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
            boolean mustAdvanceFilter;
            DeserializationDynamicFilter filter = this.getFilter(ctxt);
            boolean bl = mustAdvanceFilter = this.isContextual() && !this.isUnwrapping;
            if (mustAdvanceFilter) {
                filter.setCurrentProperty(this.ctxtPropertyName);
                filter.advance();
            }
            BeanDeserializer configuredDeserializer = this.filteredDeserializer(ctxt);
            Object res = configuredDeserializer.deserializeFromObject(p, ctxt);
            if (mustAdvanceFilter) {
                filter.reset();
            }
            return res;
        }

        private BeanDeserializer filteredDeserializer(DeserializationContext ctxt) {
            DeserializationDynamicFilter filter = this.getFilter(ctxt);
            HashSet<String> blacklist = new HashSet<String>();
            Iterator props = this.properties();
            while (props.hasNext()) {
                SettableBeanProperty prop = (SettableBeanProperty)props.next();
                String name = prop.getName();
                if (filter.include(prop.getName())) continue;
                blacklist.add(name);
            }
            this._beanProperties.withoutProperties(blacklist);
            BeanDeserializer deserializer = new BeanDeserializer((BeanDeserializerBase)this, blacklist);
            return deserializer;
        }

        private DeserializationDynamicFilter getFilter(DeserializationContext ctxt) {
            DeserializationHints hints = (DeserializationHints)ctxt.getAttribute((Object)"deserialization_hints");
            return hints.getFilter();
        }
    }
}

