/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.requirement;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.requirement.HighLevelRequirementConverter;
import org.squashtest.tm.domain.requirement.Requirement;

@Component
public class PluginRequirementConverter
implements HighLevelRequirementConverter {
    @PersistenceContext
    private final EntityManager entityManager;

    public PluginRequirementConverter(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void convertIntoHighLevelRequirement(Long requirementId) {
        this.addHighLevelRequirement(requirementId);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    public void convertIntoStandardRequirement(Long requirementId) {
        this.removeHighLevelRequirement(requirementId);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addHighLevelRequirement(Long requirementId) {
        Requirement requirement = (Requirement)this.entityManager.find(Requirement.class, (Object)requirementId);
        requirement.setHighLevelRequirement(null);
        Query query = this.entityManager.createNativeQuery("INSERT INTO HIGH_LEVEL_REQUIREMENT (RLN_ID) VALUES(:requirementId)");
        query.setParameter("requirementId", (Object)requirementId);
        query.executeUpdate();
    }

    private void removeHighLevelRequirement(Long requirementId) {
        Query query = this.entityManager.createNativeQuery("DELETE FROM HIGH_LEVEL_REQUIREMENT WHERE RLN_ID = :requirementId");
        query.setParameter("requirementId", (Object)requirementId);
        query.executeUpdate();
    }
}

