/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.actionword.service;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.premium.actionword.dao.ActionWordGridDao;
import org.squashtest.tm.plugin.premium.service.UltimateLicenseChecker;
import org.squashtest.tm.service.actionword.ActionWordGridService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@Service
@Transactional(readOnly=true)
public class ActionWordGridServiceImpl
implements ActionWordGridService {
    private final ActionWordGridDao actionWordGridDao;
    private final UltimateLicenseChecker ultimateLicenseChecker;

    public ActionWordGridServiceImpl(ActionWordGridDao actionWordGridDao, UltimateLicenseChecker ultimateLicenseChecker) {
        this.actionWordGridDao = actionWordGridDao;
        this.ultimateLicenseChecker = ultimateLicenseChecker;
    }

    public GridResponse findAllParametersByActionWordId(long actionWordId, GridRequest request) {
        this.ultimateLicenseChecker.checkIfAvailable();
        return this.actionWordGridDao.findParameterGridByActionWordId(actionWordId, request);
    }

    public GridResponse findAllImplementationByActionWordId(long actionWordId, GridRequest request) {
        this.ultimateLicenseChecker.checkIfAvailable();
        return this.actionWordGridDao.findImplementationGridByActionWordId(actionWordId, request);
    }

    public GridResponse findAllUsingTestCasesByActionWordId(long actionWordId, GridRequest request) {
        this.ultimateLicenseChecker.checkIfAvailable();
        return this.actionWordGridDao.findUsingTestCaseGridByActionWordId(actionWordId, request);
    }
}

