/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.rest.admin.jackson.model.FieldMappingDto;
import org.squashtest.tm.plugin.rest.admin.validators.RestJiraSyncApiValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;

@Component
public class FieldMappingValidator
extends RestJiraSyncApiValidator {
    private static final String POST_FIELD_MAPPING_VALIDATION = "post-field-mapping-validation";
    private static final String PATCH_FIELD_MAPPING_VALIDATION = "patch-field-mapping-validation";
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinder;

    public boolean supports(Class<?> clazz) {
        return FieldMappingDto.class.equals(clazz);
    }

    public void validatePostFieldMapping(FieldMappingDto fieldMappingDto, long projectId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)fieldMappingDto, POST_FIELD_MAPPING_VALIDATION);
        this.checkSquashFieldCodeIsValid(fieldMappingDto.getSquashField(), projectId, (BindingResult)validationBean);
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)fieldMappingDto, errors, (String)POST_FIELD_MAPPING_VALIDATION);
    }

    public void validatePatchFieldMapping(String fieldMappingId, FieldMappingDto fieldMappingDto, long projectId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)fieldMappingDto, PATCH_FIELD_MAPPING_VALIDATION);
        if (!this.getValidFieldCodesSet(projectId).contains(fieldMappingId)) {
            validationBean.rejectValue("squashField", "invalid field mapping id", "The given field mapping id is invalid.");
        }
        this.checkSquashFieldCodeIsValid(fieldMappingDto.getSquashField(), projectId, (BindingResult)validationBean);
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)fieldMappingDto, errors, (String)PATCH_FIELD_MAPPING_VALIDATION);
    }

    private void checkSquashFieldCodeIsValid(String squashFieldCode, long projectId, BindingResult validationBean) {
        if (!this.getValidFieldCodesSet(projectId).contains(squashFieldCode)) {
            validationBean.rejectValue("squashField", "invalid code", "Squash field code is invalid.");
        }
    }

    private Set<String> getValidFieldCodesSet(long projectId) {
        HashSet<String> validFieldCodeSet = new HashSet<String>();
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField field = builtinSquashFieldArray[n2];
            validFieldCodeSet.add(field.toString());
            ++n2;
        }
        List cufBindings = this.customFieldBindingFinder.findCustomFieldsForProjectAndEntity(projectId, BindableEntity.REQUIREMENT_VERSION);
        for (CustomFieldBinding binding : cufBindings) {
            CustomField cuf = binding.getCustomField();
            validFieldCodeSet.add(cuf.getCode());
        }
        return validFieldCodeSet;
    }
}

