/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.plugin.jirasync.controller.execplan.IterationFormMetadata;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanSpecification;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.web.backend.controller.form.model.IterationFormModel;

@Service(value="squash.tm.plugin.jirasync.explanTestplanService")
@Transactional
class ExecplanTestplanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanTestplanService.class);
    @Inject
    private ExecplanSynchronizationDao dao;
    @Inject
    private CampaignLibraryNavigationService cpgService;
    @Inject
    private CampaignTestPlanManagerService cpgTestPlanService;
    @Inject
    private IterationTestPlanManagerService itTestPlanService;
    @Inject
    private CustomFieldJsonConverter jsonCufConverter;
    @Inject
    private TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    @Inject
    private IterationModificationService iterationModificationService;

    ExecplanTestplanService() {
    }

    void updateCampaignTestPlan(ExecplanSpecification specification) {
        if (specification.getAction() != ExecplanSpecification.Action.UPDATE_CPG) {
            throw new RuntimeException("programming error : called service 'updateCampaignTestPlan' but the test plan specification indicates the desired operation is " + String.valueOf((Object)specification.getAction()));
        }
        Long cpgId = specification.getTarget().getId();
        Set<Long> newTcIds = specification.getTestCaseIdsMap().keySet();
        LOGGER.debug("updating test plan for campaign {}", (Object)cpgId);
        LOGGER.trace("test plan will contain test cases : {}", newTcIds);
        Collection<Long> alreadyPlanned = this.dao.findTestCasesAlreadyPlannedInCampaign(cpgId);
        LOGGER.trace("discarding test cases that are already planned : {}", alreadyPlanned);
        newTcIds.removeAll(alreadyPlanned);
        LOGGER.trace("planning test cases : {}", newTcIds);
        this.cpgTestPlanService.addTestCasesToCampaignTestPlan(new ArrayList<Long>(newTcIds), cpgId.longValue());
        LOGGER.trace("done");
    }

    void updateIterationTestPlan(ExecplanSpecification specification) {
        if (specification.getAction() != ExecplanSpecification.Action.UPDATE_IT) {
            throw new RuntimeException("programming error : called service 'updateIterationTestPlan' but the test plan specification indicates the desired operation is " + String.valueOf((Object)specification.getAction()));
        }
        Long iterId = specification.getTarget().getId();
        Set<Long> newTcIds = specification.getTestCaseIdsMap().keySet();
        LOGGER.debug("updating test plan for iteration {}", (Object)iterId);
        LOGGER.trace("test plan will contain test cases : {}", newTcIds);
        Collection<Long> alreadyPlanned = this.dao.findTestCasesAlreadyPlannedInIteration(iterId);
        LOGGER.trace("discarding test cases that are already planned : {}", alreadyPlanned);
        newTcIds.removeAll(alreadyPlanned);
        LOGGER.trace("planning test cases : {}", newTcIds);
        this.itTestPlanService.addTestCasesToIteration(new ArrayList<Long>(newTcIds), iterId.longValue());
        LOGGER.trace("done");
    }

    Iteration createIteration(ExecplanSpecification specification) {
        if (specification.getAction() != ExecplanSpecification.Action.CREATE_IT) {
            throw new IllegalArgumentException("programming error : called service 'createIteration' but the test plan specification indicates the desired operation is " + String.valueOf((Object)specification.getAction()));
        }
        LOGGER.debug("creating iteration {} into campaign {}", (Object)specification.getIteration().getName(), (Object)specification.getTarget().getId());
        LOGGER.trace("test plan will contain test cases : {}", specification.getTestCaseIdsMap().keySet());
        IterationFormModel iterationFormModel = specification.getIteration();
        Set<Long> testCaseIds = specification.getTestCaseIdsMap().keySet();
        Iteration iteration = iterationFormModel.getIteration();
        Map customFields = iterationFormModel.getCufs();
        this.iterationModificationService.addIterationToCampaign(iteration, specification.getTarget().getId().longValue(), false, customFields);
        LOGGER.trace("iteration created");
        if (iterationFormModel.isTestSuitePerEpicOption()) {
            List<Long> testCaseIdsPresentInTestSuites = this.createTestSuitesFromHighLevelRequirements(specification.getTestCaseIdsMap(), iteration.getId());
            testCaseIds = testCaseIds.stream().filter(testCaseId -> !testCaseIdsPresentInTestSuites.contains(testCaseId)).collect(Collectors.toSet());
        }
        this.itTestPlanService.addTestCasesToIteration(new ArrayList<Long>(testCaseIds), iteration.getId().longValue());
        LOGGER.trace("test plan complete, task done");
        return iteration;
    }

    private List<Long> createTestSuitesFromHighLevelRequirements(Map<Long, List<String>> remoteKeysByTestCase, Long iterationId) {
        Map<Long, String> referenceByHighLevelId = this.dao.findHighLevelsHavingLinkInVerifiedRequirements(remoteKeysByTestCase);
        HashMap testSuiteIdByReference = new HashMap();
        HashMap<Long, Set> testCasesIdsByTestSuite = new HashMap<Long, Set>();
        referenceByHighLevelId.forEach((highLevelId, reference) -> {
            if (!testSuiteIdByReference.containsKey(reference)) {
                this.createTestSuiteToIteration(iterationId, testSuiteIdByReference, (String)reference);
            }
            List<Long> testCaseIdsLinkToHighLevel = this.dao.findTcIdsWhereVerifiedRequirementHavingLink((Long)highLevelId, remoteKeysByTestCase.keySet());
            testCasesIdsByTestSuite.computeIfAbsent((Long)testSuiteIdByReference.get(reference), s -> new HashSet()).addAll(testCaseIdsLinkToHighLevel);
        });
        testCasesIdsByTestSuite.forEach((testSuiteId, linkedTestCaseIds) -> {
            CreatedTestPlanItems createdTestPlanItems = this.testSuiteTestPlanManagerService.addTestCasesToIterationAndTestSuite(new ArrayList(linkedTestCaseIds), testSuiteId.longValue());
        });
        return testCasesIdsByTestSuite.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void createTestSuiteToIteration(Long iterationId, Map<String, Long> createdTestSuite, String reference) {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(reference);
        this.cpgService.addTestSuiteToIteration(iterationId, testSuite, new HashMap());
        createdTestSuite.put(reference, testSuite.getId());
    }

    IterationFormMetadata getIterationMetadata(Long campaignId) {
        LOGGER.debug("looking for required metadata in order to create an iteration for campaign {}", (Object)campaignId);
        List<String> siblingNames = this.dao.findIterationNamesForCampaign(campaignId);
        LOGGER.trace("sibling iteration names : {}", siblingNames);
        List<CustomField> cufs = this.dao.findIterationCutomfieldsForCampaign(campaignId);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("found custom fields : {}", cufs.stream().map(c -> c.getCode()).collect(Collectors.toList()));
        }
        List<CustomFieldModel<?>> jsonCufs = cufs.stream().map(cf -> this.jsonCufConverter.toJson(cf)).collect(Collectors.toList());
        return new IterationFormMetadata(siblingNames, jsonCufs);
    }
}

