/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync;

import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.api.wizard.InternationalizedWorkspaceWizard;
import org.squashtest.tm.api.wizard.SupervisionScreenData;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.RequirementSynchronizationService;

public class JIRASyncPlugin
extends InternationalizedWorkspaceWizard
implements SynchronisationPlugin,
TemplateConfigurablePlugin {
    public static final String PLUGIN_ID = "squash.tm.plugin.jirasync";
    public static final String PLUGIN_NAME = "xsquash4jira";
    private static final String URL_TEMPLATE = "plugin/jirasync/configuration/project/{projectId}";
    private static final String TEMPLATE_URL_PARAMS = "?template=true";
    public static final String FIELD_MAPPING = "attributeMappings";
    public static final String LINK_MAPPING = "linkMappings";
    public static final String VALUES_MAPPING = "valuesMapping";
    public static final String JIRA_TESTING_STATUS_FIELD = "jiraTestingStatusField";
    public static final String JIRA_REDACTION_PROGRESS_FIELD = "jiraRedactionProgressField";
    public static final String JIRA_VERIFICATION_PROGRESS_FIELD = "jiraVerificationProgressField";
    public static final String JIRA_VALIDATION_PROGRESS_FIELD = "jiraValidationProgressField";
    public static final String JIRA_REDACTION_RATIO_FIELD = "jiraRedactionRatioField";
    public static final String JIRA_VERIFICATION_RATIO_FIELD = "jiraVerificationRatioField";
    public static final String JIRA_VALIDATION_RATIO_FIELD = "jiraValidationRatioField";
    private RequirementSynchronizationService requirementSynchronizationService;
    private ConfigurationService configurationService;

    public void setRequirementSynchronizationService(RequirementSynchronizationService requirementSynchronizationService) {
        this.requirementSynchronizationService = requirementSynchronizationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public SupervisionScreenData getSupervisionScreenData() {
        SupervisionScreenData data = SupervisionScreenData.withNoAdditionalColumn();
        data.setHasSyncNameColumn(true);
        data.setHasRemoteSelectTypeColumn(true);
        data.setHasSynchronizedRequirementsRatioColumn(true);
        data.setHasSynchronizedSprintTicketsRatioColumn(true);
        return data;
    }

    public WorkspaceType getConfiguringWorkspace() {
        return WorkspaceType.REQUIREMENT_WORKSPACE;
    }

    public void validate(EntityReference reference) throws PluginValidationException {
    }

    public String getConfigurationPath(EntityReference context) {
        Long id = context.getId();
        return URL_TEMPLATE.replace("{projectId}", id.toString());
    }

    public String getTemplateConfigurationPath(EntityReference context) {
        return this.getConfigurationPath(context) + TEMPLATE_URL_PARAMS;
    }

    public void synchroniseTemplateConfiguration(Long templateId, Long targetProjectId) {
        this.configurationService.synchronizeTemplateConfiguration(templateId, targetProjectId);
    }

    public Runnable performSynchronisation() {
        Runnable runnable = () -> this.requirementSynchronizationService.performFullSynchronisation();
        return new DelegatingSecurityContextRunnable(runnable);
    }

    public String getSyncErrorLogPath(Long syncId) {
        return this.requirementSynchronizationService.getSyncErrorLogPath(syncId);
    }
}

