/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.oslc4j.provider.jena;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import plugin.rtc.com.hp.hpl.jena.datatypes.DatatypeFormatException;
import plugin.rtc.com.hp.hpl.jena.datatypes.RDFDatatype;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.impl.XSDDateType;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Container;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Literal;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ModelFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFList;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RSIterator;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ReifiedStatement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ResIterator;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.SimpleSelector;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDF;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDFS;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.NestedWildcardProperties;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.OSLC4JConstants;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.OslcGlobalNamespaceProvider;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.SingletonWildcardProperties;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.UnparseableLiteral;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcNamespaceDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRdfCollectionType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcSchema;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyDefinitionException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingSetMethodException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreMisusedOccursException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreRelativeURIException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.AnyResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.FilteredResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.IExtendedResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.IOslcCustomNamespaceProvider;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.IReifiedResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.IResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.InheritedMethodAnnotationHelper;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.TypeFactory;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ValueType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.XMLLiteral;

public final class JenaModelHelper {
    private static final String PROPERTY_TOTAL_COUNT = "totalCount";
    private static final String PROPERTY_NEXT_PAGE = "nextPage";
    private static final String RDF_TYPE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final String RDF_LIST = "List";
    private static final String RDF_ALT = "Alt";
    private static final String RDF_BAG = "Bag";
    private static final String RDF_SEQ = "Seq";
    private static final String METHOD_NAME_START_GET = "get";
    private static final String METHOD_NAME_START_IS = "is";
    private static final String METHOD_NAME_START_SET = "set";
    private static final int METHOD_NAME_START_GET_LENGTH = "get".length();
    private static final int METHOD_NAME_START_IS_LENGTH = "is".length();
    private static final String GENERATED_PREFIX_START = "j.";
    private static final Logger logger = Logger.getLogger(JenaModelHelper.class.getName());

    private JenaModelHelper() {
    }

    public static Model createJenaModel(Object[] objects) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        return JenaModelHelper.createJenaModel(null, null, null, objects, null);
    }

    static Model createJenaModel(String descriptionAbout, String responseInfoAbout, ResponseInfo<?> responseInfo, Object[] objects, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Model model = ModelFactory.createDefaultModel();
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        Resource descriptionResource = null;
        if (descriptionAbout != null) {
            descriptionResource = OSLC4JUtils.isQueryResultListAsContainer() ? model.createResource(descriptionAbout, RDFS.Container) : model.createResource(descriptionAbout);
            HashMap<IExtendedResource, Resource> visitedResources = new HashMap<IExtendedResource, Resource>();
            JenaModelHelper.handleExtendedProperties(FilteredResource.class, model, descriptionResource, responseInfo.getContainer(), properties, visitedResources);
            if (responseInfoAbout != null) {
                Resource resource = model.createResource(responseInfoAbout, model.createProperty("http://open-services.net/ns/core#ResponseInfo"));
                if (responseInfo != null) {
                    int totalCount = responseInfo.totalCount() == null ? objects.length : responseInfo.totalCount();
                    resource.addProperty(model.createProperty("http://open-services.net/ns/core#", PROPERTY_TOTAL_COUNT), model.createTypedLiteral(totalCount));
                    if (responseInfo.nextPage() != null) {
                        resource.addProperty(model.createProperty("http://open-services.net/ns/core#", PROPERTY_NEXT_PAGE), model.createResource(responseInfo.nextPage()));
                    }
                    visitedResources = new HashMap();
                    JenaModelHelper.handleExtendedProperties(ResponseInfo.class, model, resource, responseInfo, properties, visitedResources);
                }
            }
        }
        namespaceMappings.putAll(OslcGlobalNamespaceProvider.getInstance().getPrefixDefinitionMap());
        for (Object object : objects) {
            JenaModelHelper.handleSingleResource(descriptionResource, object, model, namespaceMappings, properties);
        }
        if (descriptionAbout != null) {
            JenaModelHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings);
            JenaModelHelper.ensureNamespacePrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#", namespaceMappings);
            if (responseInfoAbout != null) {
                JenaModelHelper.ensureNamespacePrefix("oslc", "http://open-services.net/ns/core#", namespaceMappings);
            }
        }
        for (Map.Entry entry : namespaceMappings.entrySet()) {
            model.setNsPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        return model;
    }

    private static void handleSingleResource(Resource descriptionResource, Object object, Model model, Map<String, String> namespaceMappings, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Resource mainResource;
        Class<?> objectClass = object.getClass();
        JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, objectClass);
        if (object instanceof URI) {
            mainResource = model.createResource(((URI)object).toASCIIString());
        } else {
            String qualifiedName;
            URI aboutURI = null;
            if (object instanceof IResource) {
                aboutURI = ((IResource)object).getAbout();
            }
            if (aboutURI != null) {
                if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
                }
                mainResource = model.createResource(aboutURI.toString());
            } else {
                mainResource = model.createResource();
            }
            if (objectClass.getAnnotation(OslcResourceShape.class) != null && (qualifiedName = TypeFactory.getQualifiedName(objectClass)) != null) {
                mainResource.addProperty(RDF.type, model.createResource(qualifiedName));
            }
            JenaModelHelper.buildResource(object, objectClass, model, mainResource, properties);
        }
        if (descriptionResource != null) {
            descriptionResource.addProperty(RDFS.member, mainResource);
        }
    }

    public static Object fromJenaResource(Resource resource, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        Object newInstance = beanClass.newInstance();
        HashMap classPropertyDefinitionsToSetMethods = new HashMap();
        HashMap<String, Object> visitedResources = new HashMap<String, Object>();
        HashSet<String> rdfTypes = new HashSet<String>();
        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, beanClass, newInstance, resource, visitedResources, rdfTypes);
        return newInstance;
    }

    public static Object[] fromJenaModel(Model model, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (beanClass.getAnnotation(OslcResourceShape.class) != null) {
            ResIterator listSubjects = null;
            if (!OSLC4JUtils.useBeanClassForParsing()) {
                String qualifiedName = TypeFactory.getQualifiedName(beanClass);
                listSubjects = model.listSubjectsWithProperty(RDF.type, model.getResource(qualifiedName));
                List<Resource> resourceList = listSubjects.toList();
                JenaModelHelper.createObjectResultList(beanClass, results, resourceList);
            } else {
                listSubjects = model.listSubjectsWithProperty(RDF.type);
                ArrayList<Resource> resourceList = new ArrayList<Resource>();
                while (listSubjects.hasNext()) {
                    Resource resource = (Resource)listSubjects.next();
                    SimpleSelector selector = new SimpleSelector(null, null, resource);
                    StmtIterator listStatements = model.listStatements(selector);
                    if (listStatements.hasNext()) continue;
                    resourceList.add(resource);
                }
                JenaModelHelper.createObjectResultList(beanClass, results, resourceList);
            }
        } else if (URI.class.equals(beanClass)) {
            StmtIterator memberIterator = model.listStatements(null, RDFS.member, (RDFNode)null);
            while (memberIterator.hasNext()) {
                Statement memberStatement = (Statement)memberIterator.next();
                RDFNode memberObject = memberStatement.getObject();
                if (!memberObject.isURIResource()) continue;
                URI memberURI = URI.create(memberObject.asResource().getURI());
                results.add(memberURI);
            }
        }
        return results.toArray((Object[])Array.newInstance(beanClass, results.size()));
    }

    private static List<Object> createObjectResultList(Class<?> beanClass, List<Object> results, List<Resource> listSubjects) throws IllegalAccessException, InstantiationException, DatatypeConfigurationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, NoSuchMethodException {
        if (null != listSubjects) {
            HashMap classPropertyDefinitionsToSetMethods = new HashMap();
            for (Resource resource : listSubjects) {
                Object newInstance = beanClass.newInstance();
                HashMap<String, Object> visitedResources = new HashMap<String, Object>();
                HashSet<String> rdfTypes = new HashSet<String>();
                JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, beanClass, newInstance, resource, visitedResources, rdfTypes);
                results.add(newInstance);
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fromResource(Map<Class<?>, Map<String, Method>> classPropertyDefinitionsToSetMethods, Class<?> beanClass, Object bean, Resource resource, Map<String, Object> visitedResources, HashSet<String> rdfTypes) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        Method setMethod;
        HashMap<QName, Object> extendedProperties;
        IExtendedResource extendedResource;
        String aboutURIString;
        Map<String, Method> setMethodMap = classPropertyDefinitionsToSetMethods.get(beanClass);
        if (setMethodMap == null) {
            setMethodMap = JenaModelHelper.createPropertyDefinitionToSetMethods(beanClass);
            classPropertyDefinitionsToSetMethods.put(beanClass, setMethodMap);
        }
        visitedResources.put(JenaModelHelper.getVisitedResourceName(resource), bean);
        if (bean instanceof IResource && (aboutURIString = resource.getURI()) != null) {
            URI aboutURI = new URI(aboutURIString);
            if (aboutURI.isAbsolute()) {
                ((IResource)bean).setAbout(aboutURI);
            } else if (!(bean instanceof AbstractResource)) {
                throw new OslcCoreRelativeURIException(beanClass, "setAbout", aboutURI);
            }
        }
        HashMap<String, ArrayList<String>> propertyDefinitionsToArrayValues = new HashMap<String, ArrayList<String>>();
        HashSet<Method> singleValueMethodsUsed = new HashSet<Method>();
        StmtIterator listProperties = resource.listProperties();
        if (bean instanceof IExtendedResource) {
            extendedResource = (IExtendedResource)bean;
            extendedProperties = new HashMap<QName, Object>();
            extendedResource.setExtendedProperties(extendedProperties);
        } else {
            extendedResource = null;
            extendedProperties = null;
        }
        rdfTypes = JenaModelHelper.getTypesFromResource(resource, rdfTypes);
        while (listProperties.hasNext()) {
            RDFNode o;
            List<RDFNode> objects;
            boolean bl;
            Statement statement = (Statement)listProperties.next();
            Property predicate = statement.getPredicate();
            RDFNode object = statement.getObject();
            String uri = predicate.getURI();
            setMethod = setMethodMap.get(uri);
            if (setMethod == null) {
                ArrayList<Object> collection;
                if (RDF_TYPE_URI.equals(uri)) {
                    if (extendedResource == null) continue;
                    URI type = new URI(object.asResource().getURI());
                    extendedResource.addType(type);
                    continue;
                }
                if (extendedProperties == null) {
                    logger.fine("Set method not found for object type:\t" + beanClass.getName() + ", uri:\t" + uri);
                    continue;
                }
                String prefix = resource.getModel().getNsURIPrefix(predicate.getNameSpace());
                if (prefix == null) {
                    prefix = JenaModelHelper.generatePrefix(resource.getModel(), predicate.getNameSpace());
                }
                QName qName = new QName(predicate.getNameSpace(), predicate.getLocalName(), prefix);
                Object value = JenaModelHelper.handleExtendedPropertyValue(beanClass, object, visitedResources, qName, rdfTypes);
                Object previous = extendedProperties.get(qName);
                if (previous == null) {
                    extendedProperties.put(qName, value);
                    continue;
                }
                if (previous instanceof Collection) {
                    collection = (ArrayList<Object>)previous;
                } else {
                    collection = new ArrayList<Object>();
                    collection.add(previous);
                    extendedProperties.put(qName, collection);
                }
                collection.add(value);
                continue;
            }
            Class setMethodComponentParameterClass = setMethod.getParameterTypes()[0];
            boolean bl2 = setMethodComponentParameterClass.isArray();
            if (bl2) {
                setMethodComponentParameterClass = setMethodComponentParameterClass.getComponentType();
            } else if (Collection.class.isAssignableFrom(setMethodComponentParameterClass)) {
                Type actualTypeArgument;
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                bl = true;
                Type genericParameterType = setMethod.getGenericParameterTypes()[0];
                if (genericParameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                    setMethodComponentParameterClass = (Class)actualTypeArgument;
                }
            }
            if (bl && object.isResource() && (object.asResource().hasProperty(RDF.first) && object.asResource().hasProperty(RDF.rest) || RDF.nil.equals(object) || object.canAs(RDFList.class))) {
                objects = new ArrayList<RDFNode>();
                for (Resource listNode = object.asResource(); listNode != null && !RDF.nil.getURI().equals(listNode.getURI()); listNode = listNode.getPropertyResourceValue(RDF.rest)) {
                    visitedResources.put(JenaModelHelper.getVisitedResourceName(listNode), new Object());
                    o = listNode.getPropertyResourceValue(RDF.first);
                    objects.add(o);
                }
                visitedResources.put(JenaModelHelper.getVisitedResourceName(object.asResource()), objects);
            } else if (bl && JenaModelHelper.isRdfCollectionResource(object.getModel(), object)) {
                objects = new ArrayList<RDFNode>();
                ExtendedIterator<RDFNode> iterator = object.asResource().listProperties(RDFS.member).mapWith(new Map1<Statement, RDFNode>(){

                    @Override
                    public RDFNode map1(Statement o) {
                        return o.getObject();
                    }
                });
                while (iterator.hasNext()) {
                    o = (RDFNode)iterator.next();
                    if (o.isResource()) {
                        visitedResources.put(JenaModelHelper.getVisitedResourceName(o.asResource()), new Object());
                    }
                    objects.add(o);
                }
                visitedResources.put(JenaModelHelper.getVisitedResourceName(object.asResource()), objects);
            } else {
                objects = Collections.singletonList(object);
            }
            Class reifiedClass = null;
            if (IReifiedResource.class.isAssignableFrom(setMethodComponentParameterClass)) {
                Type actualTypeArgument;
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                reifiedClass = setMethodComponentParameterClass;
                Type genericType = setMethodComponentParameterClass.getGenericSuperclass();
                if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                    setMethodComponentParameterClass = (Class)actualTypeArgument;
                }
            }
            for (RDFNode o2 : objects) {
                Object parameter = null;
                if (o2.isLiteral()) {
                    Literal literal = o2.asLiteral();
                    String string = literal.getString();
                    if (String.class == setMethodComponentParameterClass) {
                        parameter = string;
                    } else if (Boolean.class == setMethodComponentParameterClass || Boolean.TYPE == setMethodComponentParameterClass) {
                        if (Boolean.TRUE.toString().equals(string) || "1".equals(string)) {
                            parameter = Boolean.TRUE;
                        } else {
                            if (!Boolean.FALSE.toString().equals(string) && !"0".equals(string)) throw new IllegalArgumentException("'" + string + "' has wrong format for Boolean.");
                            parameter = Boolean.FALSE;
                        }
                    } else if (Byte.class == setMethodComponentParameterClass || Byte.TYPE == setMethodComponentParameterClass) {
                        parameter = Byte.valueOf(string);
                    } else if (Short.class == setMethodComponentParameterClass || Short.TYPE == setMethodComponentParameterClass) {
                        parameter = Short.valueOf(string);
                    } else if (Integer.class == setMethodComponentParameterClass || Integer.TYPE == setMethodComponentParameterClass) {
                        parameter = Integer.valueOf(string);
                    } else if (Long.class == setMethodComponentParameterClass || Long.TYPE == setMethodComponentParameterClass) {
                        parameter = Long.valueOf(string);
                    } else if (BigInteger.class == setMethodComponentParameterClass) {
                        parameter = new BigInteger(string);
                    } else if (Float.class == setMethodComponentParameterClass || Float.TYPE == setMethodComponentParameterClass) {
                        parameter = XSDDatatype.XSDfloat.parseValidated(string);
                    } else if (Double.class == setMethodComponentParameterClass || Double.TYPE == setMethodComponentParameterClass) {
                        parameter = XSDDatatype.XSDdouble.parseValidated(string);
                    } else if (Date.class == setMethodComponentParameterClass) {
                        parameter = DatatypeFactory.newInstance().newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
                    }
                } else if (o2.isResource()) {
                    Resource nestedResource = o2.asResource();
                    if (URI.class == setMethodComponentParameterClass) {
                        String string = nestedResource.getURI();
                        if (string != null) {
                            URI nestedResourceURI = new URI(string);
                            if (OSLC4JUtils.relativeURIsAreDisabled() && !nestedResourceURI.isAbsolute()) {
                                throw new OslcCoreRelativeURIException(beanClass, setMethod.getName(), nestedResourceURI);
                            }
                            parameter = nestedResourceURI;
                        }
                    } else {
                        Object t = setMethodComponentParameterClass.newInstance();
                        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, setMethodComponentParameterClass, t, nestedResource, visitedResources, rdfTypes);
                        parameter = t;
                    }
                }
                if (parameter == null) continue;
                if (reifiedClass != null) {
                    Object reifiedResource = reifiedClass.newInstance();
                    for (Method method : reifiedClass.getMethods()) {
                        Class<?>[] parameterTypes;
                        if (!"setValue".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(setMethodComponentParameterClass)) continue;
                        method.invoke(reifiedResource, parameter);
                        break;
                    }
                    RSIterator rSIterator = statement.listReifiedStatements();
                    while (rSIterator.hasNext()) {
                        ReifiedStatement reifiedStatement = (ReifiedStatement)rSIterator.next();
                        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, reifiedClass, reifiedResource, reifiedStatement, visitedResources, rdfTypes);
                    }
                    parameter = reifiedResource;
                }
                if (bl) {
                    ArrayList<String> values = (ArrayList<String>)propertyDefinitionsToArrayValues.get(uri);
                    if (values == null) {
                        values = new ArrayList<String>();
                        propertyDefinitionsToArrayValues.put(uri, values);
                    }
                    values.add((String)parameter);
                    continue;
                }
                if (singleValueMethodsUsed.contains(setMethod)) {
                    throw new OslcCoreMisusedOccursException(beanClass, setMethod);
                }
                setMethod.invoke(bean, parameter);
                singleValueMethodsUsed.add(setMethod);
            }
        }
        for (Map.Entry propertyDefinitionToArrayValues : propertyDefinitionsToArrayValues.entrySet()) {
            void var18_27;
            String uri = (String)propertyDefinitionToArrayValues.getKey();
            List values = (List)propertyDefinitionToArrayValues.getValue();
            setMethod = setMethodMap.get(uri);
            Class<?> parameterClass = setMethod.getParameterTypes()[0];
            if (parameterClass.isArray()) {
                Class<?> clazz = parameterClass.getComponentType();
                Object array = Array.newInstance(clazz, values.size());
                int index = 0;
                for (Object value : values) {
                    Array.set(array, index++, value);
                }
                setMethod.invoke(bean, array);
                continue;
            }
            if (Collection.class == parameterClass || List.class == parameterClass || Deque.class == parameterClass || Queue.class == parameterClass || AbstractCollection.class == parameterClass || AbstractList.class == parameterClass || AbstractSequentialList.class == parameterClass) {
                LinkedList linkedList = new LinkedList();
            } else if (Set.class == parameterClass || AbstractSet.class == parameterClass) {
                HashSet hashSet = new HashSet();
            } else if (SortedSet.class == parameterClass || NavigableSet.class == parameterClass) {
                TreeSet treeSet = new TreeSet();
            } else {
                Collection tempCollection;
                Collection collection = tempCollection = (Collection)parameterClass.newInstance();
            }
            var18_27.addAll(values);
            setMethod.invoke(bean, var18_27);
        }
    }

    private static HashSet<String> getTypesFromResource(Resource resource, HashSet<String> types) {
        if (OSLC4JUtils.inferTypeFromShape() && types.isEmpty()) {
            StmtIterator rdfTypesIterator = resource.listProperties(RDF.type);
            while (rdfTypesIterator.hasNext()) {
                Statement rdfTypeStmt = (Statement)rdfTypesIterator.next();
                RDFNode object = rdfTypeStmt.getObject();
                if (!object.isResource()) continue;
                String rdfType = object.asResource().getURI();
                types.add(rdfType);
            }
        }
        return types;
    }

    private static boolean isRdfCollectionResource(Model model, RDFNode object) {
        Resource resource;
        return object.isResource() && ((resource = object.asResource()).hasProperty(RDF.type, model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#typeAlt")) || resource.hasProperty(RDF.type, model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#typeBag")) || resource.hasProperty(RDF.type, model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#typeSeq")));
    }

    private static String generatePrefix(Model model, String namespace) {
        String candidatePrefix;
        Map<String, String> map = model.getNsPrefixMap();
        int i = 0;
        do {
            candidatePrefix = GENERATED_PREFIX_START + i;
            ++i;
        } while (map.containsKey(candidatePrefix));
        model.setNsPrefix(candidatePrefix, namespace);
        return candidatePrefix;
    }

    private static Object handleExtendedPropertyValue(Class<?> beanClass, RDFNode object, Map<String, Object> visitedResources, QName propertyQName, HashSet<String> rdfTypes) throws URISyntaxException, IllegalArgumentException, SecurityException, DatatypeConfigurationException, IllegalAccessException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, NoSuchMethodException {
        if (object.isLiteral()) {
            Object literalValue;
            Object newObject;
            RDFDatatype dataType;
            Literal literal = object.asLiteral();
            if (OSLC4JUtils.inferTypeFromShape() && null == (dataType = literal.getDatatype()) && null != (newObject = OSLC4JUtils.getValueBasedOnResourceShapeType(rdfTypes, propertyQName, literal.getString()))) {
                return newObject;
            }
            try {
                literalValue = literal.getValue();
            }
            catch (DatatypeFormatException e) {
                String rawValue = literal.getString();
                String datatype = literal.getDatatypeURI();
                if ("false".equals(System.getProperty("plugin.rtc.org.eclipse.lyo.oslc4j.strictDatatypes"))) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Property " + propertyQName.getNamespaceURI() + propertyQName.getLocalPart() + " could not be parsed as datatype " + literal.getDatatypeURI(), e);
                    }
                    return new UnparseableLiteral(rawValue, datatype);
                }
                throw e;
            }
            if (literalValue instanceof XSDDateTime) {
                XSDDateTime xsdDateTime = (XSDDateTime)literalValue;
                return xsdDateTime.asCalendar().getTime();
            }
            if (XMLLiteralType.theXMLLiteralType.getURI().equals(literal.getDatatypeURI())) {
                return new XMLLiteral(literal.getString());
            }
            if (XSDDatatype.XSDdecimal.getURI().equals(literal.getDatatypeURI())) {
                return new BigDecimal(literal.getString());
            }
            return literalValue;
        }
        Resource nestedResource = object.asResource();
        if ((nestedResource.getURI() == null || nestedResource.listProperties().hasNext()) && !visitedResources.containsKey(JenaModelHelper.getVisitedResourceName(nestedResource))) {
            AnyResource any = new AnyResource();
            HashMap classPropertyDefinitionsToSetMethods = new HashMap();
            JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, AnyResource.class, any, nestedResource, visitedResources, rdfTypes);
            return any;
        }
        if (nestedResource.getURI() == null || nestedResource.listProperties().hasNext()) {
            return visitedResources.get(JenaModelHelper.getVisitedResourceName(nestedResource));
        }
        URI nestedResourceURI = new URI(nestedResource.getURI());
        if (OSLC4JUtils.relativeURIsAreDisabled() && !nestedResourceURI.isAbsolute()) {
            throw new OslcCoreRelativeURIException(beanClass, "<none>", nestedResourceURI);
        }
        return nestedResourceURI;
    }

    private static Map<String, Method> createPropertyDefinitionToSetMethods(Class<?> beanClass) throws OslcCoreApplicationException {
        Method[] methods;
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method method : methods = beanClass.getMethods()) {
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String getMethodName;
            if (method.getParameterTypes().length != 0 || (!(getMethodName = method.getName()).startsWith(METHOD_NAME_START_GET) || getMethodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!getMethodName.startsWith(METHOD_NAME_START_IS) || getMethodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcPropertyDefinition.class)) == null) continue;
            String setMethodName = getMethodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_GET_LENGTH) : METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_IS_LENGTH);
            Class<?> getMethodReturnType = method.getReturnType();
            try {
                Method setMethod = beanClass.getMethod(setMethodName, getMethodReturnType);
                result.put(oslcPropertyDefinitionAnnotation.value(), setMethod);
            }
            catch (NoSuchMethodException exception) {
                throw new OslcCoreMissingSetMethodException(beanClass, method, exception);
            }
        }
        return result;
    }

    private static void buildResource(Object object, Class<?> resourceClass, Model model, Resource mainResource, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        if (properties == OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
            return;
        }
        for (Method method : resourceClass.getMethods()) {
            Object value;
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String methodName;
            if (method.getParameterTypes().length != 0 || (!(methodName = method.getName()).startsWith(METHOD_NAME_START_GET) || methodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!methodName.startsWith(METHOD_NAME_START_IS) || methodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcPropertyDefinition.class)) == null || (value = method.invoke(object, new Object[0])) == null) continue;
            Map<String, Object> nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map<String, Object> map = (Map<String, Object>)properties.get(oslcPropertyDefinitionAnnotation.value());
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)((Object)properties)).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            JenaModelHelper.buildAttributeResource(resourceClass, method, oslcPropertyDefinitionAnnotation, model, mainResource, value, nestedProperties, onlyNested);
        }
        if (object instanceof IExtendedResource) {
            IExtendedResource extendedResource = (IExtendedResource)object;
            HashMap<IExtendedResource, Resource> visitedResources = new HashMap<IExtendedResource, Resource>();
            JenaModelHelper.handleExtendedProperties(resourceClass, model, mainResource, extendedResource, properties, visitedResources);
        }
    }

    protected static void handleExtendedProperties(Class<?> resourceClass, Model model, Resource mainResource, IExtendedResource extendedResource, Map<String, Object> properties, Map<IExtendedResource, Resource> visitedResources) throws DatatypeConfigurationException, IllegalAccessException, InvocationTargetException, OslcCoreApplicationException {
        visitedResources.put(extendedResource, mainResource);
        for (URI type : extendedResource.getTypes()) {
            Resource typeResource;
            String propertyName = type.toString();
            if (properties != null && properties.get(propertyName) == null && !(properties instanceof NestedWildcardProperties) && !(properties instanceof SingletonWildcardProperties) || mainResource.hasProperty(RDF.type, typeResource = model.createResource(propertyName))) continue;
            mainResource.addProperty(RDF.type, typeResource);
        }
        Transformer transformer = JenaModelHelper.createTransformer();
        for (Map.Entry<QName, Object> extendedProperty : extendedResource.getExtendedProperties().entrySet()) {
            QName qName = extendedProperty.getKey();
            String propertyName = qName.getNamespaceURI() + qName.getLocalPart();
            Map<String, Object> nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map<String, Object> map = (Map<String, Object>)properties.get(propertyName);
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)((Object)properties)).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            Property property = model.createProperty(propertyName);
            Object value = extendedProperty.getValue();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object next : collection) {
                    JenaModelHelper.handleExtendedValue(resourceClass, next, model, mainResource, property, nestedProperties, onlyNested, visitedResources, transformer);
                }
                continue;
            }
            JenaModelHelper.handleExtendedValue(resourceClass, value, model, mainResource, property, nestedProperties, onlyNested, visitedResources, transformer);
        }
    }

    private static void handleExtendedValue(Class<?> objectClass, Object value, Model model, Resource resource, Property property, Map<String, Object> nestedProperties, boolean onlyNested, Map<IExtendedResource, Resource> visitedResources, Transformer transformer) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        if (value instanceof UnparseableLiteral) {
            if (onlyNested) {
                return;
            }
            UnparseableLiteral unparseable = (UnparseableLiteral)value;
            resource.addProperty(property, model.createLiteral(unparseable.getRawValue()));
        } else if (value instanceof AnyResource) {
            AbstractResource any = (AbstractResource)value;
            if (!visitedResources.containsKey(any)) {
                Resource nestedResource;
                URI aboutURI = any.getAbout();
                if (aboutURI != null) {
                    if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                        throw new OslcCoreRelativeURIException(AnyResource.class, "getAbout", aboutURI);
                    }
                    nestedResource = model.createResource(aboutURI.toString());
                } else {
                    nestedResource = model.createResource();
                }
                for (URI type : any.getTypes()) {
                    String propertyName = type.toString();
                    if (nestedProperties != null && nestedProperties.get(propertyName) == null && !(nestedProperties instanceof NestedWildcardProperties) && !(nestedProperties instanceof SingletonWildcardProperties)) continue;
                    nestedResource.addProperty(RDF.type, model.createResource(propertyName));
                }
                JenaModelHelper.handleExtendedProperties(AnyResource.class, model, nestedResource, any, nestedProperties, visitedResources);
                resource.addProperty(property, nestedResource);
            } else {
                resource.addProperty(property, visitedResources.get(any));
            }
        } else if (value.getClass().getAnnotation(OslcResourceShape.class) != null || value instanceof URI) {
            boolean xmlliteral = false;
            JenaModelHelper.handleLocalResource(objectClass, null, xmlliteral, value, model, resource, property, nestedProperties, onlyNested, null);
        } else if (value instanceof Date) {
            if (onlyNested) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            RDFDatatype dataType = null;
            if (OSLC4JUtils.inferTypeFromShape()) {
                HashSet<String> rdfTypes = new HashSet<String>();
                rdfTypes = JenaModelHelper.getTypesFromResource(resource, rdfTypes);
                dataType = OSLC4JUtils.getDataTypeBasedOnResourceShapeType(rdfTypes, property);
            }
            if (dataType != null && dataType instanceof XSDDateType) {
                XSDDateTime valuec = new XSDDateTime(cal);
                valuec.narrowType(XSDDatatype.XSDdate);
                String valueDate = valuec.toString();
                if (valueDate != null && valueDate.endsWith("Z")) {
                    valueDate = valueDate.replaceAll("Z", "");
                }
                resource.addProperty(property, model.createTypedLiteral(valueDate, (RDFDatatype)XSDDatatype.XSDdate));
            } else {
                resource.addProperty(property, model.createTypedLiteral(cal));
            }
        } else if (value instanceof XMLLiteral) {
            XMLLiteral xmlLiteral = (XMLLiteral)value;
            Literal xmlString = model.createTypedLiteral(xmlLiteral.getValue(), XMLLiteralType.theXMLLiteralType);
            resource.addProperty(property, xmlString);
        } else if (value instanceof Element) {
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource((Element)value);
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            Literal xmlString = model.createLiteral(result.getWriter().toString(), true);
            resource.addProperty(property, xmlString);
        } else if (value instanceof String) {
            if (onlyNested) {
                return;
            }
            resource.addProperty(property, model.createLiteral((String)value));
        } else if (value instanceof Float) {
            if (onlyNested) {
                return;
            }
            Float f = (Float)value;
            Literal l = JenaModelHelper.toLiteral(model, f);
            resource.addProperty(property, l);
        } else if (value instanceof Double) {
            if (onlyNested) {
                return;
            }
            Double d = (Double)value;
            Literal l = JenaModelHelper.toLiteral(model, d);
            resource.addProperty(property, l);
        } else {
            if (onlyNested) {
                return;
            }
            resource.addProperty(property, model.createTypedLiteral(value));
        }
    }

    private static Literal toLiteral(Model model, Float f) {
        if (f.compareTo(Float.valueOf(Float.POSITIVE_INFINITY)) == 0) {
            return model.createTypedLiteral("INF", XSDDatatype.XSDfloat.getURI());
        }
        if (f.compareTo(Float.valueOf(Float.NEGATIVE_INFINITY)) == 0) {
            return model.createTypedLiteral("-INF", XSDDatatype.XSDfloat.getURI());
        }
        return model.createTypedLiteral((Object)f, (RDFDatatype)XSDDatatype.XSDfloat);
    }

    private static Literal toLiteral(Model model, Double d) {
        if (d.compareTo(Double.POSITIVE_INFINITY) == 0) {
            return model.createTypedLiteral("INF", XSDDatatype.XSDdouble.getURI());
        }
        if (d.compareTo(Double.NEGATIVE_INFINITY) == 0) {
            return model.createTypedLiteral("-INF", XSDDatatype.XSDdouble.getURI());
        }
        return model.createTypedLiteral((Object)d, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    private static void buildAttributeResource(Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Model model, Resource resource, Object value, Map<String, Object> nestedProperties, boolean onlyNested) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        OslcName nameAnnotation;
        String name;
        String propertyDefinition = propertyDefinitionAnnotation.value();
        if (!propertyDefinition.endsWith(name = (nameAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcName.class)) != null ? nameAnnotation.value() : JenaModelHelper.getDefaultPropertyName(method))) {
            throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, propertyDefinitionAnnotation);
        }
        OslcValueType valueTypeAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcValueType.class);
        boolean xmlLiteral = valueTypeAnnotation == null ? false : ValueType.XMLLiteral.equals((Object)valueTypeAnnotation.value());
        Property attribute = model.createProperty(propertyDefinition);
        Class<?> returnType = method.getReturnType();
        OslcRdfCollectionType collectionType = InheritedMethodAnnotationHelper.getAnnotation(method, OslcRdfCollectionType.class);
        ArrayList<RDFNode> rdfNodeContainer = collectionType != null && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(collectionType.namespaceURI()) && (RDF_LIST.equals(collectionType.collectionType()) || RDF_ALT.equals(collectionType.collectionType()) || RDF_BAG.equals(collectionType.collectionType()) || RDF_SEQ.equals(collectionType.collectionType())) ? new ArrayList<RDFNode>() : null;
        if (returnType.isArray()) {
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object object = Array.get(value, index);
                JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, object, model, resource, attribute, nestedProperties, onlyNested, rdfNodeContainer);
            }
            if (rdfNodeContainer != null) {
                RDFNode container = JenaModelHelper.createRdfContainer(collectionType, rdfNodeContainer, model);
                Statement s = model.createStatement(resource, attribute, container);
                model.add(s);
            }
        } else if (Collection.class.isAssignableFrom(returnType)) {
            Collection collection = (Collection)value;
            for (Object object : collection) {
                JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, object, model, resource, attribute, nestedProperties, onlyNested, rdfNodeContainer);
            }
            if (rdfNodeContainer != null) {
                RDFNode container = JenaModelHelper.createRdfContainer(collectionType, rdfNodeContainer, model);
                Statement s = model.createStatement(resource, attribute, container);
                model.add(s);
            }
        } else {
            JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, value, model, resource, attribute, nestedProperties, onlyNested, null);
        }
    }

    private static RDFNode createRdfContainer(OslcRdfCollectionType collectionType, List<RDFNode> rdfNodeContainer, Model model) {
        if (RDF_LIST.equals(collectionType.collectionType())) {
            return model.createList(rdfNodeContainer.iterator());
        }
        Container container = RDF_ALT.equals(collectionType.collectionType()) ? model.createAlt() : (RDF_BAG.equals(collectionType.collectionType()) ? model.createBag() : model.createSeq());
        for (RDFNode node : rdfNodeContainer) {
            container.add(node);
        }
        return container;
    }

    private static void handleLocalResource(Class<?> resourceClass, Method method, boolean xmlLiteral, Object object, Model model, Resource resource, Property attribute, Map<String, Object> nestedProperties, boolean onlyNested, List<RDFNode> rdfNodeContainer) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Object value;
        if (object == null) {
            return;
        }
        Class<?> objectClass = object.getClass();
        RDFNode nestedNode = null;
        IReifiedResource reifiedResource = object instanceof IReifiedResource ? (IReifiedResource)object : null;
        Object object2 = value = reifiedResource == null ? object : reifiedResource.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            if (onlyNested) {
                return;
            }
            nestedNode = xmlLiteral ? model.createTypedLiteral(value.toString(), XMLLiteralType.theXMLLiteralType) : model.createLiteral(value.toString());
        } else if (value instanceof Float) {
            if (onlyNested) {
                return;
            }
            nestedNode = JenaModelHelper.toLiteral(model, (Float)value);
        } else if (value instanceof Double) {
            if (onlyNested) {
                return;
            }
            nestedNode = JenaModelHelper.toLiteral(model, (Double)value);
        } else if (value instanceof Boolean || value instanceof Number) {
            if (onlyNested) {
                return;
            }
            nestedNode = model.createTypedLiteral(value);
        } else if (value instanceof URI) {
            if (onlyNested) {
                return;
            }
            URI uri = (URI)value;
            if (OSLC4JUtils.relativeURIsAreDisabled() && !uri.isAbsolute()) {
                throw new OslcCoreRelativeURIException(resourceClass, method == null ? "<none>" : method.getName(), uri);
            }
            nestedNode = model.createResource(value.toString());
        } else if (value instanceof Date) {
            if (onlyNested) {
                return;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value);
            RDFDatatype dataType = null;
            if (OSLC4JUtils.inferTypeFromShape()) {
                HashSet<String> rdfTypes = new HashSet<String>();
                rdfTypes = JenaModelHelper.getTypesFromResource(resource, rdfTypes);
                dataType = OSLC4JUtils.getDataTypeBasedOnResourceShapeType(rdfTypes, attribute);
            }
            if (dataType != null && dataType instanceof XSDDateType) {
                XSDDateTime valuec = new XSDDateTime(calendar);
                valuec.narrowType(XSDDatatype.XSDdate);
                String valueDate = valuec.toString();
                if (valueDate != null && valueDate.endsWith("Z")) {
                    valueDate = valueDate.replaceAll("Z", "");
                }
                nestedNode = model.createTypedLiteral(valueDate, (RDFDatatype)XSDDatatype.XSDdate);
            } else {
                nestedNode = model.createTypedLiteral(calendar);
            }
        } else if (objectClass.getAnnotation(OslcResourceShape.class) != null) {
            Resource nestedResource;
            String namespace = TypeFactory.getNamespace(objectClass);
            String name = TypeFactory.getName(objectClass);
            URI aboutURI = null;
            if (value instanceof IResource) {
                aboutURI = ((IResource)value).getAbout();
            }
            if (aboutURI != null) {
                if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
                }
                nestedResource = model.createResource(aboutURI.toString(), model.createProperty(namespace, name));
            } else {
                nestedResource = model.createResource(model.createProperty(namespace, name));
            }
            JenaModelHelper.buildResource(value, objectClass, model, nestedResource, nestedProperties);
            nestedNode = nestedResource;
        } else if (logger.isLoggable(Level.WARNING)) {
            String objectClassName;
            String subjectClassName = resourceClass.getSimpleName();
            if ("".equals(subjectClassName)) {
                subjectClassName = resourceClass.getName();
            }
            if ("".equals(objectClassName = objectClass.getSimpleName())) {
                objectClassName = objectClass.getName();
            }
            logger.warning("Could not serialize " + objectClassName + " because it does not have an OslcResourceShape annotation (class: " + subjectClassName + ", method: " + method.getName() + ")");
        }
        if (nestedNode != null) {
            if (rdfNodeContainer != null) {
                if (reifiedResource != null) {
                    throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, null);
                }
                rdfNodeContainer.add(nestedNode);
            } else {
                Statement statement = model.createStatement(resource, attribute, nestedNode);
                if (reifiedResource != null && nestedProperties != OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
                    JenaModelHelper.addReifiedStatements(model, statement, reifiedResource, nestedProperties);
                }
                model.add(statement);
            }
        }
    }

    private static void addReifiedStatements(Model model, Statement statement, IReifiedResource<?> reifiedResource, Map<String, Object> nestedProperties) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException {
        ReifiedStatement reifiedStatement = statement.createReifiedStatement();
        JenaModelHelper.buildResource(reifiedResource, reifiedResource.getClass(), model, reifiedStatement, nestedProperties);
    }

    private static String getDefaultPropertyName(Method method) {
        String methodName = method.getName();
        int startingIndex = methodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_GET_LENGTH : METHOD_NAME_START_IS_LENGTH;
        int endingIndex = startingIndex + 1;
        String lowercasedFirstCharacter = methodName.substring(startingIndex, endingIndex).toLowerCase(Locale.ENGLISH);
        if (methodName.length() == endingIndex) {
            return lowercasedFirstCharacter;
        }
        return lowercasedFirstCharacter + methodName.substring(endingIndex);
    }

    private static void recursivelyCollectNamespaceMappings(Map<String, String> namespaceMappings, Class<? extends Object> resourceClass) {
        Class<?>[] interfaces;
        Class<? extends Object> superClass;
        OslcSchema oslcSchemaAnnotation = resourceClass.getPackage().getAnnotation(OslcSchema.class);
        if (oslcSchemaAnnotation != null) {
            OslcNamespaceDefinition[] oslcNamespaceDefinitionAnnotations;
            for (OslcNamespaceDefinition oslcNamespaceDefinitionAnnotation : oslcNamespaceDefinitionAnnotations = oslcSchemaAnnotation.value()) {
                String prefix = oslcNamespaceDefinitionAnnotation.prefix();
                String namespaceURI = oslcNamespaceDefinitionAnnotation.namespaceURI();
                namespaceMappings.put(prefix, namespaceURI);
            }
            Class<? extends IOslcCustomNamespaceProvider> customNamespaceProvider = oslcSchemaAnnotation.customNamespaceProvider();
            if (!customNamespaceProvider.isInterface()) {
                try {
                    IOslcCustomNamespaceProvider customNamespaceProviderImpl = customNamespaceProvider.newInstance();
                    Map<String, String> customNamespacePrefixes = customNamespaceProviderImpl.getCustomNamespacePrefixes();
                    if (null != customNamespacePrefixes) {
                        namespaceMappings.putAll(customNamespacePrefixes);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("The custom namespace provider implementation: " + customNamespaceProvider.getClass().getName() + ", must have a public no args construtor", e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("The custom namespace provider must not be a abstract, nor interface class and must have a public no args constructor", e);
                }
            }
        }
        if ((superClass = resourceClass.getSuperclass()) != null) {
            JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, superClass);
        }
        if ((interfaces = resourceClass.getInterfaces()) != null) {
            for (Class<?> interfac : interfaces) {
                JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, interfac);
            }
        }
    }

    private static void ensureNamespacePrefix(String prefix, String namespace, Map<String, String> namespaceMappings) {
        if (!namespaceMappings.containsValue(namespace)) {
            if (!namespaceMappings.containsKey(prefix)) {
                namespaceMappings.put(prefix, namespace);
            } else {
                int index = 1;
                while (true) {
                    String newPrefix;
                    if (!namespaceMappings.containsKey(newPrefix = prefix + index)) {
                        namespaceMappings.put(newPrefix, namespace);
                        return;
                    }
                    ++index;
                }
            }
        }
    }

    private static String getVisitedResourceName(Resource resource) {
        String visitedResourceName = null;
        visitedResourceName = resource.getURI() != null ? resource.getURI() : resource.getId().toString();
        return visitedResourceName;
    }

    private static Transformer createTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

