/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.client.oslc;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import plugin.rtc.net.oauth.OAuthAccessor;
import plugin.rtc.net.oauth.OAuthConsumer;
import plugin.rtc.net.oauth.OAuthException;
import plugin.rtc.net.oauth.OAuthMessage;
import plugin.rtc.net.oauth.OAuthServiceProvider;
import plugin.rtc.net.oauth.client.OAuthClient;
import plugin.rtc.net.oauth.client.httpclient4.HttpClient4;
import plugin.rtc.net.oauth.http.HttpClient;
import plugin.rtc.org.apache.wink.client.ClientConfig;
import plugin.rtc.org.apache.wink.client.ClientResponse;
import plugin.rtc.org.apache.wink.client.RestClient;
import plugin.rtc.org.eclipse.lyo.client.oslc.OAuthRedirectException;
import plugin.rtc.org.eclipse.lyo.client.oslc.OslcClient;

public class OslcOAuthClient
extends OslcClient {
    protected OAuthAccessor accessor;
    private static Logger LOGGER = Logger.getLogger(OslcOAuthClient.class);
    private String oauth_real_name;

    public OslcOAuthClient(String requestTokenURL, String authorizationTokenURL, String accessTokenURL, String consumerKey, String consumerSecret) {
        OAuthServiceProvider provider = new OAuthServiceProvider(requestTokenURL, authorizationTokenURL, accessTokenURL);
        OAuthConsumer consumer = new OAuthConsumer("", consumerKey, consumerSecret, provider);
        this.accessor = new OAuthAccessor(consumer);
    }

    public OslcOAuthClient(String requestTokenURL, String authorizationTokenURL, String accessTokenURL, String consumerKey, String consumerSecret, String oauthRealmName) {
        this(requestTokenURL, authorizationTokenURL, accessTokenURL, consumerKey, consumerSecret);
        this.oauth_real_name = oauthRealmName;
    }

    public OslcOAuthClient(String requestTokenURL, String authorizationTokenURL, String accessTokenURL, String consumerKey, String consumerSecret, String oauthRealmName, String callback) {
        OAuthServiceProvider provider = new OAuthServiceProvider(requestTokenURL, authorizationTokenURL, accessTokenURL);
        OAuthConsumer consumer = new OAuthConsumer(callback, consumerKey, consumerSecret, provider);
        this.accessor = new OAuthAccessor(consumer);
        this.oauth_real_name = oauthRealmName;
    }

    public OslcOAuthClient(String consumerKey, String consumerSecret) {
        OAuthServiceProvider provider = new OAuthServiceProvider(null, null, null);
        OAuthConsumer consumer = new OAuthConsumer("", consumerKey, consumerSecret, provider);
        this.accessor = new OAuthAccessor(consumer);
        this.accessor.accessToken = "";
    }

    @Override
    public ClientResponse getResource(String url, String mediaType) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage message = this.getResourceInternal(url, "GET", false);
        String realm = "Jazz";
        if (this.oauth_real_name != null) {
            realm = this.oauth_real_name;
        }
        String authHeader = message.getAuthorizationHeader(realm);
        ClientConfig config = this.getClientConfig();
        RestClient restClient = new RestClient(config);
        return restClient.resource(url).accept(mediaType).header("Authorization", authHeader).header("OSLC-Core-Version", "2.0").get();
    }

    @Override
    public ClientResponse updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage message = this.getResourceInternal(url, "PUT", false);
        String realm = "Jazz";
        if (this.oauth_real_name != null) {
            realm = this.oauth_real_name;
        }
        String authHeader = message.getAuthorizationHeader(realm);
        ClientConfig config = this.getClientConfig();
        RestClient restClient = new RestClient(config);
        return restClient.resource(url).contentType(mediaType).accept(acceptType).header("Authorization", authHeader).header("If-Match", ifMatch).header("OSLC-Core-Version", "2.0").header("If-Match", ifMatch).put(artifact);
    }

    @Override
    public ClientResponse createResource(String url, Object artifact, String mediaType, String acceptType) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage message = this.getResourceInternal(url, "POST", false);
        String realm = "Jazz";
        if (this.oauth_real_name != null) {
            realm = this.oauth_real_name;
        }
        String authHeader = message.getAuthorizationHeader(realm);
        ClientConfig config = this.getClientConfig();
        RestClient restClient = new RestClient(config);
        return restClient.resource(url).contentType(mediaType).accept(acceptType).header("Authorization", authHeader).header("OSLC-Core-Version", "2.0").post(artifact);
    }

    protected OAuthMessage getResourceInternal(String url, String httpMethod, boolean restart) throws IOException, OAuthException, URISyntaxException {
        OAuthClient client = new OAuthClient((HttpClient)new HttpClient4(this.getClientPool()));
        if (!this.isTwoLegged()) {
            if (this.accessor.requestToken == null) {
                client.getRequestToken(this.accessor);
                System.out.println("Enter this URL in a browser and run again: " + this.accessor.consumer.serviceProvider.userAuthorizationURL + "?oauth_token=" + this.accessor.requestToken);
                throw new OAuthRedirectException(this.accessor.consumer.serviceProvider.userAuthorizationURL, this.accessor);
            }
            if (this.accessor.accessToken == null) {
                try {
                    client.getAccessToken(this.accessor, "POST", null);
                }
                catch (OAuthException e) {
                    LOGGER.debug((Object)("OAuthException caught: " + e.getMessage()));
                    if (restart) {
                        LOGGER.error((Object)"Failed to get access key.");
                        e.printStackTrace();
                    }
                    this.accessor.accessToken = null;
                    this.accessor.requestToken = null;
                    return this.getResourceInternal(url, httpMethod, true);
                }
            }
        }
        OAuthMessage message = this.accessor.newRequestMessage(httpMethod, url, null);
        return message;
    }

    protected boolean isTwoLegged() {
        return "".equals(this.accessor.accessToken);
    }
}

