/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.wadl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import plugin.rtc.javax.ws.rs.DefaultValue;
import plugin.rtc.javax.ws.rs.FormParam;
import plugin.rtc.javax.ws.rs.HeaderParam;
import plugin.rtc.javax.ws.rs.MatrixParam;
import plugin.rtc.javax.ws.rs.Path;
import plugin.rtc.javax.ws.rs.PathParam;
import plugin.rtc.javax.ws.rs.QueryParam;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.org.apache.wink.common.DynamicResource;
import plugin.rtc.org.apache.wink.common.internal.registry.Injectable;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.uritemplate.JaxRsUriTemplateProcessor;
import plugin.rtc.org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import plugin.rtc.org.apache.wink.common.model.wadl.Application;
import plugin.rtc.org.apache.wink.common.model.wadl.Doc;
import plugin.rtc.org.apache.wink.common.model.wadl.Method;
import plugin.rtc.org.apache.wink.common.model.wadl.Param;
import plugin.rtc.org.apache.wink.common.model.wadl.ParamStyle;
import plugin.rtc.org.apache.wink.common.model.wadl.Representation;
import plugin.rtc.org.apache.wink.common.model.wadl.Request;
import plugin.rtc.org.apache.wink.common.model.wadl.Resource;
import plugin.rtc.org.apache.wink.common.model.wadl.Resources;
import plugin.rtc.org.apache.wink.common.model.wadl.Response;
import plugin.rtc.org.apache.wink.common.model.wadl.WADLDoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WADLGenerator {
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";

    public Application generate(String baseURI, Set<Class<?>> classes) {
        Application app = new Application();
        if (classes == null || classes.isEmpty()) {
            return app;
        }
        Resources resources = new Resources();
        resources.setBase(baseURI);
        Set<ClassMetadata> metadataSet = this.buildClassMetdata(classes);
        resources.getResource().addAll(this.buildResources(metadataSet));
        app.getResources().add(resources);
        return app;
    }

    Set<ClassMetadata> buildClassMetdata(Set<Class<?>> classes) {
        HashSet<ClassMetadata> metadataSet = new HashSet<ClassMetadata>(classes.size());
        for (Class<?> c : classes) {
            if (!this.isResource(c)) continue;
            ClassMetadata metadata = ResourceMetadataCollector.collectMetadata(c);
            metadataSet.add(metadata);
        }
        return metadataSet;
    }

    Set<Resource> buildResources(Set<ClassMetadata> metadataSet) {
        HashSet<Resource> s = new HashSet<Resource>(metadataSet.size());
        for (ClassMetadata metadata : metadataSet) {
            Resource r = this.buildResource(metadata);
            s.add(r);
        }
        return s;
    }

    Resource buildResource(ClassMetadata metadata) {
        List<Param> subResParams;
        Resource subRes;
        List<Injectable> fields;
        Class<?> resClass;
        String path;
        WADLDoc d;
        Class<?> resClass2;
        Resource r = new Resource();
        if (metadata != null && (resClass2 = metadata.getResourceClass()) != null && (d = resClass2.getAnnotation(WADLDoc.class)) != null) {
            r.getDoc().add(this.getDocument(d));
        }
        if ((path = metadata.getPath()) == null && DynamicResource.class.isAssignableFrom(resClass = metadata.getResourceClass())) {
            try {
                DynamicResource dynRes = (DynamicResource)resClass.newInstance();
                path = dynRes.getPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        UriTemplateProcessor processor = JaxRsUriTemplateProcessor.newNormalizedInstance(path);
        String pathStr = processor.getTemplate();
        for (String var : processor.getVariableNames()) {
            pathStr = pathStr.replaceAll("\\{(\\s)*" + var + "(\\s)*:.*\\}", "{" + var + "}");
        }
        r.setPath(pathStr);
        List<Object> methodOrSubresource = r.getMethodOrResource();
        List<Param> resourceParams = r.getParam();
        List<MethodMetadata> methodMetadata = metadata.getResourceMethods();
        if (methodMetadata != null && !methodMetadata.isEmpty()) {
            for (MethodMetadata methodMeta : methodMetadata) {
                Method m = this.buildMethod(metadata, methodMeta);
                methodOrSubresource.add(m);
                List<Injectable> params = methodMeta.getFormalParameters();
                if (params == null || params.size() <= 0) continue;
                for (Injectable p : params) {
                    Param param = null;
                    boolean isUnique = true;
                    switch (p.getParamType()) {
                        case QUERY: {
                            break;
                        }
                        case HEADER: {
                            break;
                        }
                        case ENTITY: {
                            break;
                        }
                        case COOKIE: {
                            break;
                        }
                        case FORM: {
                            break;
                        }
                        case PATH: {
                            param = this.buildParam(p);
                            for (Param rParam : resourceParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            resourceParams.add(param);
                            break;
                        }
                        case MATRIX: {
                            param = this.buildParam(p);
                            for (Param rParam : resourceParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            resourceParams.add(param);
                            break;
                        }
                    }
                }
            }
        }
        if ((fields = metadata.getInjectableFields()) != null) {
            for (Injectable p : metadata.getInjectableFields()) {
                Param param = null;
                boolean isUnique = true;
                switch (p.getParamType()) {
                    case QUERY: {
                        resourceParams.add(this.buildParam(p));
                        break;
                    }
                    case HEADER: {
                        resourceParams.add(this.buildParam(p));
                        break;
                    }
                    case ENTITY: {
                        break;
                    }
                    case COOKIE: {
                        break;
                    }
                    case FORM: {
                        break;
                    }
                    case PATH: {
                        param = this.buildParam(p);
                        for (Param rParam : resourceParams) {
                            if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                            isUnique = false;
                        }
                        if (!isUnique) break;
                        resourceParams.add(param);
                        break;
                    }
                    case MATRIX: {
                        param = this.buildParam(p);
                        for (Param rParam : resourceParams) {
                            if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                            isUnique = false;
                        }
                        if (!isUnique) break;
                        resourceParams.add(param);
                        break;
                    }
                }
            }
        }
        if ((methodMetadata = metadata.getSubResourceMethods()) != null && !methodMetadata.isEmpty()) {
            for (MethodMetadata methodMeta : methodMetadata) {
                subRes = new Resource();
                Method m = this.buildMethod(metadata, methodMeta);
                subRes.getMethodOrResource().add(m);
                subRes.setPath(methodMeta.getPath());
                methodOrSubresource.add(subRes);
                subResParams = subRes.getParam();
                List<Injectable> params = methodMeta.getFormalParameters();
                if (params == null || params.size() <= 0) continue;
                for (Injectable p : params) {
                    Param param = null;
                    boolean isUnique = true;
                    switch (p.getParamType()) {
                        case QUERY: {
                            break;
                        }
                        case HEADER: {
                            break;
                        }
                        case ENTITY: {
                            break;
                        }
                        case COOKIE: {
                            break;
                        }
                        case FORM: {
                            break;
                        }
                        case PATH: {
                            param = this.buildParam(p);
                            for (Param rParam : subResParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            subRes.getParam().add(param);
                            break;
                        }
                        case MATRIX: {
                            param = this.buildParam(p);
                            for (Param rParam : subResParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            subRes.getParam().add(param);
                            break;
                        }
                    }
                }
            }
        }
        if ((methodMetadata = metadata.getSubResourceLocators()) != null && !methodMetadata.isEmpty()) {
            for (MethodMetadata methodMeta : methodMetadata) {
                WADLDoc d2;
                java.lang.reflect.Method reflMethod;
                subRes = new Resource();
                subRes.setPath(methodMeta.getPath());
                if (methodMeta != null && (reflMethod = methodMeta.getReflectionMethod()) != null && (d2 = reflMethod.getAnnotation(WADLDoc.class)) != null) {
                    subRes.getDoc().add(this.getDocument(d2));
                }
                methodOrSubresource.add(subRes);
                List<Injectable> params = methodMeta.getFormalParameters();
                subResParams = subRes.getParam();
                if (params == null || params.size() <= 0) continue;
                for (Injectable p : params) {
                    Param param = null;
                    boolean isUnique = true;
                    switch (p.getParamType()) {
                        case QUERY: {
                            param = this.buildParam(p);
                            for (Param rParam : subResParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            subRes.getParam().add(param);
                            break;
                        }
                        case HEADER: {
                            param = this.buildParam(p);
                            for (Param rParam : subResParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            subRes.getParam().add(param);
                            break;
                        }
                        case ENTITY: {
                            break;
                        }
                        case COOKIE: {
                            break;
                        }
                        case FORM: {
                            break;
                        }
                        case PATH: {
                            param = this.buildParam(p);
                            for (Param rParam : subResParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            subRes.getParam().add(param);
                            break;
                        }
                        case MATRIX: {
                            param = this.buildParam(p);
                            for (Param rParam : subResParams) {
                                if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                                isUnique = false;
                            }
                            if (!isUnique) break;
                            subRes.getParam().add(param);
                            break;
                        }
                    }
                }
            }
        }
        return r;
    }

    Method buildMethod(ClassMetadata classMetadata, MethodMetadata metadata) {
        List<Response> resp;
        Request r;
        WADLDoc d;
        Method m = new Method();
        m.setName(metadata.getHttpMethod());
        java.lang.reflect.Method reflMethod = metadata.getReflectionMethod();
        if (reflMethod != null && (d = reflMethod.getAnnotation(WADLDoc.class)) != null) {
            m.getDoc().add(this.getDocument(d));
        }
        if ((r = this.buildRequest(classMetadata, metadata)) != null) {
            m.setRequest(r);
        }
        if ((resp = this.buildResponse(metadata)) != null) {
            m.getResponse().addAll(resp);
        }
        return m;
    }

    Request buildRequest(ClassMetadata classMetadata, MethodMetadata metadata) {
        Request r = null;
        List<Injectable> params = metadata.getFormalParameters();
        if (params != null && params.size() > 0) {
            if (r == null) {
                r = new Request();
            }
            boolean hasValidParams = false;
            List<Param> requestParams = r.getParam();
            for (Injectable p : params) {
                Param param = null;
                boolean isUnique = true;
                switch (p.getParamType()) {
                    case QUERY: {
                        hasValidParams = true;
                        param = this.buildParam(p);
                        for (Param rParam : requestParams) {
                            if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                            isUnique = false;
                        }
                        if (!isUnique) break;
                        requestParams.add(this.buildParam(p));
                        break;
                    }
                    case HEADER: {
                        hasValidParams = true;
                        param = this.buildParam(p);
                        for (Param rParam : requestParams) {
                            if (param.getName() == null || !param.getName().equals(rParam.getName()) || !rParam.getStyle().equals((Object)param.getStyle())) continue;
                            isUnique = false;
                        }
                        if (!isUnique) break;
                        requestParams.add(this.buildParam(p));
                        break;
                    }
                    case ENTITY: {
                        Set<Representation> representations;
                        hasValidParams = true;
                        Annotation[] anns = p.getAnnotations();
                        if (anns != null && anns.length > 0) {
                            for (Annotation a : anns) {
                                if (!WADLDoc.class.equals(a.annotationType())) continue;
                                WADLDoc d = (WADLDoc)a;
                                r.getDoc().add(this.getDocument(d));
                            }
                        }
                        if ((representations = this.buildIncomingRepresentation(classMetadata, metadata, p)) == null) break;
                        r.getRepresentation().addAll(representations);
                        break;
                    }
                    case COOKIE: {
                        break;
                    }
                    case FORM: {
                        break;
                    }
                    case PATH: {
                        break;
                    }
                    case MATRIX: {
                        break;
                    }
                }
            }
            if (!hasValidParams) {
                r = null;
            }
        }
        return r;
    }

    Param buildParam(Injectable paramMetadata) {
        Param p = null;
        Injectable.ParamType pt = paramMetadata.getParamType();
        Annotation[] annotations = paramMetadata.getAnnotations();
        switch (pt) {
            case HEADER: {
                Annotation paramAnn;
                p = new Param();
                p.setStyle(ParamStyle.HEADER);
                if (annotations == null) break;
                for (Annotation a : annotations) {
                    if (!HeaderParam.class.equals(a.annotationType())) continue;
                    paramAnn = (HeaderParam)a;
                    p.setName(paramAnn.value());
                }
                break;
            }
            case MATRIX: {
                Annotation paramAnn;
                p = new Param();
                p.setStyle(ParamStyle.MATRIX);
                for (Annotation a : annotations) {
                    if (!MatrixParam.class.equals(a.annotationType())) continue;
                    paramAnn = (MatrixParam)a;
                    p.setName(paramAnn.value());
                }
                break;
            }
            case PATH: {
                Annotation paramAnn;
                p = new Param();
                p.setStyle(ParamStyle.TEMPLATE);
                for (Annotation a : annotations) {
                    if (!PathParam.class.equals(a.annotationType())) continue;
                    paramAnn = (PathParam)a;
                    p.setName(paramAnn.value());
                }
                break;
            }
            case QUERY: {
                Annotation paramAnn;
                p = new Param();
                p.setStyle(ParamStyle.QUERY);
                for (Annotation a : annotations) {
                    if (!QueryParam.class.equals(a.annotationType())) continue;
                    paramAnn = (QueryParam)a;
                    p.setName(paramAnn.value());
                }
                break;
            }
            case FORM: {
                Annotation paramAnn;
                p = new Param();
                p.setStyle(ParamStyle.QUERY);
                for (Annotation a : annotations) {
                    if (!FormParam.class.equals(a.annotationType())) continue;
                    paramAnn = (FormParam)a;
                    p.setName(paramAnn.value());
                }
                break;
            }
            case CONTEXT: {
                break;
            }
            case COOKIE: {
                break;
            }
        }
        if (p == null) {
            return null;
        }
        Class<?> memberType = paramMetadata.getType();
        if (memberType.equals(Integer.TYPE) || memberType.equals(Integer.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "int"));
        } else if (memberType.equals(Float.TYPE) || memberType.equals(Float.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "float"));
        } else if (memberType.equals(Long.TYPE) || memberType.equals(Long.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "long"));
        } else if (memberType.equals(Boolean.TYPE) || memberType.equals(Boolean.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "boolean"));
        } else if (memberType.equals(Short.TYPE) || memberType.equals(Short.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "short"));
        } else if (memberType.equals(Double.TYPE) || memberType.equals(Double.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "double"));
        } else if (memberType.equals(Byte.TYPE) || memberType.equals(Byte.class)) {
            p.setType(new QName(XML_SCHEMA_NS, "byte"));
        }
        for (Annotation a : annotations) {
            if (DefaultValue.class.equals(a.annotationType())) {
                DefaultValue paramAnn = (DefaultValue)a;
                p.setDefault(paramAnn.value());
            }
            if (!WADLDoc.class.equals(a.annotationType())) continue;
            WADLDoc d = (WADLDoc)a;
            p.getDoc().add(this.getDocument(d));
        }
        return p;
    }

    Set<Representation> buildIncomingRepresentation(ClassMetadata classMetadata, MethodMetadata methodMetadata, Injectable metadata) {
        if (methodMetadata == null) {
            return null;
        }
        if (metadata != null && metadata.getParamType() != Injectable.ParamType.ENTITY) {
            throw new IllegalArgumentException("Parameter data is not for an entity.");
        }
        Set<MediaType> consumesMT = methodMetadata.getConsumes();
        HashSet<Representation> reps = null;
        if (consumesMT != null && !consumesMT.isEmpty()) {
            reps = new HashSet<Representation>();
            for (MediaType mt : consumesMT) {
                Representation r = new Representation();
                r.setMediaType(mt.toString());
                ArrayList<Param> params = new ArrayList<Param>();
                if (mt.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE) || mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
                    List<Injectable> injectables = methodMetadata.getFormalParameters();
                    if (injectables != null) {
                        for (Injectable i : injectables) {
                            if (!Injectable.ParamType.FORM.equals((Object)i.getParamType())) continue;
                            params.add(this.buildParam(i));
                        }
                    }
                    if (!params.isEmpty()) {
                        r.getParam().addAll(params);
                    }
                }
                reps.add(r);
            }
        } else if (metadata == null) {
            return null;
        }
        return reps;
    }

    List<Response> buildResponse(MethodMetadata metadata) {
        java.lang.reflect.Method m;
        if (metadata == null) {
            return null;
        }
        Response r = null;
        Set<Representation> representations = this.buildOutgoingRepresentation(metadata, null);
        if (representations != null && !representations.isEmpty()) {
            r = new Response();
            r.getRepresentation().addAll(representations);
        }
        if (Void.TYPE.equals((m = metadata.getReflectionMethod()).getReturnType())) {
            if (r == null) {
                r = new Response();
            }
            r.getStatus().add(204L);
        } else if (!plugin.rtc.javax.ws.rs.core.Response.class.isAssignableFrom(m.getReturnType())) {
            if (r == null) {
                r = new Response();
            }
            r.getStatus().add(200L);
        }
        return Collections.singletonList(r);
    }

    Set<Representation> buildOutgoingRepresentation(MethodMetadata methodMetadata, Class<?> returnType) {
        if (methodMetadata == null) {
            return null;
        }
        Set<MediaType> producesMT = methodMetadata.getProduces();
        HashSet<Representation> reps = null;
        if (producesMT != null && !producesMT.isEmpty()) {
            reps = new HashSet<Representation>();
            for (MediaType mt : producesMT) {
                Representation r = new Representation();
                r.setMediaType(mt.toString());
                reps.add(r);
            }
        }
        return reps;
    }

    Doc getDocument(WADLDoc desc) {
        Doc d = new Doc();
        d.setTitle(desc.value());
        if (!"".equals(desc.content())) {
            d.getContent().add(desc.content());
        }
        return d;
    }

    protected boolean isResource(Class<?> cls) {
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            return true;
        }
        if (cls.getAnnotation(Path.class) != null) {
            return true;
        }
        Class<?> declaringClass = cls;
        while (!declaringClass.equals(Object.class)) {
            Class<?>[] interfaces;
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass.getAnnotation(Path.class) != null) {
                return true;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                if (interfaceClass.getAnnotation(Path.class) == null) continue;
                return true;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        return false;
    }
}

