/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.synd;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.Providers;
import plugin.rtc.org.apache.wink.common.internal.model.ModelUtils;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCommonAttributes;
import plugin.rtc.org.apache.wink.common.model.synd.SyndTextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyndSimpleContent
extends SyndCommonAttributes {
    private Object value;
    protected String type;
    protected Providers providers;

    public SyndSimpleContent() {
    }

    public SyndSimpleContent(Object value) {
        this(value, SyndTextType.text.name());
    }

    public SyndSimpleContent(Object value, String type) {
        this.value = value;
        this.type = type;
    }

    public SyndSimpleContent(SyndSimpleContent other) {
        super(other);
        this.value = other.value;
        this.type = other.type;
    }

    public String getValue() {
        return this.getValue(String.class);
    }

    public <T> T getValue(Class<T> cls) {
        try {
            return this.getValue(cls, cls, this.providers, ModelUtils.EMPTY_ARRAY, ModelUtils.EMPTY_STRING_MAP, ModelUtils.determineMediaType(this.type));
        }
        catch (IOException e) {
            throw new WebApplicationException(e);
        }
    }

    public <T> T getValue(Class<T> cls, Type genericType, Providers providers, Annotation[] annotations, MultivaluedMap<String, String> httpHeaders, MediaType mediaType) throws IOException {
        return ModelUtils.readValue(Arrays.asList(this.value), cls, providers, genericType, annotations, httpHeaders, mediaType);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyndSimpleContent other = (SyndSimpleContent)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

