/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.utils;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class ExceptionHelper {
    private static final int MAX_CHARS = 20000;
    private static final boolean PRINT_STACK_TRACE = true;

    private ExceptionHelper() {
    }

    public static String toString(Throwable t) {
        String s = ExceptionHelper.stackTraceToString(t);
        if (s == null) {
            s = "Exception " + t.getClass().getName() + " : " + t.getMessage();
        }
        return s;
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter descr = new StringWriter(){
            boolean writeOK = true;

            public void write(char[] cbuf, int off, int len) {
                if (this.canWrite()) {
                    super.write(cbuf, off, len);
                }
            }

            public void write(int c) {
                if (this.canWrite()) {
                    super.write(c);
                }
            }

            public void write(String str, int off, int len) {
                if (this.canWrite()) {
                    super.write(str, off, len);
                }
            }

            public void write(String str) {
                if (this.canWrite()) {
                    super.write(str);
                }
            }

            private boolean canWrite() {
                if (this.writeOK && this.getBuffer().length() > 20000) {
                    super.write(" ... [ too long - truncated ]");
                    this.writeOK = false;
                }
                return this.writeOK;
            }
        };
        t.printStackTrace(new PrintWriter(descr));
        return descr.toString();
    }
}

