/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyReader;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.org.apache.wink.common.internal.providers.entity.csv.CsvReader;
import plugin.rtc.org.apache.wink.common.model.csv.CsvDeserializer;
import plugin.rtc.org.apache.wink.common.utils.ProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"text/csv"})
public class CsvDeserializerProvider<T extends CsvDeserializer>
implements MessageBodyReader<T> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return CsvDeserializer.class.isAssignableFrom(type);
    }

    @Override
    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        CsvDeserializer descriptor;
        try {
            descriptor = (CsvDeserializer)type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
        return (T)CsvDeserializerProvider.fillDiscriptor(descriptor, mediaType, entityStream);
    }

    public static <T extends CsvDeserializer> T fillDiscriptor(T descriptor, MediaType mediaType, InputStream entityStream) {
        String[] line;
        Charset charset = Charset.forName(ProviderUtils.getCharset(mediaType));
        InputStreamReader reader = new InputStreamReader(entityStream, charset);
        CsvReader csvReader = new CsvReader(reader);
        while ((line = csvReader.readLine()) != null) {
            descriptor.addEntity(line);
        }
        return descriptor;
    }
}

