/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.lifecycle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.LifecycleManager;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.LifecycleManagerUtils;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.ObjectFactory;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.SingletonObjectFactory;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultLifecycleManager<T>
implements LifecycleManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLifecycleManager.class);

    DefaultLifecycleManager() {
    }

    @Override
    public ObjectFactory<T> createObjectFactory(T object) {
        if (object == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "object"));
        }
        logger.trace("Creating a {} for {}", SingletonObjectFactory.class, object);
        return LifecycleManagerUtils.createSingletonObjectFactory(object);
    }

    @Override
    public ObjectFactory<T> createObjectFactory(Class<T> cls) {
        logger.trace("Entry {}", cls);
        if (cls == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "cls"));
        }
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            throw new IllegalArgumentException(Messages.getMessage("cannotCreateDefaultFactoryForDR", String.valueOf(cls)));
        }
        ObjectFactory<T> ret = null;
        if (ApplicationMetadataCollector.isApplication(cls)) {
            ret = LifecycleManagerUtils.createSingletonObjectFactory(cls);
        } else if (ProviderMetadataCollector.isProvider(cls)) {
            ret = LifecycleManagerUtils.createSingletonObjectFactory(cls);
        } else if (ResourceMetadataCollector.isStaticResource(cls)) {
            ret = LifecycleManagerUtils.createPrototypeObjectFactory(cls);
        }
        if (ret != null) {
            logger.trace("Exit {}", ret);
            return ret;
        }
        throw new IllegalArgumentException(Messages.getMessage("cannotCreateDefaultFactoryFor", String.valueOf(cls)));
    }
}

