/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.client.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.org.apache.wink.client.ClientAuthenticationException;
import plugin.rtc.org.apache.wink.client.ClientRequest;
import plugin.rtc.org.apache.wink.client.ClientResponse;
import plugin.rtc.org.apache.wink.client.handlers.AbstractAuthSecurityHandler;
import plugin.rtc.org.apache.wink.client.handlers.ClientHandler;
import plugin.rtc.org.apache.wink.client.handlers.HandlerContext;
import plugin.rtc.org.apache.wink.common.http.HttpStatus;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;

public class BasicAuthSecurityHandler
extends AbstractAuthSecurityHandler
implements ClientHandler {
    private static Logger logger = LoggerFactory.getLogger(BasicAuthSecurityHandler.class);
    private static final int UNAUTHORIZED = HttpStatus.UNAUTHORIZED.getCode();

    public BasicAuthSecurityHandler() {
    }

    public BasicAuthSecurityHandler(String username, String password) {
        super(username, password);
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        logger.trace("Entering BasicAuthSecurityHandler.doChain()");
        ClientResponse response = context.doChain(request);
        if (response.getStatusCode() == UNAUTHORIZED) {
            if (this.handlerUsername != null && !this.handlerUsername.equals("") && this.handlerPassword != null && !this.handlerPassword.equals("")) {
                logger.trace("userid and password set so setting Authorization header");
                if (this.handlerEncodedCredentials == null) {
                    this.handlerEncodedCredentials = BasicAuthSecurityHandler.getEncodedString(this.handlerUsername, this.handlerPassword);
                }
                request.getHeaders().putSingle("Authorization", this.handlerEncodedCredentials);
                logger.trace("Issuing request again with Authorization header");
                response = context.doChain(request);
                if (response.getStatusCode() == UNAUTHORIZED) {
                    logger.trace("After sending request with Authorization header, still got " + UNAUTHORIZED + " response");
                    throw new ClientAuthenticationException(Messages.getMessage("serviceFailedToAuthenticateUser", this.handlerUsername));
                }
                logger.trace("Got a non-" + UNAUTHORIZED + " response, so returning response");
                return response;
            }
            logger.trace("user and/or password were not set so throwing exception");
            throw new ClientAuthenticationException(Messages.getMessage("missingClientAuthenticationCredentialForUser", this.handlerUsername));
        }
        logger.trace("Status code was not " + UNAUTHORIZED + " so no need to re-issue request.");
        return response;
    }
}

