/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.core.Application;
import plugin.rtc.org.apache.wink.client.ClientConfig;
import plugin.rtc.org.apache.wink.client.Resource;
import plugin.rtc.org.apache.wink.client.internal.ResourceImpl;
import plugin.rtc.org.apache.wink.common.WinkApplication;
import plugin.rtc.org.apache.wink.common.internal.application.ApplicationValidator;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.ScopeLifecycleManager;
import plugin.rtc.org.apache.wink.common.internal.registry.ProvidersRegistry;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    private ProvidersRegistry providersRegistry;
    private ClientConfig config;

    public RestClient() {
        this(new ClientConfig());
    }

    public RestClient(ClientConfig config) {
        ClientConfig clone = config.clone();
        this.config = clone.build();
        this.initProvidersRegistry();
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public Resource resource(URI uri) {
        return new ResourceImpl(uri, this.config, this.providersRegistry);
    }

    public Resource resource(String uri) {
        return this.resource(URI.create(uri));
    }

    public Resource resource(String uri, boolean httpEncode) throws MalformedURLException, URISyntaxException {
        if (httpEncode) {
            URL url = new URL(uri);
            URI constructedURI = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
            return this.resource(constructedURI);
        }
        return this.resource(URI.create(uri));
    }

    private void initProvidersRegistry() {
        LifecycleManagersRegistry ofFactoryRegistry = new LifecycleManagersRegistry();
        ofFactoryRegistry.addFactoryFactory(new ScopeLifecycleManager());
        this.providersRegistry = new ProvidersRegistry(ofFactoryRegistry, new ApplicationValidator());
        for (Application app : this.config.getApplications()) {
            this.processApplication(app);
        }
    }

    private void processApplication(Application application) {
        Set<Class<?>> classes;
        if (application == null) {
            return;
        }
        Set<Object> singletons = application.getSingletons();
        if (singletons != null && singletons.size() > 0) {
            this.processSingletons(singletons);
        }
        if ((classes = application.getClasses()) != null && classes.size() > 0) {
            this.processClasses(classes);
        }
        if (application instanceof WinkApplication) {
            this.processWinkApplication((WinkApplication)application);
        }
    }

    private void processClasses(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            if (ProviderMetadataCollector.isProvider(cls)) {
                try {
                    this.providersRegistry.addProvider(cls);
                }
                catch (Exception e) {
                    logger.warn(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls));
                    logger.warn(Messages.getMessage("listExceptionDuringClassProcessing"), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    logger.warn(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()));
                    logger.warn(Messages.getMessage("listExceptionDuringClassProcessing"), (Throwable)e);
                }
                continue;
            }
            logger.warn(Messages.getMessage("classNotAProvider", cls));
        }
    }

    private void processSingletons(Set<Object> singletons) {
        for (Object obj : singletons) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                try {
                    this.providersRegistry.addProvider(obj);
                }
                catch (Exception e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                continue;
            }
            logger.warn(Messages.getMessage("classNotAProvider", obj));
        }
    }

    private void processWinkApplication(WinkApplication sApplication) {
        Set<Object> instances = sApplication.getInstances();
        double priority = sApplication.getPriority();
        if (instances == null) {
            return;
        }
        for (Object obj : instances) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                try {
                    this.providersRegistry.addProvider(obj, priority);
                }
                catch (Exception e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                continue;
            }
            logger.warn(Messages.getMessage("classNotAProvider", cls));
        }
    }
}

