/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner;

import plugin.rtc.com.hp.hpl.jena.graph.Capabilities;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.reasoner.BaseInfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.FGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.Finder;
import plugin.rtc.com.hp.hpl.jena.reasoner.IllegalParameterException;
import plugin.rtc.com.hp.hpl.jena.reasoner.InfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.Reasoner;
import plugin.rtc.com.hp.hpl.jena.reasoner.ReasonerException;
import plugin.rtc.com.hp.hpl.jena.reasoner.ReasonerFactory;
import plugin.rtc.com.hp.hpl.jena.reasoner.ReasonerRegistry;
import plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveInfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDFS;
import plugin.rtc.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class TransitiveReasoner
implements Reasoner {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder tbox = null;
    public static final Node directSubPropertyOf = ReasonerRegistry.makeDirect(RDFS.Nodes.subPropertyOf);
    public static final Node directSubClassOf = ReasonerRegistry.makeDirect(RDFS.Nodes.subClassOf);
    public static final Node subPropertyOf = RDFS.Nodes.subPropertyOf;
    public static final Node subClassOf = RDFS.Nodes.subClassOf;
    protected Capabilities capabilities;

    public TransitiveReasoner() {
        this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
        this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
    }

    protected TransitiveReasoner(Finder tbox, TransitiveGraphCache subClassCache, TransitiveGraphCache subPropertyCache) {
        this.tbox = tbox;
        this.subClassCache = subClassCache;
        this.subPropertyCache = subPropertyCache;
    }

    @Override
    public Model getReasonerCapabilities() {
        return TransitiveReasonerFactory.theInstance().getCapabilities();
    }

    @Override
    public void addDescription(Model configSpec, Resource base) {
    }

    @Override
    public boolean supportsProperty(Property property) {
        ReasonerFactory rf = TransitiveReasonerFactory.theInstance();
        Model caps = rf.getCapabilities();
        Resource root = caps.getResource(rf.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        return this.bindSchema(new FGraph(tbox));
    }

    @Override
    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return this.bindSchema(new FGraph(tbox.getGraph()));
    }

    Reasoner bindSchema(Finder tbox) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        TransitiveGraphCache sCc = new TransitiveGraphCache(directSubClassOf, subClassOf);
        TransitiveGraphCache sPc = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
        TransitiveEngine.cacheSubPropUtility(tbox, sPc);
        TransitiveEngine.cacheSubClassUtility(tbox, sPc, sCc);
        return new TransitiveReasoner(tbox, sCc, sPc);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        return new TransitiveInfGraph(data, this);
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
    }

    @Override
    public void setParameter(Property parameter, Object value) {
        throw new IllegalParameterException(parameter.toString());
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public Finder getTbox() {
        return this.tbox;
    }

    @Override
    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

