/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl;

import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.NodeFactory;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;

public class LPBindingEnvironment
implements BindingEnvironment {
    protected LPInterpreter interpreter;

    public LPBindingEnvironment(LPInterpreter interpeter) {
        this.interpreter = interpeter;
    }

    @Override
    public Node getGroundVersion(Node node) {
        return LPInterpreter.deref(node);
    }

    @Override
    public boolean bind(Node var, Node value) {
        Node dvar = var;
        if (dvar instanceof Node_RuleVariable) {
            dvar = ((Node_RuleVariable)dvar).deref();
        }
        if (dvar instanceof Node_RuleVariable) {
            this.interpreter.bind(dvar, value);
            return true;
        }
        return var.sameValueAs(value);
    }

    @Override
    public Triple instantiate(TriplePattern pattern) {
        Node o;
        Node p;
        Node s = this.getGroundVersion(pattern.getSubject());
        if (s.isVariable()) {
            s = NodeFactory.createAnon();
        }
        if ((p = this.getGroundVersion(pattern.getPredicate())).isVariable()) {
            p = NodeFactory.createAnon();
        }
        if ((o = this.getGroundVersion(pattern.getObject())).isVariable()) {
            o = NodeFactory.createAnon();
        }
        return new Triple(s, p, o);
    }
}

