/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.exceptions;

import java.util.ArrayList;
import java.util.List;
import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;

public class AmbiguousSpecificTypeException
extends AssemblerException {
    protected final List<Resource> types;

    public AmbiguousSpecificTypeException(Resource root, ArrayList<Resource> types) {
        super(root, AmbiguousSpecificTypeException.makeMessage(root, types));
        this.types = types;
    }

    private static String makeMessage(Resource root, List<Resource> types) {
        return "cannot find a most specific type for " + AmbiguousSpecificTypeException.nice(root) + ", which has as possibilities:" + AmbiguousSpecificTypeException.nice(types) + ".";
    }

    private static String nice(List<Resource> types) {
        StringBuilder result = new StringBuilder();
        for (Resource type : types) {
            result.append(" ").append(AmbiguousSpecificTypeException.nice(type));
        }
        return result.toString();
    }

    public List<Resource> getTypes() {
        return this.types;
    }
}

