/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.assemblers;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.com.hp.hpl.jena.assembler.Assembler;
import plugin.rtc.com.hp.hpl.jena.assembler.JA;
import plugin.rtc.com.hp.hpl.jena.assembler.Mode;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.NamedModelAssembler;
import plugin.rtc.com.hp.hpl.jena.graph.impl.FileGraph;
import plugin.rtc.com.hp.hpl.jena.graph.impl.FileGraphMaker;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ModelFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.util.FileUtils;

public class FileModelAssembler
extends NamedModelAssembler
implements Assembler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileModelAssembler.class);

    @Override
    protected Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        this.checkType(root, JA.FileModel);
        File fullName = this.getFileName(root);
        boolean mayCreate = mode.permitCreateNew(root, fullName.toString());
        boolean mayReuse = mode.permitUseExisting(root, fullName.toString());
        boolean create = this.getBoolean(root, JA.create, mayCreate);
        boolean strict = this.getBoolean(root, JA.strict, mayCreate != mayReuse);
        String lang = this.getLanguage(root, fullName);
        return this.createFileModel(fullName, lang, create, strict);
    }

    public Model createFileModel(File fullName, String lang, boolean create, boolean strict) {
        FileGraph.NotifyOnClose notify = FileGraph.NotifyOnClose.ignore;
        FileGraph fileGraph = new FileGraph(notify, fullName, lang, create, strict);
        return ModelFactory.createModelForGraph(fileGraph);
    }

    protected String getLanguage(Resource root, File fullName) {
        Statement s = FileModelAssembler.getUniqueStatement(root, JA.fileEncoding);
        return s == null ? FileUtils.guessLang(fullName.toString()) : FileModelAssembler.getString(s);
    }

    protected File getFileName(Resource root) {
        String name = this.getModelName(root);
        boolean mapName = this.getBoolean(root, JA.mapName, false);
        String dir = this.getDirectoryName(root);
        return new File(dir, mapName ? FileGraphMaker.toFilename(name) : name);
    }

    private boolean getBoolean(Resource root, Property p, boolean ifAbsent) {
        RDFNode r = FileModelAssembler.getUnique(root, p);
        return r == null ? ifAbsent : (r.isLiteral() ? this.booleanSpelling(r.asNode().getLiteralLexicalForm()) : (r.isURIResource() ? this.booleanSpelling(r.asNode().getLocalName()) : false));
    }

    private boolean booleanSpelling(String spelling) {
        if (spelling.equalsIgnoreCase("true")) {
            return true;
        }
        if (spelling.equalsIgnoreCase("t")) {
            return true;
        }
        if (spelling.equalsIgnoreCase("1")) {
            return true;
        }
        if (spelling.equalsIgnoreCase("false")) {
            return false;
        }
        if (spelling.equalsIgnoreCase("f")) {
            return false;
        }
        if (spelling.equalsIgnoreCase("0")) {
            return false;
        }
        throw new IllegalArgumentException("boolean requires spelling true/false/t/f/0/1");
    }

    private String getDirectoryName(Resource root) {
        String dir = FileModelAssembler.getRequiredResource(root, JA.directory).getURI().replaceFirst("file:", "");
        try {
            dir = URLDecoder.decode(dir, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn(String.format("Failed to decode dir %s: %s", dir, e.getMessage()), (Throwable)e);
        }
        return dir;
    }
}

