/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.assemblers;

import java.util.List;
import plugin.rtc.com.hp.hpl.jena.assembler.Assembler;
import plugin.rtc.com.hp.hpl.jena.assembler.AssemblerHelp;
import plugin.rtc.com.hp.hpl.jena.assembler.Content;
import plugin.rtc.com.hp.hpl.jena.assembler.Mode;
import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.CannotConstructException;
import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.CannotLoadClassException;
import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.NotUniqueException;
import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.PropertyRequiredException;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Literal;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.shared.JenaException;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDF;

public abstract class AssemblerBase
implements Assembler {
    protected static final Map1<Statement, RDFNode> getObject = Statement.Util.getObject;

    @Override
    public final Object open(Resource root) {
        return this.open(this, root);
    }

    @Override
    public final Object open(Assembler a, Resource root) {
        return this.open(a, root, Mode.DEFAULT);
    }

    @Override
    public abstract Object open(Assembler var1, Resource var2, Mode var3);

    protected static Resource getUniqueResource(Resource root, Property property) {
        return (Resource)AssemblerBase.getUnique(root, property);
    }

    protected static Literal getUniqueLiteral(Resource root, Property property) {
        return (Literal)AssemblerBase.getUnique(root, property);
    }

    protected static Statement getUniqueStatement(Resource root, Property property) {
        List statements = root.listProperties(property).toList();
        if (statements.size() == 0) {
            return null;
        }
        if (statements.size() == 1) {
            return (Statement)statements.get(0);
        }
        throw new NotUniqueException(root, property);
    }

    protected static RDFNode getUnique(Resource root, Property property) {
        List<RDFNode> nodes = root.listProperties(property).mapWith(getObject).toList();
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        throw new NotUniqueException(root, property);
    }

    protected void checkType(Resource root, Resource type) {
        if (!root.hasProperty(RDF.type, type)) {
            throw new CannotConstructException(this.getClass(), root, type);
        }
    }

    @Override
    public Model openModel(Resource root, Mode mode) {
        return (Model)this.open(this, root, mode);
    }

    @Override
    public Model openModel(Resource root) {
        return this.openModel(root, Mode.DEFAULT);
    }

    public static Resource getRequiredResource(Resource root, Property p) {
        Resource R = AssemblerBase.getUniqueResource(root, p);
        if (R == null) {
            throw new PropertyRequiredException(root, p);
        }
        return R;
    }

    protected Literal getRequiredLiteral(Resource root, Property p) {
        Literal L = AssemblerBase.getUniqueLiteral(root, p);
        if (L == null) {
            throw new PropertyRequiredException(root, p);
        }
        return L;
    }

    protected static Resource getResource(Statement s) {
        return AssemblerHelp.getResource(s);
    }

    protected static String getString(Statement s) {
        return AssemblerHelp.getString(s);
    }

    protected static String getUniqueString(Resource root, Property property) {
        Statement s = AssemblerBase.getUniqueStatement(root, property);
        return s == null ? null : AssemblerHelp.getString(s);
    }

    protected static Class<?> loadClass(Resource root, String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new CannotLoadClassException(root, className, e);
        }
    }

    public static String getOptionalClassName(Resource root, Property classProperty) {
        RDFNode classNode = AssemblerBase.getUnique(root, classProperty);
        return classNode == null ? null : (classNode.isLiteral() ? classNode.asNode().getLiteralLexicalForm() : (classNode.isResource() ? AssemblerBase.mustBeJava(classNode.asNode().getURI()) : null));
    }

    private static String mustBeJava(String uri) {
        if (uri.startsWith("java:")) {
            return uri.substring(5);
        }
        throw new JenaException("class name URI must start with 'java:': " + uri);
    }

    protected static class MapObjectToContent
    implements Map1<Statement, Content> {
        protected final Assembler a;

        public MapObjectToContent(Assembler a) {
            this.a = a;
        }

        @Override
        public Content map1(Statement o) {
            return (Content)this.a.open(AssemblerBase.getResource(o));
        }
    }
}

