/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc.jazz;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.rtc.jazz.CustomJazzFormAuthClient;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ModelFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.javax.ws.rs.core.UriBuilder;
import plugin.rtc.org.apache.wink.client.ClientResponse;
import plugin.rtc.org.eclipse.lyo.client.exception.ResourceNotFoundException;
import plugin.rtc.org.eclipse.lyo.client.exception.RootServicesException;
import plugin.rtc.org.eclipse.lyo.client.oslc.OslcClient;
import plugin.rtc.org.eclipse.lyo.client.oslc.OslcOAuthClient;

public class CustomJazzRootServicesHelper {
    private String baseUrl;
    private String rootServicesUrl;
    private String catalogDomain;
    private String catalogNamespace;
    private String catalogProperty;
    private String catalogUrl;
    private Model rdfModel;
    String authorizationRealm;
    String requestTokenUrl;
    String authorizationTokenUrl;
    String accessTokenUrl;
    String requestConsumerKeyUrl;
    String consumerApprovalUrl;
    public static final String JFS_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/jfs/1.0/";
    public static final String JD_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/discovery/1.0/";
    private static final Logger logger = LoggerFactory.getLogger(CustomJazzRootServicesHelper.class);

    public CustomJazzRootServicesHelper(String url, String catalogDomain) throws RootServicesException {
        this.baseUrl = url;
        this.rootServicesUrl = UriBuilder.fromUri(this.baseUrl).path("rootservices").build(new Object[0]).toString();
        logger.debug(String.format("Fetching rootservices document at URL <%s>", this.rootServicesUrl));
        this.catalogDomain = catalogDomain;
        logger.debug(String.format("Using catalog domain <%s>", this.catalogDomain));
        if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/cm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/cm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/cm/1.0/";
            this.catalogProperty = "cmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/qm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/qm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/qm/1.0/";
            this.catalogProperty = "qmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/rm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/rm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/rm/1.0/";
            this.catalogProperty = "rmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/am#")) {
            this.catalogNamespace = "http://open-services.net/ns/am#";
            this.catalogProperty = "amServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/auto#")) {
            this.catalogNamespace = "http://open-services.net/ns/auto#";
            this.catalogProperty = "autoServiceProviders";
        } else {
            logger.error("Jazz rootservices only supports CM, RM, QM, and Automation catalogs");
        }
        this.processRootServices();
    }

    public String getCatalogUrl() {
        return this.catalogUrl;
    }

    public OslcOAuthClient initOAuthClient(String consumerKey, String secret) {
        return new OslcOAuthClient(this.requestTokenUrl, this.authorizationTokenUrl, this.accessTokenUrl, consumerKey, secret, this.authorizationRealm);
    }

    public CustomJazzFormAuthClient initFormClient(String userid, String password) {
        return new CustomJazzFormAuthClient(this.baseUrl, userid, password);
    }

    public CustomJazzFormAuthClient initFormClient(String userid, String password, String authUrl) {
        return new CustomJazzFormAuthClient(this.baseUrl, authUrl, userid, password);
    }

    private void processRootServices() throws RootServicesException {
        try {
            OslcClient rootServicesClient = new OslcClient();
            ClientResponse response = rootServicesClient.getResource(this.rootServicesUrl, "application/rdf+xml");
            InputStream is = response.getEntity(InputStream.class);
            this.rdfModel = ModelFactory.createDefaultModel();
            this.rdfModel.read(is, this.rootServicesUrl);
            this.catalogUrl = this.getRootServicesProperty(this.rdfModel, this.catalogNamespace, this.catalogProperty);
            this.requestTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRequestTokenUrl");
            this.authorizationTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthUserAuthorizationUrl");
            this.accessTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthAccessTokenUrl");
            try {
                this.authorizationRealm = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRealmName");
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                logger.debug(String.format("OAuth authorization realm not found in rootservices <%s>", this.rootServicesUrl));
            }
            try {
                this.requestConsumerKeyUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRequestConsumerKeyUrl");
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                logger.debug(String.format("OAuth request consumer key URL not found in rootservices <%s>", this.rootServicesUrl));
            }
            try {
                this.consumerApprovalUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthApprovalModuleUrl");
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                logger.debug(String.format("OAuth approval module URL not found in rootservices <%s>", this.rootServicesUrl));
            }
        }
        catch (Exception e) {
            throw new RootServicesException(this.baseUrl, e);
        }
    }

    private String getRootServicesProperty(Model rdfModel, String namespace, String predicate) throws ResourceNotFoundException {
        String returnVal = null;
        Property prop = rdfModel.createProperty(namespace, predicate);
        Statement stmt = rdfModel.getProperty(null, prop);
        if (stmt != null && stmt.getObject() != null) {
            returnVal = stmt.getObject().toString();
        }
        if (returnVal == null) {
            throw new ResourceNotFoundException(this.baseUrl, String.valueOf(namespace) + predicate);
        }
        return returnVal;
    }

    public Model getRdfModel() {
        return this.rdfModel;
    }

    public String getRequestConsumerKeyUrl() {
        return this.requestConsumerKeyUrl;
    }

    public String getConsumerApprovalUrl() {
        return this.consumerApprovalUrl;
    }
}

