/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc.jazz;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.org.apache.http.Header;
import plugin.rtc.org.apache.http.HttpResponse;
import plugin.rtc.org.apache.http.client.ClientProtocolException;
import plugin.rtc.org.apache.http.client.methods.HttpGet;
import plugin.rtc.org.apache.http.client.methods.HttpPost;
import plugin.rtc.org.apache.http.entity.StringEntity;
import plugin.rtc.org.apache.http.util.EntityUtils;
import plugin.rtc.org.eclipse.lyo.client.exception.JazzAuthErrorException;
import plugin.rtc.org.eclipse.lyo.client.exception.JazzAuthFailedException;
import plugin.rtc.org.eclipse.lyo.client.oslc.OslcClient;

public class CustomJazzFormAuthClient
extends OslcClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomJazzFormAuthClient.class);
    private String url;
    private String authUrl;
    private String project;
    private String user;
    private String password;
    private HttpResponse lastRedirectResponse = null;
    private String jsaCsrfCookie = null;
    private static final String JAZZ_AUTH_MESSAGE_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    private static final String JAZZ_AUTH_FAILED = "authfailed";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String JAZZ_JSA_REDIRECT_HEADER = "X-JSA-AUTHORIZATION-REDIRECT";

    public CustomJazzFormAuthClient() {
    }

    public CustomJazzFormAuthClient(String url, String user, String password) {
        this();
        this.url = url;
        this.authUrl = url;
        this.user = user;
        this.password = password;
    }

    public CustomJazzFormAuthClient(String url, String authUrl, String user, String password) {
        this(url, user, password);
        this.authUrl = authUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int login() throws JazzAuthFailedException, JazzAuthErrorException, ClientProtocolException, IOException {
        int statusCode = -1;
        String location = null;
        HttpResponse resp = null;
        try {
            LOGGER.debug("Sending Authenticated Identity GET Request... ");
            HttpGet authenticatedIdentity = new HttpGet(String.valueOf(this.authUrl) + "/authenticated/identity");
            resp = this.httpClient.execute(authenticatedIdentity);
            statusCode = resp.getStatusLine().getStatusCode();
            location = this.getHeader(resp, "Location");
            EntityUtils.consume(resp.getEntity());
            statusCode = this.followRedirects(statusCode, location);
            LOGGER.debug("Final status code of the response for Authenticated Identity GET Request: " + statusCode);
            if (401 == statusCode && this.handleJsaServer().booleanValue()) {
                LOGGER.debug("Talking to a JSA Server.");
                authenticatedIdentity = new HttpGet(String.valueOf(this.lastRedirectResponse.getFirstHeader(JAZZ_JSA_REDIRECT_HEADER).getValue()) + "&prompt=none");
                String credentials = new String(String.valueOf(this.user) + ":" + this.password);
                authenticatedIdentity.setHeader("Authorization", "Basic " + Base64.encodeBase64(credentials.getBytes("UTF-8")));
                resp = this.httpClient.execute(authenticatedIdentity);
                statusCode = resp.getStatusLine().getStatusCode();
                EntityUtils.consume(resp.getEntity());
                statusCode = this.followRedirects(statusCode, this.getHeader(resp, "Location"));
            }
            HttpPost securityCheck = new HttpPost(String.valueOf(this.authUrl) + "/j_security_check");
            StringEntity entity = new StringEntity("j_username=" + this.user + "&j_password=" + this.password);
            securityCheck.setHeader("Accept", "*/*");
            securityCheck.setHeader("X-Requested-With", "XMLHttpRequest");
            securityCheck.setEntity(entity);
            securityCheck.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            securityCheck.addHeader("OSLC-Core-Version", "2.0");
            securityCheck.addHeader("Cookie", this.jsaCsrfCookie);
            LOGGER.debug("Sending Security Check POST request...");
            resp = this.httpClient.execute(securityCheck);
            statusCode = resp.getStatusLine().getStatusCode();
            LOGGER.debug("Response Status of Security Check POST request: " + statusCode);
            location = this.getHeader(resp, "Location");
            LOGGER.debug("Location Header of Security Check POST request: " + location);
            EntityUtils.consume(resp.getEntity());
            if (location != null) {
                LOGGER.debug("Sending redirection GET request for Location: " + location);
                HttpGet redirect = new HttpGet(location);
                resp = this.httpClient.execute(redirect);
                statusCode = resp.getStatusLine().getStatusCode();
                LOGGER.debug("Redirection GET request response status: " + statusCode);
                EntityUtils.consume(resp.getEntity());
                if (statusCode == 404) {
                    statusCode = 200;
                }
            }
            Header jazzAuthMessageHeader = resp.getLastHeader(JAZZ_AUTH_MESSAGE_HEADER);
            LOGGER.debug("Redirection GET request response Header: " + jazzAuthMessageHeader);
            this.checkAuthFailure(jazzAuthMessageHeader);
            this.checkAuthError(statusCode);
            location = this.getHeader(resp, "Location");
            EntityUtils.consume(resp.getEntity());
            statusCode = this.followRedirects(statusCode, location);
            LOGGER.debug("Final status code of the response for Security Check Request: " + statusCode);
            this.checkAuthError(statusCode);
            LOGGER.debug("Security Check request is a Success.");
            int n = statusCode;
            return n;
        }
        finally {
            if (resp != null) {
                EntityUtils.consume(resp.getEntity());
            }
        }
    }

    private Boolean handleJsaServer() throws ClientProtocolException, IOException, JazzAuthErrorException {
        if (this.lastRedirectResponse == null) {
            return false;
        }
        Header[] authHeaders = this.lastRedirectResponse.getHeaders(WWW_AUTHENTICATE_HEADER);
        if (2 > authHeaders.length) {
            return false;
        }
        Boolean basicChallenge = false;
        Boolean bearerChallenge = false;
        Header[] headerArray = authHeaders;
        int n = authHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            Header theHeader = headerArray[n2];
            if (theHeader.getValue().contains("Basic")) {
                basicChallenge = true;
            } else if (theHeader.getValue().contains("Bearer")) {
                bearerChallenge = true;
            }
            ++n2;
        }
        if (!basicChallenge.booleanValue() || !bearerChallenge.booleanValue()) {
            return false;
        }
        Header jsaRedirectHeader = this.lastRedirectResponse.getFirstHeader(JAZZ_JSA_REDIRECT_HEADER);
        if (jsaRedirectHeader == null) {
            LOGGER.debug("JSA server detected.");
            return false;
        }
        return true;
    }

    @Deprecated
    public int formLogin() throws JazzAuthFailedException, JazzAuthErrorException {
        try {
            return this.login();
        }
        catch (JazzAuthFailedException jfe) {
            throw jfe;
        }
        catch (JazzAuthErrorException jee) {
            throw jee;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private int followRedirects(int statusCode, String location) throws ClientProtocolException, IOException {
        while ((statusCode == 302 || 303 == statusCode) && location != null) {
            HttpGet get = new HttpGet(location);
            this.lastRedirectResponse = this.httpClient.execute(get);
            statusCode = this.lastRedirectResponse.getStatusLine().getStatusCode();
            location = this.getHeader(this.lastRedirectResponse, "Location");
            EntityUtils.consume(this.lastRedirectResponse.getEntity());
        }
        return statusCode;
    }

    private String getHeader(HttpResponse resp, String headerName) {
        String retval = null;
        Header header = resp.getFirstHeader(headerName);
        if (header != null) {
            retval = header.getValue();
        }
        return retval;
    }

    private void checkAuthFailure(Header jazzAuthMessageHeader) throws IOException, JazzAuthFailedException {
        String jazzAuthMessage = null;
        if (jazzAuthMessageHeader != null) {
            jazzAuthMessage = jazzAuthMessageHeader.getValue();
        }
        if (jazzAuthMessage != null && jazzAuthMessage.equalsIgnoreCase(JAZZ_AUTH_FAILED)) {
            throw new JazzAuthFailedException(this.user, this.url);
        }
    }

    private void checkAuthError(int statusCode) throws IOException, JazzAuthErrorException {
        if (statusCode != 200 && statusCode != 302) {
            throw new JazzAuthErrorException(statusCode, this.url);
        }
    }
}

