/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.rtc.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.rtc.jazz.CustomJazzFormAuthClient;
import org.squashtest.tm.plugin.bugtracker.rtc.jazz.CustomJazzRootServicesHelper;
import oslcdomain.OslcIssue;
import plugin.rtc.net.oauth.OAuthException;
import plugin.rtc.org.apache.wink.client.ClientResponse;
import plugin.rtc.org.eclipse.lyo.client.exception.JazzAuthErrorException;
import plugin.rtc.org.eclipse.lyo.client.exception.JazzAuthFailedException;
import plugin.rtc.org.eclipse.lyo.client.exception.ResourceNotFoundException;
import plugin.rtc.org.eclipse.lyo.client.exception.RootServicesException;
import plugin.rtc.org.eclipse.lyo.client.oslc.OslcClient;
import plugin.rtc.org.eclipse.lyo.client.oslc.resources.ChangeRequest;
import plugin.rtc.org.eclipse.lyo.client.oslc.resources.OslcQuery;
import plugin.rtc.org.eclipse.lyo.client.oslc.resources.OslcQueryParameters;
import plugin.rtc.org.eclipse.lyo.client.oslc.resources.OslcQueryResult;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.AnyResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Service;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ServiceProvider;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ServiceProviderCatalog;

@Component
@Scope(value="prototype")
public class RtcClient {
    private static final QName PRIORITY = new QName("http://open-services.net/ns/cm-x#", "priority");
    private static final QName TITLE = new QName("http://purl.org/dc/terms/", "title");
    private static final String QUERY_PARAM_SELECT = "dcterms:identifier, dcterms:title, oslc_cm:status, oslc_cmx:priority{dcterms:title}, dcterms:contributor{foaf:name}";
    private CustomJazzFormAuthClient client;
    private CustomJazzRootServicesHelper helper;
    @Inject
    private ExceptionHandler exHandler;

    public void init(BugTracker bugTracker, Credentials credentials) {
        if (!AuthenticationProtocol.BASIC_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            throw new IllegalArgumentException("Expected BasicAuth credentials.");
        }
        BasicAuthenticationCredentials basicAuthenticationCredentials = (BasicAuthenticationCredentials)credentials;
        try {
            this.helper = new CustomJazzRootServicesHelper(bugTracker.getUrl(), "http://open-services.net/ns/cm#");
            CustomJazzFormAuthClient formAuthClient = this.helper.initFormClient(basicAuthenticationCredentials.getUsername(), String.valueOf(basicAuthenticationCredentials.getPassword()));
            formAuthClient.login();
            this.client = formAuthClient;
        }
        catch (JazzAuthErrorException ex) {
            throw this.exHandler.authErrorException(ex);
        }
        catch (IOException | JazzAuthFailedException | RootServicesException e) {
            throw this.exHandler.authenticationException(e);
        }
    }

    public RemoteIssue createReportIssueTemplate(String projectName) {
        OslcIssue issue = new OslcIssue();
        try {
            String selectDialog = null;
            String creationDialog = null;
            ClientResponse response = this.client.getResource(this.getServiceProviderUrl(projectName), "application/rdf+xml");
            ServiceProvider serviceProvider = response.getEntity(ServiceProvider.class);
            if (serviceProvider != null) {
                Service[] serviceArray = serviceProvider.getServices();
                int n = serviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Service service = serviceArray[n2];
                    URI domain = service.getDomain();
                    if (domain != null && domain.toString().equals("http://open-services.net/ns/cm#")) {
                        creationDialog = service.getCreationDialogs()[0].getDialog().toString();
                        selectDialog = service.getSelectionDialogs()[0].getDialog().toString();
                    }
                    ++n2;
                }
            }
            issue.setSelectDialog(selectDialog);
            issue.setCreateDialog(creationDialog);
        }
        catch (IOException | URISyntaxException | OAuthException | ResourceNotFoundException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
        return issue;
    }

    public URL makeViewIssueUrl(BugTracker bugTracker, String issueId) {
        return this.findIssue(issueId).getUrl();
    }

    public OslcIssue findIssue(String key) {
        try {
            for (String project : this.getAllProjectArea()) {
                Iterable<ChangeRequest> cr = this.getChangeRequests(project, key);
                if (!cr.iterator().hasNext()) continue;
                return this.convertChangeRequestToIssue(cr.iterator().next(), project);
            }
        }
        catch (IOException | URISyntaxException | OAuthException | ResourceNotFoundException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
        return null;
    }

    public List<RemoteIssue> findIssues(Collection<String> issueKeys) {
        ArrayList<RemoteIssue> issues = new ArrayList<RemoteIssue>();
        try {
            for (String project : this.getAllProjectArea()) {
                for (ChangeRequest item : this.getChangeRequests(project, issueKeys.toArray(new String[issueKeys.size()]))) {
                    issues.add((RemoteIssue)this.convertChangeRequestToIssue(item, project));
                }
            }
        }
        catch (IOException | URISyntaxException | OAuthException | ResourceNotFoundException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
        return issues;
    }

    private OslcIssue convertChangeRequestToIssue(ChangeRequest item, String project) throws MalformedURLException {
        OslcIssue issue = new OslcIssue();
        AdvancedProject projectIssue = new AdvancedProject();
        projectIssue.setName(project);
        issue.setProject(projectIssue);
        issue.setId(item.getIdentifier());
        issue.setUrl(item.getAbout().toURL());
        issue.setSummary(item.getTitle());
        issue.setStatus(item.getStatus());
        issue.setPriority(this.extractPriority(item));
        issue.setAssignee(this.extractAssignee(item));
        return issue;
    }

    private String extractAssignee(ChangeRequest item) {
        StringBuilder contributors = new StringBuilder();
        URI[] uRIArray = item.getContributors();
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI contributor = uRIArray[n2];
            String[] splited = contributor.toString().split("/");
            contributors.append(splited[splited.length - 1]).append(", ");
            ++n2;
        }
        return contributors.substring(0, contributors.length() - 2);
    }

    private String extractPriority(ChangeRequest item) {
        AnyResource res = (AnyResource)item.getExtendedProperties().get(PRIORITY);
        return (String)res.getExtendedProperties().get(TITLE);
    }

    private List<String> getAllProjectArea() throws IOException, OAuthException, URISyntaxException {
        ArrayList<String> result = new ArrayList<String>();
        ClientResponse response = this.client.getResource(this.helper.getCatalogUrl(), "application/rdf+xml");
        ServiceProviderCatalog catalog = response.getEntity(ServiceProviderCatalog.class);
        ServiceProvider[] serviceProviderArray = catalog.getServiceProviders();
        int n = serviceProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceProvider serviceProvider = serviceProviderArray[n2];
            result.add(serviceProvider.getTitle());
            ++n2;
        }
        return result;
    }

    private String getIssueKeySearchString(String[] issueKeys) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = issueKeys;
        int n = issueKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append("\"").append(s).append("\"").append(",");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private Iterable<ChangeRequest> getChangeRequests(String project, String ... issueKeys) throws ResourceNotFoundException, IOException, OAuthException, URISyntaxException {
        return this.searchIssues(project, issueKeys).getMembers(ChangeRequest.class);
    }

    private String getServiceProviderUrl(String projectName) throws ResourceNotFoundException, IOException, OAuthException, URISyntaxException {
        return this.client.lookupServiceProviderUrl(this.helper.getCatalogUrl(), projectName);
    }

    private OslcQueryResult searchIssues(String project, String ... issueKeys) throws ResourceNotFoundException, IOException, OAuthException, URISyntaxException {
        String queryCapability = this.client.lookupQueryCapability(this.getServiceProviderUrl(project), "http://open-services.net/ns/cm#", "http://open-services.net/ns/cm#ChangeRequest");
        OslcQueryParameters queryParams = new OslcQueryParameters();
        queryParams.setWhere("dcterms:identifier in [" + this.getIssueKeySearchString(issueKeys) + "]");
        queryParams.setSelect(QUERY_PARAM_SELECT);
        OslcQuery query2 = new OslcQuery((OslcClient)this.client, queryCapability, queryParams);
        return query2.submit();
    }
}

