/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.RedmineOptions;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import java.util.List;
import org.apache.http.NameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal.ExtendedTransport;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal.ExtendedURIConfigurator;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;

public class Redmine3ExtendedManager
extends RedmineManager {
    private final ExtendedTransport extendedTransport;

    public Redmine3ExtendedManager(String uri, String login, String password, BaseCommunicatorFactory baseCommunicatorFactory) {
        super(uri, login, password, RedmineOptions.simpleOptions());
        this.extendedTransport = new ExtendedTransport(new ExtendedURIConfigurator(uri, null), baseCommunicatorFactory);
        this.extendedTransport.setCredentials(login, password);
    }

    public Redmine3ExtendedManager(String uri, String token, BaseCommunicatorFactory baseCommunicatorFactory) {
        super(uri, token, RedmineOptions.simpleOptions());
        this.extendedTransport = new ExtendedTransport(new ExtendedURIConfigurator(uri, null), baseCommunicatorFactory);
    }

    public List<ExtendedCustomField> getCustomField() throws RedmineException {
        return this.extendedTransport.getObjectsList(ExtendedCustomField.class, new NameValuePair[0]);
    }

    public List<ExtendedTracker> getExtendedTracker() throws RedmineException {
        return this.extendedTransport.getObjectsList(ExtendedTracker.class, new NameValuePair[0]);
    }

    public List<ExtendedRole> getExtendedRoles() throws RedmineException {
        return this.extendedTransport.getObjectsList(ExtendedRole.class, new NameValuePair[0]);
    }

    public ExtendedRole getExtendedRole(Role role) throws RedmineException {
        return this.extendedTransport.getObject(ExtendedRole.class, role.getId(), new NameValuePair[0]);
    }

    @Override
    public List<IssueCategory> getCategories(int projectID) throws RedmineException {
        return this.extendedTransport.getChildEntries(Project.class, Integer.toString(projectID), IssueCategory.class);
    }

    @Override
    public List<Membership> getMemberships(String project) throws RedmineException {
        return this.extendedTransport.getChildEntries(Project.class, project, Membership.class);
    }

    @Override
    public List<Membership> getMemberships(Project project) throws RedmineException {
        return this.getMemberships(this.getProjectKey(project));
    }

    private String getProjectKey(Project project) {
        return project.getId() != null ? project.getId().toString() : project.getIdentifier();
    }
}

