/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain;

import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.csp.core.bugtracker.domain.Priority;
import org.squashtest.csp.core.bugtracker.domain.Status;
import org.squashtest.csp.core.bugtracker.domain.User;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.definition.RemotePriority;
import org.squashtest.tm.bugtracker.definition.RemoteStatus;
import org.squashtest.tm.bugtracker.definition.RemoteUser;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapField;

public class TuleapAdvancedIssue
extends AdvancedIssue {
    private String UNKNOWN_FIELD;
    private TuleapField summaryField;
    private TuleapField descriptionField;
    private TuleapField assigneeField;
    private TuleapField severityField;
    private TuleapField statusField;

    public TuleapAdvancedIssue(MessageSource messageSource) {
        this.UNKNOWN_FIELD = messageSource.getMessage("interface.report.unknown.field", null, LocaleContextHolder.getLocale());
    }

    public String getSummary() {
        if (this.summaryField == null) {
            return this.UNKNOWN_FIELD;
        }
        return super.getFieldValue(this.summaryField.getLabel()).getScalar();
    }

    public void setSummary(String summary) {
        if (this.summaryField != null) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setScalar(summary);
            super.setFieldValue(this.summaryField.getLabel(), fieldValue);
        }
    }

    public String getDescription() {
        if (this.descriptionField == null) {
            return this.UNKNOWN_FIELD;
        }
        return super.getFieldValue(this.descriptionField.getLabel()).getScalar();
    }

    public void setDescription(String description) {
        if (this.descriptionField != null) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setScalar(description);
            super.setFieldValue(this.descriptionField.getLabel(), fieldValue);
        }
    }

    public RemoteStatus getStatus() {
        if (this.statusField == null) {
            return new Status("----", this.UNKNOWN_FIELD);
        }
        return super.getFieldValue(this.statusField.getLabel());
    }

    public void setStatus(String status) {
        if (this.statusField != null) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setScalar(status);
            super.setFieldValue(this.statusField.getLabel(), fieldValue);
        }
    }

    public RemotePriority getPriority() {
        if (this.severityField == null) {
            Priority noPriority = Priority.NO_PRIORITY;
            noPriority.setName(this.UNKNOWN_FIELD);
            return noPriority;
        }
        return super.getFieldValue(this.severityField.getLabel());
    }

    public void setPriority(String priority) {
        if (this.severityField != null) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setScalar(priority);
            super.setFieldValue(this.severityField.getLabel(), fieldValue);
        }
    }

    public RemoteUser getAssignee() {
        if (this.assigneeField == null) {
            User noUser = User.NO_USER;
            noUser.setName(this.UNKNOWN_FIELD);
            return noUser;
        }
        return super.getFieldValue(this.assigneeField.getLabel());
    }

    public void setAssignee(String assignee) {
        if (this.assigneeField != null) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setScalar(assignee);
            super.setFieldValue(this.assigneeField.getLabel(), fieldValue);
        }
    }

    public TuleapField getSummaryField() {
        return this.summaryField;
    }

    public void setSummaryField(TuleapField summaryField) {
        this.summaryField = summaryField;
    }

    public TuleapField getDescriptionField() {
        return this.descriptionField;
    }

    public void setDescriptionField(TuleapField descriptionField) {
        this.descriptionField = descriptionField;
    }

    public TuleapField getAssigneeField() {
        return this.assigneeField;
    }

    public void setAssigneeField(TuleapField assigneeField) {
        this.assigneeField = assigneeField;
    }

    public TuleapField getSeverityField() {
        return this.severityField;
    }

    public void setSeverityField(TuleapField severityField) {
        this.severityField = severityField;
    }

    public TuleapField getStatusField() {
        return this.statusField;
    }

    public void setStatusField(TuleapField statusField) {
        this.statusField = statusField;
    }
}

