/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.campaignassessment.dto;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class I18nHelper
implements MessageSourceAware {
    protected MessageSource msgSource;

    protected Locale currentLocale() {
        Locale current = LocaleContextHolder.getLocale();
        if (current == null) {
            current = Locale.getDefault();
        }
        return current;
    }

    public String translate(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return this.msgSource.getMessage(string, null, this.currentLocale());
    }

    public String translateWithParams(String string, Object[] params) {
        return this.msgSource.getMessage(string, params, this.currentLocale());
    }

    public String translateNewDateByFormat(String typeFormat) {
        Date date = new Date();
        String dateFormatFileName = new SimpleDateFormat(this.msgSource.getMessage("report.campaignassessment.file.dateformat", null, this.currentLocale())).format(date);
        String dateFormatBottomPage = new SimpleDateFormat(this.msgSource.getMessage("squashtm.dateformat", null, this.currentLocale())).format(date);
        Object[] params = new String[]{this.translateDateShort(date), this.translateDateHour(dateFormatBottomPage)};
        String generatedDateFirstPage = this.msgSource.getMessage("report.campaignassessment.generated.date.first.page", params, this.currentLocale());
        switch (typeFormat) {
            case "firstPage": {
                return generatedDateFirstPage;
            }
            case "bottomPage": {
                return dateFormatBottomPage;
            }
        }
        return dateFormatFileName;
    }

    private String translateDateHour(String date) {
        if (date.length() < 16) {
            return "";
        }
        return date.substring(11, 16);
    }

    public String translateDateShort(Date date) {
        if (date == null) {
            return "";
        }
        String dateFormat = this.msgSource.getMessage("squashtm.dateformatShort", null, this.currentLocale());
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.msgSource = messageSource;
    }
}

