/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.extension;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssueReportForm;
import org.squashtest.tm.bugtracker.advanceddomain.ChangeSet;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Template;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.RemoteIssueContextFormatter;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.CommonReferenceNames;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.SchemeBuilder;

public class DelegateCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateCommands.class);
    public static final String SET_TEMPLATE_COMMAND_ID = "set_template";

    public static boolean isSetTemplateCommand(DelegateCommand command) {
        return command.getCommand().equals(SET_TEMPLATE_COMMAND_ID);
    }

    public static ChangeSet executeSetTemplateCommand(DelegateCommand command, AzureDevOpsClient client, RemoteIssueContextFormatter remoteIssueContextFormatter) {
        String templateUrl = (String)command.getArgument();
        if ("~defaultSquashTemplate".equals(templateUrl)) {
            return DelegateCommands.applyDefaultTemplate(command, remoteIssueContextFormatter);
        }
        try {
            Template template = client.getTemplateFields(templateUrl);
            ChangeSet changeSet = new ChangeSet();
            List<String> unaffectedFieldIds = Arrays.asList(CommonReferenceNames.WorkItemType.value, "template", "attachments");
            AdvancedIssueReportForm reportForm = command.getContext().getReportForm();
            reportForm.getProject().getFieldScheme(reportForm.getCurrentScheme()).forEach(field -> {
                String prefixedFieldId = field.getId();
                String unPrefixedCandidate = SchemeBuilder.tryToRemovePrefix(prefixedFieldId);
                Object newValue = template.getFields().get(unPrefixedCandidate);
                boolean isStringValue = newValue instanceof String;
                if (unaffectedFieldIds.contains(unPrefixedCandidate)) {
                    return;
                }
                if (newValue == null) {
                    changeSet.getChanges().add(DelegateCommands.emptyValueChange(field.getId()));
                    return;
                }
                if (isStringValue) {
                    String valueAsString = (String)newValue;
                    if (InputType.TypeName.DATE_TIME.value.equals(field.getRendering().getInputType().getName())) {
                        valueAsString = DelegateCommands.patchDateTimeValues(valueAsString);
                    }
                    FieldValue newFieldValue = new FieldValue(null, valueAsString);
                    ChangeSet.Change change = new ChangeSet.Change(ChangeSet.ChangeKind.REPLACE_VALUE, prefixedFieldId, newFieldValue, null);
                    changeSet.getChanges().add(change);
                }
            });
            DelegateCommands.handleSystemTags(template, changeSet, reportForm);
            return changeSet;
        }
        catch (BugTrackerRemoteException ex) {
            LOGGER.error("Could not fetch template at URL : " + templateUrl);
            return null;
        }
    }

    private static void handleSystemTags(Template template, ChangeSet changeSet, AdvancedIssueReportForm reportForm) {
        Object tagsCandidate = template.getFields().get("System.Tags-Add");
        if (tagsCandidate instanceof String) {
            FieldValue[] trimmedTags = (FieldValue[])Arrays.stream(((String)tagsCandidate).split(";")).map(String::trim).map(tag -> new FieldValue(tag, tag)).toArray(FieldValue[]::new);
            FieldValue composite = new FieldValue();
            composite.setComposite(trimmedTags);
            String unqualifiedSchemeName = reportForm.getCurrentScheme().replace(CommonReferenceNames.WorkItemType.value + ":", "");
            ChangeSet.Change change = new ChangeSet.Change(ChangeSet.ChangeKind.REPLACE_VALUE, SchemeBuilder.buildPrefixedId(unqualifiedSchemeName, CommonReferenceNames.Tags.value), composite, null);
            changeSet.getChanges().add(change);
        }
    }

    private static ChangeSet applyDefaultTemplate(DelegateCommand command, RemoteIssueContextFormatter remoteIssueContextFormatter) {
        List<String> unaffectedFieldIds = Arrays.asList(CommonReferenceNames.WorkItemType.value, CommonReferenceNames.Description.value, "template", "attachments");
        ChangeSet changeSet = new ChangeSet();
        AdvancedIssueReportForm reportForm = command.getContext().getReportForm();
        reportForm.getProject().getFieldScheme(reportForm.getCurrentScheme()).forEach(field -> {
            String unPrefixedCandidate = SchemeBuilder.tryToRemovePrefix(field.getId());
            if (!unaffectedFieldIds.contains(unPrefixedCandidate)) {
                changeSet.getChanges().add(DelegateCommands.emptyValueChange(field.getId()));
            }
        });
        RemoteIssueContext context = command.getContext().getReportForm().getRemoteIssueContext();
        FieldValue descriptionValue = new FieldValue(null, remoteIssueContextFormatter.buildDescription(context));
        changeSet.getChanges().add(new ChangeSet.Change(ChangeSet.ChangeKind.REPLACE_VALUE, CommonReferenceNames.Description.value, descriptionValue, null));
        return changeSet;
    }

    private static String patchDateTimeValues(String valueAsString) {
        if (!valueAsString.contains(":")) {
            return valueAsString + " 00:00";
        }
        return valueAsString;
    }

    private static ChangeSet.Change emptyValueChange(String fieldId) {
        FieldValue newFieldValue = new FieldValue(null, null);
        return new ChangeSet.Change(ChangeSet.ChangeKind.REPLACE_VALUE, fieldId, newFieldValue, null);
    }
}

