SELECT rv.REQUIREMENT_ID AS ID,
r.NAME AS NAME,
p.NAME AS PROJECT_NAME,
rv.CRITICALITY AS CRITICALITY,
rv.REQUIREMENT_STATUS AS STATUS,
rv.VERSION_NUMBER AS VERSION,
rv.REFERENCE as REFERENCE,
tcvrv.VERIFYING_TEST_CASE_ID AS TEST_CASE_ID,
group_concat(distinct  mstones.LABEL) as milestones
FROM RESOURCE r
JOIN REQUIREMENT_VERSION rv ON rv.RES_ID = r.RES_ID
JOIN REQUIREMENT_VERSION_COVERAGE tcvrv ON tcvrv.VERIFIED_REQ_VERSION_ID = rv.RES_ID
JOIN REQUIREMENT_LIBRARY_NODE rln ON rln.RLN_ID = rv.REQUIREMENT_ID
JOIN PROJECT p ON p.PROJECT_ID = rln.PROJECT_ID
left JOIN MILESTONE_REQ_VERSION reqmstones ON reqmstones.REQ_VERSION_ID = rv.RES_ID
left JOIN MILESTONE mstones ON mstones.MILESTONE_ID = reqmstones.MILESTONE_ID
WHERE tcvrv.VERIFYING_TEST_CASE_ID in (:testcaseIds)
group by tcvrv.VERIFYING_TEST_CASE_ID, r.RES_ID, rv.REQUIREMENT_ID, r.NAME, p.NAME, rv.CRITICALITY, rv.REQUIREMENT_STATUS, rv.VERSION_NUMBER, rv.REFERENCE
UNION
SELECT rv.REQUIREMENT_ID AS ID,
r.NAME AS NAME,
p.NAME AS PROJECT_NAME,
rv.CRITICALITY AS CRITICALITY,
rv.REQUIREMENT_STATUS AS STATUS,
rv.VERSION_NUMBER AS VERSION,
rv.REFERENCE as REFERENCE,
tcs.TEST_CASE_ID as TEST_CASE_ID,
group_concat(distinct  mstones.LABEL) as milestones
FROM RESOURCE r
JOIN REQUIREMENT_VERSION rv ON rv.RES_ID = r.RES_ID
JOIN REQUIREMENT_VERSION_COVERAGE tcvrv ON tcvrv.VERIFIED_REQ_VERSION_ID = rv.RES_ID
JOIN REQUIREMENT_LIBRARY_NODE rln ON rln.RLN_ID = rv.REQUIREMENT_ID
JOIN PROJECT p ON p.PROJECT_ID = rln.PROJECT_ID
JOIN CALL_TEST_STEP cts ON cts.CALLED_TEST_CASE_ID = tcvrv.VERIFYING_TEST_CASE_ID
JOIN TEST_CASE_STEPS tcs ON tcs.STEP_ID = cts.TEST_STEP_ID
left JOIN MILESTONE_REQ_VERSION reqmstones ON reqmstones.REQ_VERSION_ID = rv.RES_ID
left JOIN MILESTONE mstones ON mstones.MILESTONE_ID = reqmstones.MILESTONE_ID
WHERE tcs.TEST_CASE_ID in (:testcaseIds)
group by tcvrv.VERIFYING_TEST_CASE_ID, r.RES_ID, rv.RES_ID, p.NAME, tcs.TEST_CASE_ID
order by CRITICALITY, PROJECT_NAME, REFERENCE, NAME
