SAML Plugin
====================

Overview
--------------------

### Description

This plugin adds a SAML 2.0 entry point for user authentication in Squash TM,
which provides the application with stronger authentication schemes and
Single Sign On services.

Note that it doesn't replace the default entry point and the users can
still authenticate using the login form at `/login`, which itself
remains compatible with other security plugins (ad or ldap).

### Features

The following features are supported :

* Web SSO,
* Web SSO with holder-of-key profile,
* SP or IDP-initiated SSO,
* HTTP-POST, HTTP-Redirect, SOAP, PAOS and Artifact Binding profiles
* Trust management using Metadata Interoperability or PKIX,
* Metadata loading by local file or HTTP,
* Support for scoping and authentication contexts,
* Publication of SP metadata

With the current limitations :

* Supports only one IDP and one SP definition
* No IDP discovery
* No SP metadata autogeneration

### Requirements

* Squash TM 1.18
* Java 8

### Endpoints

* `/auth/saml/login` : the SAML entry point
* `/auth/saml/SSO` : endpoint for SSO profiles
* `/auth/saml/SSOHoK` : endpoint for SSO Holder-of-Key profiles
* `/auth/saml/metadata` : SP metadata publication
* `/auth/saml/SingleLogout` : single logout URL

____________________
Usage overview
--------------------

### For the users

Users can now authenticate by accessing the application at url `/auth/saml/login`.
An SSO negotiation will initiate immediately.
If the IDP approves the user, he/she will be authenticated on Squash TM
with the auth. assertion \<NameID\> as login name. The user
account will be created on the fly if it doesn't exist already.

### For administrators

Squash TM metadata are published at url `/auth/saml/metadata`.

____________________
Configuration
--------------------
This section covers the required steps to configure and enable the plugin
properly. Other optional behavior can be configured, but here we will restrict
to the absolute essentials.

In order to work the following items must be made available to Squash TM :
* the plugin binary,
* the configuration file,
* the Service Provider and Identity Provider metadata,
* a dedicated jks keystore.

### Binary

Copy the jar in directory `plugins` and paste it in the same folder in Squash TM.

### Configuration file

The most convenient way is to copy `config/squash.tm.cfg-saml.properties`
and paste it in the home configuration directory. In the standalone distribution
of Squash-TM that directory is usually `SQUASH_HOME/conf`. Then you must
enable it by setting the property `spring.profiles.include=saml` in the
main configuration file `squash.tm.cfg.properties`.

The configuration _must_ define the following properties :

* `saml.enabled` : the main switch for the whole feature
* `saml.idp.metadata.url` : the location where Squash TM will find the IDP metadata
* `saml.sp.metadata.url` : the location of the SP metadata (ie Squash TM own SAML services descriptor)
* `saml.keystore.url` : the location of the dedicated keystore
* `saml.keystore.password` : the password of the keystore
* `saml.keystore.credentials.<?>` : the list of key pairs Squash TM will use for signature and/or encryption (at least one)
* `saml.keystore.default-key` : the default key used by Squash TM (if not overriden in a different context).

Many more options are available for fine-tuning the behavior of the plugin.
The comments in `squash.tm.cfg-saml.properties` will give you additional
information about this step.

### Identity Provider metadata

They are usually published by the IDP server so you won't (as a Squash TM administrator) have to generate them.
Squash TM can load them either by HTTP(S) or from a local drive. The location is configured by the property `saml.idp.metadata.url`.

Remember : only one IDP is supported. If the metadata declare more than one IDP the first of the list will be used.

### Service Provider metadata

The SP metadata are loaded just like the IDP metadata via the property `saml.sp.metadata.url`,
however in this case you will have to create the metadata file first (the current version of the plugin provides no
utilities for that purpose). External tools like [this one](https://www.samltool.com/sp_metadata.php) can help you with
it. You can also take a look at the sample file `config/saml/sp.xml` and change it according to you needs. The endpoint
paths are available earlier in this file in section *Overview>Endpoints*. Please ensure that the URLS for the various SAML
services should account for eventual proxies between Squash TM and the IDP.

Just like the IDP, only one SP can be declared. If the metadata declare more than one SP the first of the list will
be used.

### Keystore

The SAML plugin runs with its own keystore separate from the keystore consumed by the JVM. Almost all operations involving
cryptographic material will be backed by this dedicated keystore (see note below). It must contain at least the key pairs
used for signing the messages (ie that of the <X509Certificate> clauses in the SP metadata), and probably the root and
intermediate CA.

The keystore is configured by the family of properties `saml.keystore.*`. Unlike the metadata it cannot be loaded by HTTP
and must be available on a local drive.

Note : the only case where certificates from the JVM keystore are invoked is when the metadata are loaded by HTTPS, and if
the hostname and certificate of the TLS tunnel itself must be checked. Once downloaded, the certificates embedded in the
metadata will be checked against the keystore of the plugin.

____________________
Logging
--------------------

If the plugin is not working as expected you can enable more logging by appending this to the configuration :

```
logging.level.org.squashtest.tm.plugin.saml=TRACE
logging.level.sqsaml.org.springframework.security=TRACE
logging.level.org.springframework.security.web.authentication=TRACE
logging.level.org.opensaml=TRACE
```

TRACE is the finer logging level available. If this is too verbose you can use the DEBUG level instead.

Note that Squash-TM must be rebooted to account for your new configuration.

____________________
Troubleshooting
--------------------

#### Question ####

I cannot log in using saml, and the logs show the following instead :

`org.opensaml.saml2.metadata.provider.MetadataProviderException: No hosted service provider is configured and no alias was selected`

#### Answer ####

At boot time and then periodically after that, the underlying library checks for expiration date in metadata files (if specified). If a metadata has expired it won't be processed and the plugin initialization continues while barely reporting the problem. Later on, when accessing to the SAML portal the plugin attempts to resolve the service provider or identity provider and can't find any, it will then abort the authentication process with this MetadataProviderException. Unfortunately we have no control over that code and cannot set a fail-fast policy for that.

You can verify this by turning the loggers on (see above) and looking for the following string :

```
org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider: Entire metadata document from '<your metadata>' was expired at time of loading, existing metadata retained
```

If such line appear you can extend the expiration date in the metadata (or delete the attribute `validUntil` altogether) to fix the problem.


#### Question ####

I successfully reached my IDP, but then Squash-TM displays an error page with the following message : `An unexpected error happened... Error is SecurityException : SAML message intended destination endpoint did not match recipient endpoint`

#### Answer ####

If Squash-TM runs behind a reverse proxy or a load balancer, several plumbing issues may disrupt the message flow. For instance if the front proxy (eg for SSL offload duty) serves Squash-TM with HTTP only, while on the other hand the ACS expects HTTPS, the aforementioned error will happen because of the protocol mismatch.

You can advise Squash-TM for such situations in the configuration file, in the section `saml.proxy`.

____________________
More
--------------------

Check the documentation for details about the functional behavior and fine tuning options.
