--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-4.1.0.xml
--  Ran at: 03/12/2025 17:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-ltb56xtz (100.64.9.58)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0::bmsaddek
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '4.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 1, '8:e23ead1b9d0bb7b58a91a48c3b8cb738', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable::bmsaddek
--  Create table ENVIRONMENT_VARIABLE
CREATE TABLE ENVIRONMENT_VARIABLE (EV_ID BIGINT AUTO_INCREMENT NOT NULL, FIELD_TYPE VARCHAR(5) NOT NULL, NAME VARCHAR(255) NOT NULL, INPUT_TYPE VARCHAR(30) NOT NULL, CONSTRAINT PK_ENVIRONMENT_VARIABLE PRIMARY KEY (EV_ID));

CREATE INDEX idx_ev_name ON ENVIRONMENT_VARIABLE(NAME);

ALTER TABLE ENVIRONMENT_VARIABLE ADD CONSTRAINT uc_ev_name UNIQUE (NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 2, '8:cd633867f6f5f4f83702a1ecb98c1c8c', 'createTable tableName=ENVIRONMENT_VARIABLE; createIndex indexName=idx_ev_name, tableName=ENVIRONMENT_VARIABLE; addUniqueConstraint constraintName=uc_ev_name, tableName=ENVIRONMENT_VARIABLE', 'Create table ENVIRONMENT_VARIABLE', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable_option::bmsaddek
--  Creates a table for Environment Variable Options
CREATE TABLE ENVIRONMENT_VARIABLE_OPTION (EV_ID BIGINT NOT NULL, LABEL VARCHAR(255) NOT NULL, POSITION INT NOT NULL, CONSTRAINT fk_ev_option_ev FOREIGN KEY (EV_ID) REFERENCES ENVIRONMENT_VARIABLE(EV_ID));

CREATE INDEX idx_fk_ev_option_ev ON ENVIRONMENT_VARIABLE_OPTION(EV_ID);

ALTER TABLE ENVIRONMENT_VARIABLE_OPTION ADD CONSTRAINT uc_ev_option_label UNIQUE (EV_ID, LABEL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable_option', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 3, '8:2eed485efc3eb8548585dd25a5306515', 'createTable tableName=ENVIRONMENT_VARIABLE_OPTION; createIndex indexName=idx_fk_ev_option_ev, tableName=ENVIRONMENT_VARIABLE_OPTION; addUniqueConstraint constraintName=uc_ev_option_label, tableName=ENVIRONMENT_VARIABLE_OPTION', 'Creates a table for Environment Variable Options', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable_binding::bmsaddek
--  Creates a table for Environment Variable Binding
CREATE TABLE ENVIRONMENT_VARIABLE_BINDING (EVB_ID BIGINT AUTO_INCREMENT NOT NULL, EV_ID BIGINT NOT NULL, BOUND_SERVER_ID BIGINT NOT NULL, CONSTRAINT PK_EV_BINDING PRIMARY KEY (EVB_ID), CONSTRAINT fk_ev_binding_server FOREIGN KEY (BOUND_SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER(SERVER_ID), CONSTRAINT fk_ev_binding_ev FOREIGN KEY (EV_ID) REFERENCES ENVIRONMENT_VARIABLE(EV_ID));

CREATE INDEX idx_fk_ev_binding_ev ON ENVIRONMENT_VARIABLE_BINDING(EV_ID);

CREATE INDEX idx_fk_ev_binding_server ON ENVIRONMENT_VARIABLE_BINDING(BOUND_SERVER_ID);

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD CONSTRAINT uc_ev_server_bnd UNIQUE (BOUND_SERVER_ID, EV_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable_binding', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 4, '8:ce1612f975708be70df55888e085a811', 'createTable tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_fk_ev_binding_ev, tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_fk_ev_binding_server, tableName=ENVIRONMENT_VARIABLE_BINDING; addUniqueConstraint con...', 'Creates a table for Environment Variable Binding', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable_value::bmsaddek
CREATE TABLE ENVIRONMENT_VARIABLE_VALUE (EVV_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', BOUND_ENTITY_ID BIGINT NOT NULL COMMENT 'the id of the bound entity', BOUND_ENTITY_TYPE VARCHAR(30) NOT NULL, EVB_ID BIGINT NOT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular environment variable value', CONSTRAINT PK_ENVIRONMENT_VARIABLE_VALUE PRIMARY KEY (EVV_ID), CONSTRAINT fk_ev_value_binding FOREIGN KEY (EVB_ID) REFERENCES ENVIRONMENT_VARIABLE_BINDING(EVB_ID));

CREATE INDEX idx_fk_ev_value_binding ON ENVIRONMENT_VARIABLE_VALUE(EVB_ID);

CREATE INDEX idx_evv_entity_id ON ENVIRONMENT_VARIABLE_VALUE(BOUND_ENTITY_ID);

CREATE INDEX idx_evv_entity_type ON ENVIRONMENT_VARIABLE_VALUE(BOUND_ENTITY_TYPE);

ALTER TABLE ENVIRONMENT_VARIABLE_VALUE ADD CONSTRAINT uc_evv_id_type_binding UNIQUE (BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, EVB_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable_value', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 5, '8:65be21f7c45926ea0b31d1906333f96d', 'createTable tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_fk_ev_value_binding, tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_evv_entity_id, tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_evv_ent...', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-denormalized-environment-variable::bmsaddek
CREATE TABLE DENORMALIZED_ENVIRONMENT_VARIABLE (DEV_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', EV_ID BIGINT NULL, HOLDER_ID BIGINT NOT NULL, HOLDER_TYPE VARCHAR(30) NOT NULL, NAME VARCHAR(255) NOT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular environment variable value', CONSTRAINT PK_DENORMALIZED_ENVIRONMENT_VARIABLE PRIMARY KEY (DEV_ID), CONSTRAINT fk_dev_environment_variable FOREIGN KEY (EV_ID) REFERENCES ENVIRONMENT_VARIABLE(EV_ID));

CREATE INDEX idx_fk_dev_environment_variable ON DENORMALIZED_ENVIRONMENT_VARIABLE(EV_ID);

CREATE INDEX idx_dev_holder_id ON DENORMALIZED_ENVIRONMENT_VARIABLE(HOLDER_ID);

CREATE INDEX idx_dev_holder_type ON DENORMALIZED_ENVIRONMENT_VARIABLE(HOLDER_TYPE);

ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE ADD CONSTRAINT uc_dev_id_type_name UNIQUE (HOLDER_ID, HOLDER_TYPE, NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-denormalized-environment-variable', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 6, '8:ee179aababb312a8dee75c67785c094d', 'createTable tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; createIndex indexName=idx_fk_dev_environment_variable, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; createIndex indexName=idx_dev_holder_id, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; crea...', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Changeset ../tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-denormalized-environment-tag::bmsaddek
CREATE TABLE DENORMALIZED_ENVIRONMENT_TAG (DET_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', HOLDER_ID BIGINT NOT NULL, HOLDER_TYPE VARCHAR(30) NOT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular environment tag value', CONSTRAINT PK_DENORMALIZED_ENVIRONMENT_TAG PRIMARY KEY (DET_ID));

CREATE INDEX idx_det_holder_id ON DENORMALIZED_ENVIRONMENT_TAG(HOLDER_ID);

CREATE INDEX idx_det_holder_type ON DENORMALIZED_ENVIRONMENT_TAG(HOLDER_TYPE);

ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG ADD CONSTRAINT uc_det_id_type_value UNIQUE (HOLDER_ID, HOLDER_TYPE, VALUE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-denormalized-environment-tag', 'bmsaddek', '../tm/tm.changelog-4.1.0.xml', NOW(), 7, '8:fe1806eef598e87ccacce2dcdf8a7d1e', 'createTable tableName=DENORMALIZED_ENVIRONMENT_TAG; createIndex indexName=idx_det_holder_id, tableName=DENORMALIZED_ENVIRONMENT_TAG; createIndex indexName=idx_det_holder_type, tableName=DENORMALIZED_ENVIRONMENT_TAG; addUniqueConstraint constraintN...', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780601002');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

