--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-2.1.0.xml
--  Ran at: 03/12/2025 17:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-ltb56xtz (100.64.9.58)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-2.1.0.xml', NOW(), 1, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600776');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0::dclaerhout
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '2.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0', 'dclaerhout', '../tm/tm.changelog-2.1.0.xml', NOW(), 2, '8:58af94593b5537caa99340aa72618824', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '4780600776');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-add-remote-req-perimeter-status::dclaerhout
ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD REMOTE_REQ_PERIMETER_STATUS VARCHAR(30) DEFAULT 'UNKNOWN' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-add-remote-req-perimeter-status', 'dclaerhout', '../tm/tm.changelog-2.1.0.xml', NOW(), 3, '8:692f8c68acac6e331b0a29eb8c086a4d', 'addColumn tableName=REQUIREMENT_SYNC_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600776');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart::jprioux
--  Remove the USER_ID columns and associated foreign keys
ALTER TABLE CHART_DEFINITION DROP FOREIGN KEY fk_chart_owner;

ALTER TABLE CHART_DEFINITION DROP COLUMN USER_ID;

ALTER TABLE REPORT_DEFINITION DROP FOREIGN KEY fk_report_owner;

ALTER TABLE REPORT_DEFINITION DROP COLUMN USER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart', 'jprioux', '../tm/tm.changelog-2.1.0.xml', NOW(), 4, '8:7742eb5108ca31bae3ac8987b55f2a92', 'dropForeignKeyConstraint baseTableName=CHART_DEFINITION, constraintName=fk_chart_owner; dropColumn columnName=USER_ID, tableName=CHART_DEFINITION; dropForeignKeyConstraint baseTableName=REPORT_DEFINITION, constraintName=fk_report_owner; dropColumn...', 'Remove the USER_ID columns and associated foreign keys', 'EXECUTED', NULL, NULL, '4.19.0', '4780600776');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-add-template-configurable-plugin-binding::pckerneis
--  Add the template_configurable_plugin_binding table.
CREATE TABLE TEMPLATE_CONFIGURABLE_PLUGIN_BINDING (BINDING_ID BIGINT AUTO_INCREMENT NOT NULL, PROJECT_TEMPLATE_ID BIGINT NOT NULL, PROJECT_ID BIGINT NOT NULL, PLUGIN_ID VARCHAR(50) NOT NULL, CONSTRAINT PK_TEMPLATE_CONFIGURABLE_PLUGIN_BINDING PRIMARY KEY (BINDING_ID), CONSTRAINT fk_template_configurable_plugin_binding__project__project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_template_configurable_plugin_binding__template__project_id FOREIGN KEY (PROJECT_TEMPLATE_ID) REFERENCES PROJECT(PROJECT_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-add-template-configurable-plugin-binding', 'pckerneis', '../tm/tm.changelog-2.1.0.xml', NOW(), 5, '8:94099c234b0589cdc0de65e2700f67c6', 'createTable tableName=TEMPLATE_CONFIGURABLE_PLUGIN_BINDING', 'Add the template_configurable_plugin_binding table.', 'EXECUTED', NULL, NULL, '4.19.0', '4780600776');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

