--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-1.22.0.xml
--  Ran at: 03/12/2025 17:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-ltb56xtz (100.64.9.58)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-1.22.0.xml', NOW(), 1, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0', 'jthebault', '../tm/tm.changelog-1.22.0.xml', NOW(), 2, '8:b0881e9c070a0a75173bd86d509cb25a', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger::edegenetais
ALTER TABLE ITERATION ADD UUID VARCHAR(36) NULL;

ALTER TABLE ITERATION ADD CONSTRAINT uc_iteration_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger', 'edegenetais', '../tm/tm.changelog-1.22.0.xml', NOW(), 3, '8:cb55e1be7759db53ef699f33ecf14b6b', 'addColumn tableName=ITERATION; addUniqueConstraint constraintName=uc_iteration_uuid, tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-167-update-iteration-uuid-mysql::edegenetais
--  Created missing UUIDs on upgrade to add the not-null constraint.
UPDATE ITERATION SET UUID = uuid() WHERE UUID is NULL;

ALTER TABLE ITERATION MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-167-update-iteration-uuid-mysql', 'edegenetais', '../tm/tm.changelog-1.22.0.xml', NOW(), 4, '8:97ee959eb14b87fce015a7304edb4329', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-action-word-table::jlor
--  Add action word table
CREATE TABLE ACTION_WORD (ACTION_WORD_ID BIGINT AUTO_INCREMENT NOT NULL, `DESCRIPTION` LONGTEXT NULL, CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, TOKEN VARCHAR(766) NOT NULL, PROJECT_ID BIGINT NOT NULL, CONSTRAINT PK_ACTION_WORD PRIMARY KEY (ACTION_WORD_ID), CONSTRAINT fk_action_word_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID));

CREATE INDEX idx_fk_action_word_project ON ACTION_WORD(PROJECT_ID);

ALTER TABLE ACTION_WORD ADD CONSTRAINT uc_aw_token_project_id UNIQUE (TOKEN, PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-action-word-table', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 5, '8:9b22e3a2765e31b9300ba49843d31cda', 'createTable tableName=ACTION_WORD; createIndex indexName=idx_fk_action_word_project, tableName=ACTION_WORD; addUniqueConstraint constraintName=uc_aw_token_project_id, tableName=ACTION_WORD', 'Add action word table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-keyword-test-step-table::jlor
--  Add keyword test step table
CREATE TABLE KEYWORD_TEST_STEP (TEST_STEP_ID BIGINT NOT NULL COMMENT 'Shared key with TEST_STEP table', ACTION_WORD_ID BIGINT NOT NULL COMMENT 'The action word which this test step uses', KEYWORD VARCHAR(20) NOT NULL COMMENT 'A keyword test step keyword', DATATABLE TEXT NULL COMMENT 'A keyword test step datatable', DOCSTRING TEXT NULL COMMENT 'A keyword test step docstring', COMMENT TEXT NULL COMMENT 'A keyword test step comment', CONSTRAINT pk_keyword_test_step PRIMARY KEY (TEST_STEP_ID), CONSTRAINT fk_keyword_test_step_test_step FOREIGN KEY (TEST_STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_keyword_test_step_action_word_id FOREIGN KEY (ACTION_WORD_ID) REFERENCES ACTION_WORD (ACTION_WORD_ID));

CREATE INDEX idx_fk_keyword_test_step_action_word ON KEYWORD_TEST_STEP(ACTION_WORD_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-keyword-test-step-table', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 6, '8:9ea4af57ac8717e4d6e9cbb765ba10a3', 'createTable tableName=KEYWORD_TEST_STEP; createIndex indexName=idx_fk_keyword_test_step_action_word, tableName=KEYWORD_TEST_STEP', 'Add keyword test step table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-update-query-filter::jlor
--  Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder
update QUERY_FILTER_VALUES set FILTER_VALUE='org.squashtest.tm.domain.testcase.CallTestStep' where QUERY_FILTER_ID=1;

update QUERY_FILTER_COLUMN set QUERY_COLUMN_ID=134, FILTER_OPERATION='IS_CLASS' where QUERY_FILTER_ID=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-update-query-filter', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 7, '8:f73428381928dfb4b5c813c715ea5b36', 'sql; sql', 'Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION::jlor
--  Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column
CREATE TABLE KEYWORD_TEST_CASE (TCLN_ID BIGINT NOT NULL, CONSTRAINT PK_KEYWORD_TEST_CASE PRIMARY KEY (TCLN_ID), CONSTRAINT fk_keyword_tc_tc FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID));

ALTER TABLE SCRIPTED_TC_EXTENDER DROP COLUMN SCRIPTED_TC_EXTENDER_ID;

ALTER TABLE SCRIPTED_TC_EXTENDER RENAME SCRIPTED_TEST_CASE;

ALTER TABLE SCRIPTED_TEST_CASE DROP FOREIGN KEY fk_scripted_extender_test_case;

ALTER TABLE SCRIPTED_TEST_CASE CHANGE TEST_CASE_ID TCLN_ID BIGINT;

ALTER TABLE SCRIPTED_TEST_CASE ADD CONSTRAINT fk_scripted_extender_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE (TCLN_ID);

ALTER TABLE SCRIPTED_TEST_CASE ADD PRIMARY KEY (TCLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 8, '8:c1de3a0f1654209d41c56f4a0ced4cf0', 'createTable tableName=KEYWORD_TEST_CASE; dropColumn columnName=SCRIPTED_TC_EXTENDER_ID, tableName=SCRIPTED_TC_EXTENDER; renameTable newTableName=SCRIPTED_TEST_CASE, oldTableName=SCRIPTED_TC_EXTENDER; dropForeignKeyConstraint baseTableName=SCRIPTED...', 'Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype::jlor
--  In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity
update QUERY_COLUMN_PROTOTYPE set DATA_TYPE='ENTITY', COLUMN_TYPE='ENTITY' where QUERY_COLUMN_ID=184;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 9, '8:19a7c2029b3655a03380376c7ee16a34', 'sql', 'In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-drop-tc-kind-column::jlor
ALTER TABLE TEST_CASE DROP COLUMN TC_KIND;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-drop-tc-kind-column', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 10, '8:4301a9f6570c32fb97dc2adf1def1008', 'dropColumn columnName=TC_KIND, tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc::jlor
--  LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.
ALTER TABLE SCRIPTED_TEST_CASE DROP COLUMN LANGUAGE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 11, '8:02a9a59bb06bf18ebf59e78d9d8473f6', 'dropColumn columnName=LANGUAGE, tableName=SCRIPTED_TEST_CASE', 'LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-421-add-test-suite-uuid::aguilhem
ALTER TABLE TEST_SUITE ADD UUID VARCHAR(36) NULL;

ALTER TABLE TEST_SUITE ADD CONSTRAINT uc_test_suite_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-421-add-test-suite-uuid', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 12, '8:509ab177ee49be7eda3b756e636500c2', 'addColumn tableName=TEST_SUITE; addUniqueConstraint constraintName=uc_test_suite_uuid, tableName=TEST_SUITE', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-421-update-test-suite-uuid-mysql::aguilhem
--  Created missing UUIDs on upgrade to add the not-null constraint.
UPDATE TEST_SUITE SET UUID = uuid() WHERE UUID is NULL;

ALTER TABLE TEST_SUITE MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-421-update-test-suite-uuid-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 13, '8:5d54095afb8aee7def6d702b5361149c', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION::jlor
--  Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.
ALTER TABLE SCRIPTED_EXECUTION_EXTENDER RENAME SCRIPTED_EXECUTION;

ALTER TABLE SCRIPTED_EXECUTION DROP COLUMN SCRIPTED_EXECUTION_EXTENDER_ID;

ALTER TABLE SCRIPTED_EXECUTION ADD PRIMARY KEY (EXECUTION_ID);

ALTER TABLE SCRIPTED_EXECUTION DROP COLUMN LANGUAGE;

CREATE TABLE KEYWORD_EXECUTION (EXECUTION_ID BIGINT NOT NULL, CONSTRAINT PK_KEYWORD_EXECUTION PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_keyword_exec_exec FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 14, '8:06fcfa3a3c883a223c1adbe236167088', 'renameTable newTableName=SCRIPTED_EXECUTION, oldTableName=SCRIPTED_EXECUTION_EXTENDER; dropColumn columnName=SCRIPTED_EXECUTION_EXTENDER_ID, tableName=SCRIPTED_EXECUTION; addPrimaryKey tableName=SCRIPTED_EXECUTION; dropColumn columnName=LANGUAGE, ...', 'Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD::qtran
--  Create ACTION_WORD_FRAGMENT table
--  Create new table for Action word text elements
--  Create new table for Action word parameter elements
--  Create new table for Action word parameter value
CREATE TABLE ACTION_WORD_FRAGMENT (ACTION_WORD_FRAGMENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, auto-generated', ACTION_WORD_ID BIGINT NULL COMMENT 'Foreign key to the action word', FRAGMENT_ORDER INT NULL COMMENT 'the fragment order in action word fragment list', CONSTRAINT PK_ACTION_WORD_FRAGMENT PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_fragment_action_word_id FOREIGN KEY (ACTION_WORD_ID) REFERENCES ACTION_WORD(ACTION_WORD_ID)) COMMENT='base table for Action word fragments';

CREATE INDEX idx_fk_action_word_fragment_action_word_id ON ACTION_WORD_FRAGMENT(ACTION_WORD_ID);

ALTER TABLE ACTION_WORD_FRAGMENT ADD CONSTRAINT uc_action_word_fragment_order UNIQUE (ACTION_WORD_ID, FRAGMENT_ORDER);

CREATE TABLE ACTION_WORD_TEXT (ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'Shared key with ACTION_WORD_FRAGMENT table', TEXT VARCHAR(255) NOT NULL COMMENT 'the content of the action word text', CONSTRAINT PK_ACTION_WORD_TEXT PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_text_action_word_fragment FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_FRAGMENT(ACTION_WORD_FRAGMENT_ID));

CREATE INDEX idx_fk_action_word_text_action_word_fragment ON ACTION_WORD_TEXT(ACTION_WORD_FRAGMENT_ID);

CREATE TABLE ACTION_WORD_PARAMETER (ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'Shared key with ACTION_WORD_FRAGMENT table', NAME VARCHAR(255) NOT NULL COMMENT 'the name of the action word parameter', DEFAULT_VALUE VARCHAR(255) NOT NULL COMMENT 'the default value of the action word parameter', CONSTRAINT PK_ACTION_WORD_PARAMETER PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_parameter_action_word_fragment FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_FRAGMENT(ACTION_WORD_FRAGMENT_ID));

CREATE INDEX idx_fk_action_word_parameter_action_word_fragment ON ACTION_WORD_PARAMETER(ACTION_WORD_FRAGMENT_ID);

CREATE TABLE ACTION_WORD_PARAMETER_VALUE (ACTION_WORD_PARAMETER_VALUE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, auto-generated', VALUE VARCHAR(255) NOT NULL COMMENT 'the value of the action word parameter value', ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'the action word parameter by which this value replaces', KEYWORD_TEST_STEP_ID BIGINT NOT NULL COMMENT 'the keyword test step in which this value is used', CONSTRAINT PK_ACTION_WORD_PARAMETER_VALUE PRIMARY KEY (ACTION_WORD_PARAMETER_VALUE_ID), CONSTRAINT fk_action_word_parameter_value_action_word_fragment_id FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_PARAMETER(ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_parameter_value_keyword_test_step_id FOREIGN KEY (KEYWORD_TEST_STEP_ID) REFERENCES KEYWORD_TEST_STEP(TEST_STEP_ID));

CREATE INDEX idx_fk_action_word_parameter_value_action_word_fragment_id ON ACTION_WORD_PARAMETER_VALUE(ACTION_WORD_FRAGMENT_ID);

CREATE INDEX idx_fk_action_word_parameter_value_keyword_test_step_id ON ACTION_WORD_PARAMETER_VALUE(KEYWORD_TEST_STEP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD', 'qtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 15, '8:80490faa749274bfe39edad0ff1b28cd', 'createTable tableName=ACTION_WORD_FRAGMENT; createIndex indexName=idx_fk_action_word_fragment_action_word_id, tableName=ACTION_WORD_FRAGMENT; addUniqueConstraint constraintName=uc_action_word_fragment_order, tableName=ACTION_WORD_FRAGMENT; createT...', 'Create ACTION_WORD_FRAGMENT table
Create new table for Action word text elements
Create new table for Action word parameter elements
Create new table for Action word parameter value', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-302-action-word-workspace::jlor
--  Create action word library table
--  Insert corresponding entries in ACL tables
--  Add foreign key to the library in a project
--  Create one action word library for each existing project
CREATE TABLE ACTION_WORD_LIBRARY (AWL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to ATTACHMENT_LIST', CONSTRAINT PK_ACTION_WORD_LIBRARY PRIMARY KEY (AWL_ID), CONSTRAINT fk_awLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID));

CREATE INDEX idx_action_word_library ON ACTION_WORD_LIBRARY(AWL_ID);

CREATE INDEX idx_fk_awl_attachment_list ON ACTION_WORD_LIBRARY(ATTACHMENT_LIST_ID);

insert into ACL_CLASS(ID, CLASSNAME)
      values(8, 'org.squashtest.tm.domain.actionword.ActionWordLibrary');

insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      select AGP2.ACL_GROUP_ID, AGP2.PERMISSION_MASK, 8
      from ACL_GROUP_PERMISSION AGP2
      where CLASS_ID = 3;

ALTER TABLE PROJECT ADD AWL_ID BIGINT NULL;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_awl FOREIGN KEY (AWL_ID) REFERENCES ACTION_WORD_LIBRARY (AWL_ID);

CREATE INDEX idx_fk_project_awl ON PROJECT(AWL_ID);

-- Create the libraries --

      insert into ACTION_WORD_LIBRARY (AWL_ID)
        select p.PROJECT_ID
        from PROJECT p;

-- Attachments, Step 1 --
      -- Create a ranking table, akin to what would ROW_NUMBER() order by id desc would say --

      create table AWL_RANK as
        select awl.awl_id,
               count(awl2.awl_id) as ranking
        from ACTION_WORD_LIBRARY awl,
             ACTION_WORD_LIBRARY awl2
        where awl.awl_id <= awl2.awl_id
        group by awl.awl_id
        order by ranking asc;

-- Attachments, Step 2 --
      -- Create a table that pairs library ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier --

      create table AWL_ATTACHMENT_LIST_PAIRING as
        select awl_rank.awl_id,
               (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + awl_rank.ranking as attachment_list_id
        from AWL_RANK awl_rank;

-- Attachments, Step 3 --
      -- Insert the attachment lists and update fk in the action word library --

      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
        select pair.attachment_list_id
        from AWL_ATTACHMENT_LIST_PAIRING pair;

update ACTION_WORD_LIBRARY awl
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id
                                from AWL_ATTACHMENT_LIST_PAIRING pair
                                where pair.awl_id = awl.awl_id);

-- Attachments, Step 4 and final --
      -- Drop the temporary tables --

      drop table AWL_ATTACHMENT_LIST_PAIRING;

drop table AWL_RANK;

-- Bind the project to the AWL library --

      update PROJECT P
      set AWL_ID = PROJECT_ID;

-- Insert the acl object identities --

      insert into ACL_OBJECT_IDENTITY(IDENTITY, CLASS_ID)
        select awl.awl_id, 8 from ACTION_WORD_LIBRARY awl;

-- Add the user/team permissions in ACL_RESPONSIBILITY_SCOPE_ENTRY
      -- Each user will receive the same acl_group on each action word library than on the project it depends on
      -- (this last sentence is the idea behind the auto join on acl_object_identity in this query) --

      insert into ACL_RESPONSIBILITY_SCOPE_ENTRY(party_id, acl_group_id, object_identity_id)
        select distinct arse.party_id, arse.acl_group_id, awl_oid.id
        from ACL_RESPONSIBILITY_SCOPE_ENTRY arse
        inner join ACL_OBJECT_IDENTITY oid on (arse.object_identity_id = oid.id and oid.class_id = 1)
        inner join ACL_OBJECT_IDENTITY awl_oid on (oid.identity = awl_oid.identity and awl_oid.class_id = 8);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 16, '8:357323374c8bd4022311dccdc360f8de', 'createTable tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_action_word_library, tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_fk_awl_attachment_list, tableName=ACTION_WORD_LIBRARY; sql; addColumn tableName=PROJECT; createIndex...', 'Create action word library table
Insert corresponding entries in ACL tables
Add foreign key to the library in a project
Create one action word library for each existing project', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-302-action-word-workspace-2::jlor
--  Create action word library node table
--  Create one action word library node for each library created
--  Create action word library node relationship table
CREATE TABLE ACTION_WORD_LIBRARY_NODE (AWLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', NAME VARCHAR(255) NULL, ENTITY_TYPE VARCHAR(50) NULL, ENTITY_ID BIGINT NULL, AWL_ID BIGINT NULL COMMENT 'Foreign key to the ACTION_WORD_LIBRARY', CONSTRAINT PK_ACTION_WORD_LIBRARY_NODE PRIMARY KEY (AWLN_ID), CONSTRAINT fk_awln_awl FOREIGN KEY (AWL_ID) REFERENCES ACTION_WORD_LIBRARY(AWL_ID));

CREATE INDEX idx_action_word_library_node ON ACTION_WORD_LIBRARY_NODE(AWLN_ID);

CREATE INDEX idx_fk_awln_awl ON ACTION_WORD_LIBRARY_NODE(AWL_ID);

insert into ACTION_WORD_LIBRARY_NODE (AWL_ID, ENTITY_ID, ENTITY_TYPE)
      select AWL_ID, AWL_ID, 'LIBRARY'
      from ACTION_WORD_LIBRARY;

update ACTION_WORD_LIBRARY_NODE
      set NAME = (select p.NAME from PROJECT p where ENTITY_ID = p.AWL_ID)
      where ENTITY_TYPE = 'LIBRARY';

CREATE TABLE AWLN_RELATIONSHIP (ANCESTOR_ID BIGINT NULL COMMENT 'Foreign key to parent node', DESCENDANT_ID BIGINT NOT NULL COMMENT 'Foreign key to child node', CONTENT_ORDER BIGINT NULL COMMENT 'Order in its parent node', CONSTRAINT fk_awln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID), CONSTRAINT fk_awln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID));

CREATE INDEX idx_awln_relationship_descendant ON AWLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX idx_awln_relationship_ancestor ON AWLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace-2', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 17, '8:a8b4c9d2a4a0d9192a220a0cf5bac889', 'createTable tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_action_word_library_node, tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_fk_awln_awl, tableName=ACTION_WORD_LIBRARY_NODE; sql; createTable tableName=AWLN_RELA...', 'Create action word library node table
Create one action word library node for each library created
Create action word library node relationship table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-794-auditable-automated-suite::aguilhem
--  Make Automated Suite auditable
ALTER TABLE AUTOMATED_SUITE ADD CREATED_BY VARCHAR(50) NULL;

ALTER TABLE AUTOMATED_SUITE ADD CREATED_ON datetime NULL;

ALTER TABLE AUTOMATED_SUITE ADD LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL;

ALTER TABLE AUTOMATED_SUITE ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-794-auditable-automated-suite', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 18, '8:89c3edca29fb9158d99f47df8644e662', 'addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', 'Make Automated Suite auditable', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-794-automated-suite-migration-mysql::aguilhem
--  Add audit data on automated suite for mysql
UPDATE AUTOMATED_SUITE asuite
      INNER JOIN (
        select ex.CREATED_ON, ex.CREATED_BY, ex.LAST_MODIFIED_BY, ex.LAST_MODIFIED_ON, ext.SUITE_ID
        from AUTOMATED_EXECUTION_EXTENDER ext
        inner join EXECUTION ex on ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
        order by ex.LAST_MODIFIED_ON desc
      ) AS exec
      ON exec.SUITE_ID = asuite.SUITE_ID
      SET asuite.CREATED_ON = exec.CREATED_ON,
          asuite.CREATED_BY = exec.CREATED_BY,
          asuite.LAST_MODIFIED_BY = exec.LAST_MODIFIED_BY,
          asuite.LAST_MODIFIED_ON = exec.LAST_MODIFIED_ON;

UPDATE AUTOMATED_SUITE
      SET CREATED_ON = '2000-01-01 00:00:00.0',
      CREATED_BY = 'admin'
      WHERE CREATED_ON IS NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_ON DATETIME NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(50) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-794-automated-suite-migration-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 19, '8:1b6acb827f4de7609109c660d2b81581', 'sql', 'Add audit data on automated suite for mysql', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-795::aguilhem
--  Adds a execution status field to the automated suites
ALTER TABLE AUTOMATED_SUITE ADD EXECUTION_STATUS VARCHAR(255) DEFAULT 'READY' NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-795', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 20, '8:2545fb692f41e233d959e25f061768bd', 'addColumn tableName=AUTOMATED_SUITE', 'Adds a execution status field to the automated suites', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-795-migration-mysql::aguilhem
--  Compute preexisting automated suites status for mysql
UPDATE AUTOMATED_SUITE asuite
      INNER JOIN
      (
        SELECT automated_suite.SUITE_ID,
              blocked_count.counter as blocked_count,
              untestable_count.counter as untestable_count,
              settled_count.counter as settled_count,
              failure_count.counter as failure_count,
              success_count.counter as success_count,
              running_count.counter as running_count,
              total_count.counter as total_count
        FROM AUTOMATED_SUITE as automated_suite
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('BLOCKED', 'ERROR', 'NOT_RUN')
          GROUP BY ext.SUITE_ID) as blocked_count
        ON automated_suite.SUITE_ID = blocked_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('UNTESTABLE', 'NOT_FOUND')
          GROUP BY ext.SUITE_ID) as untestable_count
        ON automated_suite.SUITE_ID = untestable_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SETTLED', 'UNTESTABLE', 'NOT_FOUND')
          GROUP BY ext.SUITE_ID) as settled_count
        ON automated_suite.SUITE_ID = settled_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS = 'FAILURE'
          GROUP BY ext.SUITE_ID) as failure_count
        ON automated_suite.SUITE_ID = failure_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SUCCESS', 'UNTESTABLE', 'SETTLED', 'NOT_FOUND', 'WARNING')
          GROUP BY ext.SUITE_ID) as success_count
        ON automated_suite.SUITE_ID = success_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SUCCESS', 'UNTESTABLE', 'SETTLED', 'NOT_FOUND', 'WARNING')
          GROUP BY ext.SUITE_ID) as running_count
        ON automated_suite.SUITE_ID = running_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          GROUP BY ext.SUITE_ID) as total_count
          ON automated_suite.SUITE_ID = total_count.SUITE_ID
      ) as count_table
      ON asuite.SUITE_ID = count_table.SUITE_ID
      SET asuite.EXECUTION_STATUS = (
        CASE
          WHEN (count_table.blocked_count IS NOT NULL AND count_table.blocked_count > 0) THEN 'BLOCKED'
          WHEN (count_table.untestable_count IS NOT NULL AND count_table.untestable_count = count_table.total_count) THEN 'UNTESTABLE'
          WHEN (count_table.settled_count IS NOT NULL AND count_table.settled_count = count_table.total_count) THEN 'SETTLED'
          WHEN (count_table.failure_count IS NOT NULL AND count_table.failure_count > 0) THEN 'FAILURE'
          WHEN (count_table.success_count IS NOT NULL AND count_table.success_count = count_table.total_count) THEN 'SUCCESS'
          WHEN (count_table.running_count IS NOT NULL AND count_table.running_count > 0) THEN 'RUNNING'
          ELSE 'READY'
        END
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-795-migration-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 21, '8:ed56340d2b40dff22b2ed9fffaf528f4', 'sql', 'Compute preexisting automated suites status for mysql', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns::jprioux
--  add indexes on default search sort columns
CREATE INDEX idx_project_name ON PROJECT(NAME);

CREATE INDEX idx_tc_reference ON TEST_CASE(`REFERENCE`);

CREATE INDEX idx_tc_importance ON TEST_CASE(IMPORTANCE);

CREATE INDEX idx_req_reference ON REQUIREMENT_VERSION(`REFERENCE`);

CREATE INDEX idx_req_status ON REQUIREMENT_VERSION(REQUIREMENT_STATUS);

CREATE INDEX idx_req_criticality ON REQUIREMENT_VERSION(CRITICALITY);

CREATE INDEX idx_iteration_name ON ITERATION(NAME);

CREATE INDEX idx_cln_name ON CAMPAIGN_LIBRARY_NODE(NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns', 'jprioux', '../tm/tm.changelog-1.22.0.xml', NOW(), 22, '8:ddd3e53dd0db6e2388b067f003d2af0c', 'createIndex indexName=idx_project_name, tableName=PROJECT; createIndex indexName=idx_tc_reference, tableName=TEST_CASE; createIndex indexName=idx_tc_importance, tableName=TEST_CASE; createIndex indexName=idx_req_reference, tableName=REQUIREMENT_VE...', 'add indexes on default search sort columns', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-891::aguilhem
--  Automated Suite can be directly linked to an iteration or a test suite
ALTER TABLE AUTOMATED_SUITE ADD ITERATION_ID BIGINT NULL, ADD TEST_SUITE_ID BIGINT NULL;

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_iteration FOREIGN KEY (ITERATION_ID) REFERENCES ITERATION (ITERATION_ID);

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_test_suite FOREIGN KEY (TEST_SUITE_ID) REFERENCES TEST_SUITE (ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-891', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 23, '8:3c63dafa6caa65c87bf1c2fb2e276184', 'addColumn tableName=AUTOMATED_SUITE', 'Automated Suite can be directly linked to an iteration or a test suite', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language::jlor
ALTER TABLE PROJECT ADD BDD_IMPLEMENTATION_TECHNOLOGY VARCHAR(30) DEFAULT 'CUCUMBER' NOT NULL, ADD BDD_SCRIPT_LANGUAGE VARCHAR(30) DEFAULT 'ENGLISH' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 24, '8:e6b7e355cdf35114da07e367b3f8a4b1', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-306-create-closure-table::mqtran
--  closure table for action word library nodes. Its content is set and modified by 4 triggers
CREATE TABLE AWLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_awln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID), CONSTRAINT fk_awln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID));

CREATE INDEX idx_awln_relationship_clos_desc ON AWLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_awln_relationship_clos_anc ON AWLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

ALTER TABLE AWLN_RELATIONSHIP_CLOSURE ADD UNIQUE (ANCESTOR_ID, DESCENDANT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-306-create-closure-table', 'mqtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 25, '8:06bcc0cfcc52a9439894246fb1e2e7d7', 'createTable tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_desc, tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_anc, tableName=AWLN_RELATIONSHIP_CLOSURE; addUniqueConstr...', 'closure table for action word library nodes. Its content is set and modified by 4 triggers', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-306-closure-mysql-trigger::mqtran
--  mysql-triggers for AWLN_RELATIONSHIP_CLOSURE table
create trigger ins_awln_after after insert on
      ACTION_WORD_LIBRARY_NODE
      for each row insert ignore into
      AWLN_RELATIONSHIP_CLOSURE values (new.awln_id, new.awln_id, 0);

create trigger del_awln_before before delete on
      ACTION_WORD_LIBRARY_NODE
      for each row delete from
      AWLN_RELATIONSHIP_CLOSURE where ancestor_id=old.awln_id and
      descendant_id=old.awln_id;

create trigger attach_awln_after after insert on AWLN_RELATIONSHIP
      for each row insert ignore into AWLN_RELATIONSHIP_CLOSURE
      select
      c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
      from
      AWLN_RELATIONSHIP_CLOSURE c1
      cross join AWLN_RELATIONSHIP_CLOSURE c2
      where c1.descendant_id = new.ancestor_id
      and c2.ancestor_id = new.descendant_id;

create trigger detach_awln_before before delete on
      AWLN_RELATIONSHIP
      for each row delete clos1 from
      AWLN_RELATIONSHIP_CLOSURE clos1
      join AWLN_RELATIONSHIP_CLOSURE clos2
      on
      clos1.descendant_id=clos2.descendant_id
      left join
      AWLN_RELATIONSHIP_CLOSURE clos3
      on clos3.ancestor_id = clos2.ancestor_id
      and clos3.descendant_id = clos1.ancestor_id
      where
      clos2.ancestor_id = old.descendant_id
      and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-306-closure-mysql-trigger', 'mqtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 26, '8:99c94bd8dee7684f5708cbdd8be51714', 'sql; sql; sql; sql', 'mysql-triggers for AWLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date::jlor
ALTER TABLE ACTION_WORD ADD LAST_IMPLEMENTATION_TECHNOLOGY VARCHAR(30) NULL COMMENT 'Technology used for last implementation' , ADD LAST_IMPLEMENTATION_DATE datetime NULL COMMENT 'Date of last implementation';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 27, '8:fa4f55442bdc4ef925b0f0f7b47241e6', 'addColumn tableName=ACTION_WORD', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1284-migration-mysql::qtran
--  Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
--  Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
--  Remove all CUF values and CUF value options attaching to any deleted Requirement folder for postgresql
DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN TEST_CASE_FOLDER tcf
        ON cfv.BOUND_ENTITY_ID = tcf.TCLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER'
        AND tcf.TCLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER') AS cfv
        LEFT JOIN TEST_CASE_FOLDER tcf
        ON cfv.BOUND_ENTITY_ID = tcf.TCLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER'
        AND tcf.TCLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN CAMPAIGN_FOLDER cf
        ON cfv.BOUND_ENTITY_ID = cf.CLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER'
        AND cf.CLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER') AS cfv
        LEFT JOIN CAMPAIGN_FOLDER cf
        ON cfv.BOUND_ENTITY_ID = cf.CLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER'
        AND cf.CLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN REQUIREMENT_FOLDER rf
        ON cfv.BOUND_ENTITY_ID = rf.RLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER'
        AND rf.RLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER') AS cfv
        LEFT JOIN REQUIREMENT_FOLDER rf
        ON cfv.BOUND_ENTITY_ID = rf.RLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER'
        AND rf.RLN_ID is null
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1284-migration-mysql', 'qtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 28, '8:844ad09002420d65905a1f0cb00722a0', 'sql; sql; sql', 'Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
Remove all CUF values and CUF value options at...', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url::akatz
ALTER TABLE TEST_CASE ADD SOURCE_CODE_REPOSITORY_URL VARCHAR(255) NULL COMMENT 'The url of the source code repository where the test lies' , ADD AUTOMATED_TEST_REFERENCE VARCHAR(255) NULL COMMENT 'The path to the test';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url', 'akatz', '../tm/tm.changelog-1.22.0.xml', NOW(), 29, '8:424581cf54ca82b5e98d6b7a11d5ece9', 'addColumn tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-1::aguilhem
--  Preparation for data migration
CREATE TABLE MIG_SQUASH_1975 (OLD_ID BIGINT NOT NULL, NEW_ID BIGINT NULL, CONSTRAINT PK_MIG_SQUASH_1975 PRIMARY KEY (OLD_ID));

ALTER TABLE TEST_AUTOMATION_PROJECT DROP FOREIGN KEY fk_ta_project_ta_server;

ALTER TABLE PROJECT DROP FOREIGN KEY tm_project_ta_server;

INSERT INTO MIG_SQUASH_1975 (OLD_ID, NEW_ID)
      SELECT TEST_AUTOMATION_SERVER.SERVER_ID, coalesce(max(THIRD_PARTY_SERVER.SERVER_ID),0) + TAS.TAS_MAX_ID + TEST_AUTOMATION_SERVER.SERVER_ID as NEW_ID
      FROM TEST_AUTOMATION_SERVER
      LEFT JOIN THIRD_PARTY_SERVER ON 1=1
      LEFT JOIN (SELECT coalesce(max(TEST_AUTOMATION_SERVER.SERVER_ID),0) AS TAS_MAX_ID FROM TEST_AUTOMATION_SERVER) AS TAS ON  1 = 1
      GROUP BY TEST_AUTOMATION_SERVER.SERVER_ID, TAS.TAS_MAX_ID
      ORDER BY TEST_AUTOMATION_SERVER.SERVER_ID;

INSERT INTO THIRD_PARTY_SERVER (SERVER_ID, NAME, URL, AUTH_POLICY, AUTH_PROTOCOL)
      SELECT MIG_SQUASH_1975.NEW_ID, TEST_AUTOMATION_SERVER.NAME, TEST_AUTOMATION_SERVER.BASE_URL, 'APP_LEVEL', 'BASIC_AUTH'
      FROM TEST_AUTOMATION_SERVER
      INNER JOIN MIG_SQUASH_1975 on MIG_SQUASH_1975.OLD_ID = TEST_AUTOMATION_SERVER.SERVER_ID
      ORDER BY TEST_AUTOMATION_SERVER.SERVER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-1', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 30, '8:2abe3a47754f5fabba4f030020b0b6e3', 'createTable tableName=MIG_SQUASH_1975; dropForeignKeyConstraint baseTableName=TEST_AUTOMATION_PROJECT, constraintName=fk_ta_project_ta_server; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=tm_project_ta_server; sql', 'Preparation for data migration', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-2-mysql::aguilhem
--  Transform Test Automation Server to Third Party Server
UPDATE TEST_AUTOMATION_SERVER ta_server
      INNER JOIN MIG_SQUASH_1975 mig
      ON ta_server.SERVER_ID = mig.OLD_ID
      SET ta_server.SERVER_ID = mig.NEW_ID;

UPDATE TEST_AUTOMATION_PROJECT ta_proj
      INNER JOIN MIG_SQUASH_1975 mig
      ON ta_proj.SERVER_ID = mig.OLD_ID
      SET ta_proj.SERVER_ID = mig.NEW_ID;

UPDATE PROJECT proj
      INNER JOIN MIG_SQUASH_1975 mig
      ON proj.TA_SERVER_ID = mig.OLD_ID
      SET proj.TA_SERVER_ID = mig.NEW_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-2-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 31, '8:7e59a4918ea64e2b44459c1ac6fce782', 'sql', 'Transform Test Automation Server to Third Party Server', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-3::aguilhem
--  Finalisation of test automation server data migration
ALTER TABLE TEST_AUTOMATION_SERVER DROP KEY UNI_AUTOTEST_SERVER;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN NAME;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN BASE_URL;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN LOGIN;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN PASSWORD;

ALTER TABLE TEST_AUTOMATION_PROJECT ADD CONSTRAINT fk_ta_project_ta_server FOREIGN KEY (SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE PROJECT ADD CONSTRAINT tm_project_ta_server FOREIGN KEY (TA_SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE TEST_AUTOMATION_SERVER ADD CONSTRAINT fk_test_automation_server_third_party_server FOREIGN KEY (SERVER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

DROP TABLE MIG_SQUASH_1975;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-3', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 32, '8:54e999b15137f7b0ea516c8f04d4aefe', 'dropUniqueConstraint constraintName=UNI_AUTOTEST_SERVER, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=NAME, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=BASE_URL, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=LOGIN,...', 'Finalisation of test automation server data migration', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-4-mysql::aguilhem
--  For Mysql / Maria DB, remove the autoincrement on server_id
set foreign_key_checks=0;

alter table TEST_AUTOMATION_SERVER modify column SERVER_ID BIGINT not null;

set foreign_key_checks=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-4-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 33, '8:3c57a8bd44361b4d2a171cccef22573e', 'sql', 'For Mysql / Maria DB, remove the autoincrement on server_id', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-808-automated-suites-lifetime::jlor
ALTER TABLE PROJECT ADD AUTOMATED_SUITES_LIFETIME INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-808-automated-suites-lifetime', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 34, '8:686610a61a21f666f4433fe91d6d4f37', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement::jlor
--  Replace null descriptions by empty strings in requirements
update RESOURCE
      set DESCRIPTION = ''
      where DESCRIPTION is NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 35, '8:016cf5b75e98acf9ad9a2156392d1158', 'sql', 'Replace null descriptions by empty strings in requirements', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2106-automated-suite-attachment::aguilhem
--  Give possibility to AUTOMATED_SUITE to have ATTACHMENT
ALTER TABLE AUTOMATED_SUITE ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'foreign key to ATTACHMENT_LIST, entity dealing with attachment.';

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 36, '8:3a1e95ebd72330ea10047f0e5eb063b0', 'addColumn tableName=AUTOMATED_SUITE', 'Give possibility to AUTOMATED_SUITE to have ATTACHMENT', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2106-automated-suite-attachment-2::aguilhem
--  Create one attachment list for each automated suite
-- attachments, step 1 :
      -- create a ranking table, akin to what would ROW_NUMBER() order by id desc would say

      create table ASUITE_RANK as
      select asuite.suite_id, count(asuite2.suite_id)  as ranking
      from AUTOMATED_SUITE asuite,
      AUTOMATED_SUITE asuite2
      where asuite.suite_id <= asuite2.suite_id
      group by asuite.suite_id
      order by ranking asc;

-- attachments, step 2 :
      -- create a table that pairs suite ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier

      create table ASUITE_ATTACHLIST_PAIRING as
      select asuite.suite_id, (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + asuite.ranking as attachment_list_id
      from ASUITE_RANK asuite;

-- attachments, step 3 :
      -- insert the attachment lists and update fk in the automated suite
      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
      select pair.attachment_list_id from ASUITE_ATTACHLIST_PAIRING pair;

update AUTOMATED_SUITE asuite
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id from ASUITE_ATTACHLIST_PAIRING pair where pair.suite_id = asuite.suite_id);

-- attachments, step 4 and final :
      -- drop the temporary tables

      drop table ASUITE_ATTACHLIST_PAIRING;

drop table ASUITE_RANK;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment-2', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 37, '8:1f936d07cc345e9989ad30ba2003bd60', 'sql', 'Create one attachment list for each automated suite', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2141-automated-test-technology::aguilhem
--  create automated test technology table
CREATE TABLE AUTOMATED_TEST_TECHNOLOGY (AT_TECHNOLOGY_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(50) NOT NULL, ACTION_PROVIDER_KEY VARCHAR(50) NOT NULL, CONSTRAINT PK_AUTOMATED_TEST_TECHNOLOGY PRIMARY KEY (AT_TECHNOLOGY_ID));

insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('Robot Framework', 'robotframework/execute@v1'),
      ('Cypress', 'cypress/execute@v1'),
      ('JUnit', 'junit/execute@v1'),
      ('Cucumber', 'cucumber/execute@v1');

ALTER TABLE TEST_CASE ADD AUTOMATED_TEST_TECHNOLOGY BIGINT NULL COMMENT 'foreign key to AUTOMATED_TEST_TECHNOLOGY';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_test_case_automated_test_technology FOREIGN KEY (AUTOMATED_TEST_TECHNOLOGY) REFERENCES AUTOMATED_TEST_TECHNOLOGY (AT_TECHNOLOGY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2141-automated-test-technology', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 38, '8:0004b1046102aac90079cfed96744a61', 'createTable tableName=AUTOMATED_TEST_TECHNOLOGY; sql; addColumn tableName=TEST_CASE', 'create automated test technology table', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config::jprioux
--  add system parameter for autoconnect on connection configuration
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('autoconnect.on.connection.enabled', 'false');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config', 'jprioux', '../tm/tm.changelog-1.22.0.xml', NOW(), 39, '8:3a759e92d54d14ea83f54ec05c7e9e90', 'insert tableName=CORE_CONFIG', 'add system parameter for autoconnect on connection configuration', 'EXECUTED', NULL, NULL, '4.19.0', '4780600073');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

