/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.rest.admin.service.RestAdministrationService;
import org.squashtest.tm.service.system.SystemAdministrationService;

@Service
@Transactional
public class RestAdministrationServiceImpl
implements RestAdministrationService {
    private final SystemAdministrationService administrationService;

    public RestAdministrationServiceImpl(SystemAdministrationService administrationService) {
        this.administrationService = administrationService;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String modifyWelcomeMessage(String updatedWelcomeMessage) {
        if (updatedWelcomeMessage != null) {
            return this.administrationService.changeWelcomeMessage(updatedWelcomeMessage);
        }
        throw new IllegalArgumentException("Cannot update the welcome message with null value.");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String modifyLoginMessage(String updatedLoginMessage) {
        if (updatedLoginMessage != null) {
            return this.administrationService.changeLoginMessage(updatedLoginMessage);
        }
        throw new IllegalArgumentException("Cannot update the login message with null value.");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String modifyBannerMessage(String updatedBannerMessage) {
        if (updatedBannerMessage != null) {
            return this.administrationService.changeBannerMessage(updatedBannerMessage);
        }
        throw new IllegalArgumentException("Cannot update the banner message with null value.");
    }
}

