/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.squashtest.tm.domain.scm.ScmRepository;

public class ScmRepositorySerializer
extends StdSerializer<Collection<ScmRepository>> {
    public static final Comparator<ScmRepository> ID_COMPARATOR = new Comparator<ScmRepository>(){

        @Override
        public int compare(ScmRepository p, ScmRepository q) {
            if (p.getId() == q.getId()) {
                return p.getName().compareTo(q.getName());
            }
            if (p.getId() > q.getId()) {
                return 1;
            }
            return -1;
        }
    };

    public ScmRepositorySerializer() {
        super(TypeFactory.defaultInstance().constructType(Collection.class));
    }

    private void doSerialize(Collection<ScmRepository> scmRespositories, JsonGenerator gen) throws IOException {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        ArrayList<ScmRepository> listScmRepository = new ArrayList<ScmRepository>(scmRespositories);
        Collections.sort(listScmRepository, ID_COMPARATOR);
        gen.writeStartArray();
        for (ScmRepository scmRepository : listScmRepository) {
            attributes.put("_type", "scm-repository");
            attributes.put("id", scmRepository.getId());
            attributes.put("name", scmRepository.getName());
            attributes.put("repository_path", scmRepository.getRepositoryPath());
            attributes.put("working_folder_path", scmRepository.getWorkingFolderPath());
            attributes.put("working_branch", scmRepository.getWorkingBranch());
            attributes.put("_links", new HashMap<String, Object>(scmRepository){
                {
                    this.put("self", new HashMap<String, String>(scmRepository){
                        {
                            this.put("href", "http://localhost:8080/api/rest/latest/scm-repositories/" + scmRepository.getId());
                        }
                    });
                }
            });
            gen.writeObject(attributes);
        }
        gen.writeEndArray();
    }

    public void serialize(Collection<ScmRepository> scmRepositories, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.doSerialize(scmRepositories, jsonGenerator);
    }
}

