/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.service.RestScmRepositoryService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestScmRepositoryController
extends RestAdminBaseController {
    @Inject
    private RestScmRepositoryService scmRepositoryService;

    @GetMapping(value={"/scm-repositories/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="_type, id, name, repository_path, working_folder_path, working_branch,scm_server[*]")
    public ResponseEntity<EntityModel<ScmRepository>> findScmRepositoryById(@PathVariable(value="id") Long repoId) {
        ScmRepository scmRepository = this.scmRepositoryService.findScmRepositoryById(repoId);
        EntityModel<ScmRepository> res = this.customResource(scmRepository);
        return ResponseEntity.ok(res);
    }

    @PatchMapping(value={"/scm-repositories/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, scm_server[*]")
    public ResponseEntity<EntityModel<ScmRepository>> patchScmRepository(@PathVariable(value="id") Long repoId, @RequestParam(value="branch") String newBranch) throws BindException, IOException {
        ScmRepository scmRepository = this.scmRepositoryService.updateBranch(repoId, newBranch);
        EntityModel<ScmRepository> res = this.customResource(scmRepository);
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/scm-repositories/{ids}"})
    public ResponseEntity<Void> removeScmRepository(@PathVariable(value="ids") List<Long> scmRepositoriesIds) {
        this.scmRepositoryService.deleteRepository(scmRepositoriesIds);
        return ResponseEntity.noContent().build();
    }
}

