/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableOption;
import org.squashtest.tm.domain.environmentvariable.SingleSelectEnvironmentVariable;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RestEnvironmentVariableDto;
import org.squashtest.tm.plugin.rest.admin.service.RestEnvironmentVariableService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableManagerService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestEnvironmentVariableController
extends BaseRestController {
    @Inject
    private RestEnvironmentVariableService environmentVariableService;
    @Inject
    private EnvironmentVariableManagerService environmentVariableManagerService;
    private final EnvironmentVariableResourceAssembler evRessourceAssembler = new EnvironmentVariableResourceAssembler();

    @GetMapping(value={"/environment-variables"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<RestEnvironmentVariableDto>>> findAllEnvironmentVariables(Pageable pageable) {
        Page<EnvironmentVariable> pageEnvironmentVariable = this.environmentVariableService.findSortedEnvironmentVariable(pageable);
        Page<RestEnvironmentVariableDto> pageEnvironmentVariableDto = this.pageEnvironmentVariableToPageEnvironmentVariableDto(pageEnvironmentVariable);
        PagedModel res = this.pageAssembler.toModel(pageEnvironmentVariableDto, (RepresentationModelAssembler)this.evRessourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/environment-variables/{id}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RestEnvironmentVariableDto>> findOneEnvironmentVariableById(@PathVariable(value="id") long evId) {
        EnvironmentVariable ev = this.environmentVariableService.findById(evId);
        EntityModel<RestEnvironmentVariableDto> res = this.environmentVariableToResource(ev);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/environment-variables"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RestEnvironmentVariableDto>> createEnvironmentVariable(@RequestBody RestEnvironmentVariableDto evDto) {
        EnvironmentVariable ev = this.environmentVariableDtoToEnvironmentVariable(evDto);
        EnvironmentVariable newEV = this.environmentVariableService.addEnvironmentVariable(ev);
        EntityModel<RestEnvironmentVariableDto> res = this.environmentVariableToResource(newEV);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestEnvironmentVariableController)((Object)WebMvcLinkBuilder.methodOn(RestEnvironmentVariableController.class, (Object[])new Object[0]))).findOneEnvironmentVariableById(newEV.getId())));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/environment-variables/{id}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RestEnvironmentVariableDto>> updateEnvironmentVariableName(@PathVariable(value="id") long evId, @RequestBody RestEnvironmentVariableDto evDto) {
        EnvironmentVariable updatedEV = this.environmentVariableService.updateEnvironmentVariableName(evId, evDto);
        EntityModel<RestEnvironmentVariableDto> res = this.environmentVariableToResource(updatedEV);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestEnvironmentVariableController)((Object)WebMvcLinkBuilder.methodOn(RestEnvironmentVariableController.class, (Object[])new Object[0]))).findOneEnvironmentVariableById(updatedEV.getId())));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/environment-variables/{ids}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<String> deleteEnvironmentVariableByIds(@PathVariable(value="ids") List<Long> evIds) {
        this.environmentVariableManagerService.deleteEnvironmentVariable(evIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/environment-variables/{id}/options"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RestEnvironmentVariableDto>> addEnvironmentVariableOption(@PathVariable(value="id") long evId, @RequestBody EnvironmentVariableOption evOption) {
        this.environmentVariableManagerService.addOption(evId, evOption.getLabel());
        EnvironmentVariable ev = this.environmentVariableService.findById(evId);
        EntityModel<RestEnvironmentVariableDto> res = this.environmentVariableToResource(ev);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestEnvironmentVariableController)((Object)WebMvcLinkBuilder.methodOn(RestEnvironmentVariableController.class, (Object[])new Object[0]))).findOneEnvironmentVariableById(evId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/environment-variables/{id}/options/{optionLabel}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RestEnvironmentVariableDto>> updateEnvironmentVariableOption(@PathVariable(value="id") long evId, @PathVariable(value="optionLabel") String optionLabel, @RequestBody EnvironmentVariableOption newEVOption) {
        EnvironmentVariable updatedEV = this.environmentVariableService.updateEnvironmentVariableOption(evId, optionLabel, newEVOption);
        EntityModel<RestEnvironmentVariableDto> res = this.environmentVariableToResource(updatedEV);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestEnvironmentVariableController)((Object)WebMvcLinkBuilder.methodOn(RestEnvironmentVariableController.class, (Object[])new Object[0]))).findOneEnvironmentVariableById(updatedEV.getId())));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/environment-variables/{id}/options/{optionsLabel}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteEnvironmentVariableOption(@PathVariable(value="id") long evId, @PathVariable(value="optionsLabel") List<String> optionsLabel) {
        this.environmentVariableManagerService.removeOptions(Long.valueOf(evId), optionsLabel);
        return ResponseEntity.noContent().build();
    }

    private Page<RestEnvironmentVariableDto> pageEnvironmentVariableToPageEnvironmentVariableDto(Page<EnvironmentVariable> pageEV) {
        return pageEV.map(this::environmentVariableToEnvironmentVariableDto);
    }

    private EntityModel<RestEnvironmentVariableDto> environmentVariableToResource(EnvironmentVariable ev) {
        RestEnvironmentVariableDto environmentVariableDto = this.environmentVariableToEnvironmentVariableDto(ev);
        return EntityModel.of((Object)environmentVariableDto);
    }

    private RestEnvironmentVariableDto environmentVariableToEnvironmentVariableDto(EnvironmentVariable ev) {
        ArrayList<EnvironmentVariableOption> options = new ArrayList();
        if (ev.getInputType() == EVInputType.DROPDOWN_LIST) {
            options = this.environmentVariableService.findSingleSelectEnvironmentVariableOptionsByEVId(ev.getId());
        }
        return new RestEnvironmentVariableDto(ev.getId(), ev.getInputType(), ev.getName(), options);
    }

    private EnvironmentVariable environmentVariableDtoToEnvironmentVariable(RestEnvironmentVariableDto evDto) {
        EnvironmentVariable ev = new EnvironmentVariable(evDto.getInputType());
        if (ev.getInputType() == EVInputType.DROPDOWN_LIST) {
            ev = this.createSingleSelectEnvironmentVariable(evDto.getOptions());
        }
        ev.setName(evDto.getName());
        return ev;
    }

    private EnvironmentVariable createSingleSelectEnvironmentVariable(List<EnvironmentVariableOption> options) {
        SingleSelectEnvironmentVariable ssev = new SingleSelectEnvironmentVariable();
        for (EnvironmentVariableOption option : options) {
            ssev.addOption(option);
        }
        SingleSelectEnvironmentVariable res = ssev;
        return res;
    }

    private class EnvironmentVariableResourceAssembler
    implements RepresentationModelAssembler<RestEnvironmentVariableDto, EntityModel<RestEnvironmentVariableDto>> {
        private EnvironmentVariableResourceAssembler() {
        }

        public EntityModel<RestEnvironmentVariableDto> toModel(RestEnvironmentVariableDto entity) {
            EntityModel res = EntityModel.of((Object)entity);
            LinkBuilder builder = RestEnvironmentVariableController.this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestEnvironmentVariableController)((Object)WebMvcLinkBuilder.methodOn(RestEnvironmentVariableController.class, (Object[])new Object[0]))).findOneEnvironmentVariableById(entity.getId())));
            res.add(Link.of((String)builder.toString(), (String)"self"));
            return res;
        }
    }
}

