/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BugTrackerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RestServerOAuth2ConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.service.RestBugTrackerService;
import org.squashtest.tm.plugin.rest.admin.validators.BugTrackerValidator;
import org.squashtest.tm.plugin.rest.admin.validators.CredentialsValidator;
import org.squashtest.tm.plugin.rest.admin.validators.ServerOAuth2ConfigurationValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackerModificationService;
import org.squashtest.tm.service.internal.servers.ServerOAuth2Conf;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestBugTrackerController
extends RestAdminBaseController {
    private static final String POST_AUTHENTICATION_CONFIGURATION = "post-authentication-configuration";
    private static final String INCOMPATIBLE_PROTOCOL_ERROR = "The target bug tracker authentication protocol is not OAuth. It is not possible to set a configuration.";
    @Inject
    private BugTrackerManagerService btManagerService;
    @Inject
    private BugTrackerModificationService btModificationService;
    @Inject
    private RestBugTrackerService btService;
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    private ServerOAuth2ConfigurationValidator serverOAuth2ConfigurationValidator;
    private BugTrackerResourceAssembler btResourceAssembler = new BugTrackerResourceAssembler();
    @Inject
    private BugTrackerValidator btValidator;
    @Inject
    private CredentialsValidator credentialsValidator;

    @GetMapping(value={"/bug-trackers"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<BugTrackerDto>>> findAllBugtrackers(Pageable pageable) {
        Page pageBugtracker = this.btManagerService.findSortedBugtrackers(pageable);
        Page<BugTrackerDto> pageBugtrackerDto = this.pageBugtrackerToPageBugtrackerDto((Page<BugTracker>)pageBugtracker);
        PagedModel res = this.pageAssembler.toModel(pageBugtrackerDto, (RepresentationModelAssembler)this.btResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/bug-trackers/{bugtrackerId}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<BugTrackerDto>> findBugTrackerById(@PathVariable(value="bugtrackerId") Long bugtrackerId) {
        BugTracker bt = this.btService.findById(bugtrackerId);
        EntityModel<BugTrackerDto> res = this.customToResource(bt);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/bug-trackers/kind/{bugtrackerKind}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<List<BugTrackerDto>> findAllBugtrackersByKind(@PathVariable(value="bugtrackerKind") String bugtrackerKind) {
        List bugtrackerList = this.btManagerService.findByKind(bugtrackerKind);
        return ResponseEntity.ok(this.listBugtrackerToListBugtrackerDto(bugtrackerList));
    }

    @PostMapping(value={"/bug-trackers"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<BugTrackerDto>> createBugtracker(@RequestBody BugTrackerDto bugTrackerDto) throws BindException {
        this.btValidator.bugtrackerPostValidator(bugTrackerDto.getId(), bugTrackerDto);
        BugTracker bugTracker = this.bugTrackerDtoToBugTracker(bugTrackerDto);
        BugTracker saveBt = this.btService.createBugTracker(bugTracker);
        EntityModel<BugTrackerDto> res = this.customToResource(saveBt);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestBugTrackerController)WebMvcLinkBuilder.methodOn(RestBugTrackerController.class, (Object[])new Object[0])).findBugTrackerById(saveBt.getId())));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/bug-trackers/{id}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<BugTrackerDto>> updateBugtrackers(@PathVariable(value="id") Long bugtrackerId, @RequestBody BugTrackerDto bugTrackerDto) throws BindException {
        this.btValidator.bugtrackerPatchValidator(bugtrackerId, bugTrackerDto);
        BugTracker bt = this.btService.updateBugTracker(bugtrackerId, bugTrackerDto);
        EntityModel<BugTrackerDto> res = this.customToResource(bt);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/bug-trackers/{ids}"})
    public ResponseEntity<Void> deleteBugtrackerById(@PathVariable(value="ids") List<Long> bugtrackerIds) {
        this.btManagerService.deleteBugTrackers(bugtrackerIds);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/bug-trackers/{id}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> getCredential(@PathVariable(value="id") Long bugtrackerId) {
        ManageableCredentials cred = this.btModificationService.findCredentials(bugtrackerId.longValue());
        if (Objects.isNull(cred)) {
            return ResponseEntity.noContent().build();
        }
        if (AuthenticationProtocol.OAUTH_2 == cred.getImplementedProtocol()) {
            throw new AccessDeniedException("Credentials can not be retrieved for a bug tracker configured with OAuth 2.");
        }
        EntityModel<ManageableCredentials> res = this.customResource(cred);
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/bug-trackers/{id}/auth-configuration"})
    @DynamicFilterExpression(value="*, -client_secret")
    public ResponseEntity<EntityModel<ServerAuthConfiguration>> getBugtrackersOauthAuthentication(@PathVariable(value="id") Long bugtrackerId) {
        ServerAuthConfiguration requestedConfiguration = this.btModificationService.findAuthConfiguration(bugtrackerId.longValue());
        if (requestedConfiguration != null) {
            EntityModel<ServerAuthConfiguration> res = this.customResource(requestedConfiguration);
            return ResponseEntity.ok(res);
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/bug-trackers/{id}/auth-configuration"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ServerAuthConfiguration>> configureBugtrackersOauthAuthentification(@PathVariable(value="id") Long bugtrackerId, @RequestBody RestServerOAuth2ConfigurationDto configurationDto) throws BindException {
        this.validatePostServerAuthConfiguration(bugtrackerId, configurationDto);
        ServerOAuth2Conf configuration = configurationDto.convertDto();
        this.btModificationService.storeAuthConfiguration(bugtrackerId.longValue(), (ServerAuthConfiguration)configuration);
        EntityModel<ServerAuthConfiguration> res = this.customResource(this.btModificationService.findAuthConfiguration(bugtrackerId.longValue()));
        return ResponseEntity.ok(res);
    }

    private void validatePostServerAuthConfiguration(Long bugtrackerId, RestServerOAuth2ConfigurationDto configurationDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)configurationDto, POST_AUTHENTICATION_CONFIGURATION);
        this.serverOAuth2ConfigurationValidator.validate(configurationDto, (Errors)validationBean);
        BugTracker bugTracker = this.btService.findById(bugtrackerId);
        if (!AuthenticationProtocol.OAUTH_2.equals((Object)bugTracker.getAuthenticationProtocol())) {
            throw new IllegalArgumentException(INCOMPATIBLE_PROTOCOL_ERROR);
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)configurationDto, errors, (String)POST_AUTHENTICATION_CONFIGURATION);
    }

    @PostMapping(value={"/bug-trackers/{id}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> setBugtrackerCredentials(@PathVariable(value="id") Long bugtrackerId, @RequestBody ManageableCredentialsDto credentialsDto) throws BindException {
        this.credentialsValidator.validatePostCredentialsForBugTracker(bugtrackerId, credentialsDto);
        ManageableCredentials credentials = credentialsDto.convertDto();
        this.btModificationService.storeCredentials(bugtrackerId.longValue(), credentials);
        EntityModel<ManageableCredentials> res = this.customToResourceForCredential(bugtrackerId, credentials);
        return ResponseEntity.ok(res);
    }

    private BugTracker bugTrackerDtoToBugTracker(BugTrackerDto bugTrackerDto) {
        BugTracker bugTracker = new BugTracker();
        bugTracker.setName(bugTrackerDto.getName());
        bugTracker.setUrl(bugTrackerDto.getUrl());
        bugTracker.setKind(bugTrackerDto.getKind());
        bugTracker.setIframeFriendly(bugTrackerDto.getIframeFriendly());
        bugTracker.setAuthenticationPolicy(bugTrackerDto.getAuthenticationPolicy());
        bugTracker.setAuthenticationProtocol(bugTrackerDto.getAuthenticationProtocol());
        bugTracker.setDescription(bugTrackerDto.getDescription());
        return bugTracker;
    }

    private Page<BugTrackerDto> pageBugtrackerToPageBugtrackerDto(Page<BugTracker> pageBt) {
        return pageBt.map(bt -> new BugTrackerDto(bt.getId(), bt.getName(), bt.getUrl(), bt.getKind(), bt.isIframeFriendly(), bt.getAuthenticationPolicy(), bt.getAuthenticationProtocol(), bt.getDescription(), bt.getCreatedBy(), bt.getCreatedOn(), bt.getLastModifiedBy(), bt.getLastModifiedOn()));
    }

    private List<BugTrackerDto> listBugtrackerToListBugtrackerDto(List<BugTracker> listBt) {
        ArrayList<BugTrackerDto> listBtDto = new ArrayList<BugTrackerDto>();
        for (BugTracker bugTracker : listBt) {
            BugTrackerDto btDto = this.bugtrackerToBugtrackerDto(bugTracker);
            listBtDto.add(btDto);
        }
        return listBtDto;
    }

    private BugTrackerDto bugtrackerToBugtrackerDto(BugTracker bt) {
        return new BugTrackerDto(bt.getId(), bt.getName(), bt.getUrl(), bt.getKind(), bt.isIframeFriendly(), bt.getAuthenticationPolicy(), bt.getAuthenticationProtocol(), bt.getDescription(), bt.getCreatedBy(), bt.getCreatedOn(), bt.getLastModifiedBy(), bt.getLastModifiedOn());
    }

    private EntityModel<ManageableCredentials> customToResourceForCredential(long bugTrackerId, ManageableCredentials credentials) {
        EntityModel res = EntityModel.of((Object)credentials);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestBugTrackerController)WebMvcLinkBuilder.methodOn(RestBugTrackerController.class, (Object[])new Object[0])).getCredential(bugTrackerId)));
        res.add(builder.withSelfRel());
        return res;
    }

    private EntityModel<BugTrackerDto> customToResource(BugTracker bugTracker) {
        BugTrackerDto bugTrackerDto = this.bugtrackerToBugtrackerDto(bugTracker);
        return EntityModel.of((Object)bugTrackerDto);
    }

    private class BugTrackerResourceAssembler
    implements RepresentationModelAssembler<BugTrackerDto, EntityModel<BugTrackerDto>> {
        private BugTrackerResourceAssembler() {
        }

        public EntityModel<BugTrackerDto> toModel(BugTrackerDto entity) {
            EntityModel res = EntityModel.of((Object)entity);
            LinkBuilder builder = RestBugTrackerController.this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestBugTrackerController)WebMvcLinkBuilder.methodOn(RestBugTrackerController.class, (Object[])new Object[0])).findBugTrackerById(entity.getId())));
            res.add(Link.of((String)builder.toString(), (String)"self"));
            return res;
        }
    }
}

