/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Providers;
import plugin.rtc.org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutPart {
    private MultivaluedMap<String, String> headers = new CaseInsensitiveMultivaluedMap<String>();
    private Object body;
    private static final Logger logger = LoggerFactory.getLogger(OutPart.class);

    public void addHeader(String name, String value) {
        this.getHeaders().add(name, value);
    }

    public void setContentType(String contentType) {
        this.getHeaders().putSingle("Content-Type", contentType);
    }

    public String getContentType() {
        String res = this.getHeaders().getFirst("Content-Type");
        if (res == null) {
            res = "text/plain";
        }
        return res;
    }

    public void setLocationHeader(String location) {
        this.getHeaders().putSingle("location", location);
    }

    protected void writeBody(OutputStream os, Providers providers) throws IOException {
        if (this.getBody() != null) {
            MessageBodyWriter<?> writer = providers.getMessageBodyWriter(this.getBody().getClass(), null, null, MediaType.valueOf(this.getContentType()));
            if (writer == null) {
                logger.error(Messages.getMessage("couldNotFindWriter", this.getBody().getClass(), this.getContentType()));
                throw new WebApplicationException(500);
            }
            writer.writeTo(this.getBody(), this.getBody().getClass(), null, null, MediaType.valueOf(this.getContentType()), this.getHeaders(), os);
        }
    }

    public void writePart(OutputStream os, Providers providers) throws IOException {
        for (String name : this.getHeaders().keySet()) {
            List values = (List)this.getHeaders().get(name);
            for (String value : values) {
                String header = name + ": " + value + "\r\n";
                os.write(header.getBytes());
            }
        }
        os.write("\r\n".getBytes());
        this.writeBody(os, providers);
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public Object getBody() {
        return this.body;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }
}

