/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.atom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;
import plugin.rtc.org.apache.wink.common.RestException;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.model.ModelUtils;
import plugin.rtc.org.apache.wink.common.internal.utils.JAXBUtils;
import plugin.rtc.org.apache.wink.common.model.atom.AtomCategory;
import plugin.rtc.org.apache.wink.common.model.atom.AtomCommonAttributes;
import plugin.rtc.org.apache.wink.common.model.atom.AtomContent;
import plugin.rtc.org.apache.wink.common.model.atom.AtomLink;
import plugin.rtc.org.apache.wink.common.model.atom.AtomPerson;
import plugin.rtc.org.apache.wink.common.model.atom.AtomText;
import plugin.rtc.org.apache.wink.common.model.atom.ObjectFactory;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCategory;
import plugin.rtc.org.apache.wink.common.model.synd.SyndContent;
import plugin.rtc.org.apache.wink.common.model.synd.SyndEntry;
import plugin.rtc.org.apache.wink.common.model.synd.SyndLink;
import plugin.rtc.org.apache.wink.common.model.synd.SyndPerson;
import plugin.rtc.org.apache.wink.common.model.synd.SyndText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlAccessorOrder(value=XmlAccessOrder.UNDEFINED)
@XmlType(name="atomEntry", propOrder={"id", "updated", "title", "summary", "published", "link", "author", "contributor", "category", "any", "content"})
public class AtomEntry
extends AtomCommonAttributes {
    private static final String MATCH_ANY_PATTERN = ".*";
    @XmlElement(required=true)
    protected String id;
    @XmlElement(required=true)
    protected XMLGregorianCalendar updated;
    @XmlElement(required=true)
    protected AtomText title;
    protected AtomText summary;
    protected XMLGregorianCalendar published;
    protected List<AtomLink> link;
    protected List<AtomPerson> author;
    protected List<AtomPerson> contributor;
    protected List<AtomCategory> category;
    @XmlAnyElement
    protected List<Element> any;
    protected AtomContent content;
    @XmlTransient
    private static final JAXBContext atomContext;

    public static Marshaller getMarshaller() {
        Marshaller marshaller = JAXBUtils.createMarshaller(atomContext);
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller() {
        return JAXBUtils.createUnmarshaller(atomContext);
    }

    public static AtomEntry unmarshal(Reader reader) throws IOException {
        return (AtomEntry)ModelUtils.unmarshal(AtomEntry.getUnmarshaller(), reader);
    }

    public static void marshal(AtomEntry entry, OutputStream os) throws IOException {
        JAXBElement<AtomEntry> entryElement = new ObjectFactory().createEntry(entry);
        Marshaller marshaller = AtomEntry.getMarshaller();
        ModelUtils.marshal(marshaller, entryElement, os);
    }

    public AtomEntry() {
    }

    public AtomEntry(SyndEntry value) {
        super(value);
        if (value == null) {
            return;
        }
        this.setId(value.getId());
        this.setPublished(value.getPublished());
        this.setSummary(value.getSummary() != null ? new AtomText(value.getSummary()) : null);
        this.setTitle(value.getTitle() != null ? new AtomText(value.getTitle()) : null);
        this.setUpdated(value.getUpdated());
        this.setAuthors(value.getAuthors());
        this.setCategories(value.getCategories());
        this.setLinks(value.getLinks());
        this.setContent(value.getContent() != null ? new AtomContent(value.getContent()) : null);
    }

    public SyndEntry toSynd(SyndEntry value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        value.setId(this.getId());
        value.setPublished(this.getPublished());
        value.setSummary(this.getSummary() != null ? this.getSummary().toSynd(new SyndText()) : null);
        value.setTitle(this.getTitle() != null ? this.getTitle().toSynd(new SyndText()) : null);
        value.setUpdated(this.getUpdated());
        value.setContent(this.getContent() != null ? this.getContent().toSynd(new SyndContent()) : null);
        value.getAuthors().addAll(this.getAuthorsAsSynd());
        value.getCategories().addAll(this.getCategoriesAsSynd());
        value.getLinks().addAll(this.getLinksAsSynd());
        return value;
    }

    private List<SyndPerson> getAuthorsAsSynd() {
        ArrayList<SyndPerson> authors = new ArrayList<SyndPerson>();
        for (AtomPerson value : this.getAuthors()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndPerson()));
        }
        return authors;
    }

    private List<SyndCategory> getCategoriesAsSynd() {
        ArrayList<SyndCategory> authors = new ArrayList<SyndCategory>();
        for (AtomCategory value : this.getCategories()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndCategory()));
        }
        return authors;
    }

    private List<SyndLink> getLinksAsSynd() {
        ArrayList<SyndLink> authors = new ArrayList<SyndLink>();
        for (AtomLink value : this.getLinks()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndLink()));
        }
        return authors;
    }

    private void setAuthors(List<SyndPerson> values) {
        this.author = new ArrayList<AtomPerson>();
        for (SyndPerson value : values) {
            if (value == null) continue;
            this.author.add(new AtomPerson(value));
        }
    }

    private void setCategories(List<SyndCategory> values) {
        this.category = new ArrayList<AtomCategory>();
        for (SyndCategory value : values) {
            if (value == null) continue;
            this.category.add(new AtomCategory(value));
        }
    }

    private void setLinks(List<SyndLink> values) {
        this.link = new ArrayList<AtomLink>();
        for (SyndLink value : values) {
            if (value == null) continue;
            this.link.add(new AtomLink(value));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public long getUpdatedAsTime() {
        return ModelUtils.xmlGregorianCalendarToTime(this.updated);
    }

    public Date getUpdated() {
        long updatedAsTime = this.getUpdatedAsTime();
        if (updatedAsTime == -1L) {
            return null;
        }
        return new Date(updatedAsTime);
    }

    public void setUpdated(XMLGregorianCalendar value) {
        this.updated = value;
    }

    public void setUpdated(long value) {
        this.setUpdated(ModelUtils.timeToXmlGregorianCalendar(value));
    }

    public void setUpdated(Date value) {
        if (value == null) {
            this.updated = null;
            return;
        }
        this.setUpdated(value.getTime());
    }

    public AtomText getTitle() {
        return this.title;
    }

    public void setTitle(AtomText value) {
        this.title = value;
    }

    public AtomText getSummary() {
        return this.summary;
    }

    public void setSummary(AtomText value) {
        this.summary = value;
    }

    public long getPublishedAsTime() {
        return ModelUtils.xmlGregorianCalendarToTime(this.published);
    }

    public Date getPublished() {
        long publishedAsTime = this.getPublishedAsTime();
        if (publishedAsTime == -1L) {
            return null;
        }
        return new Date(publishedAsTime);
    }

    public void setPublished(XMLGregorianCalendar value) {
        this.published = value;
    }

    public void setPublished(long value) {
        this.setPublished(ModelUtils.timeToXmlGregorianCalendar(value));
    }

    public void setPublished(Date value) {
        if (value == null) {
            this.published = null;
            return;
        }
        this.setPublished(value.getTime());
    }

    public List<AtomLink> getLinks() {
        if (this.link == null) {
            this.link = new ArrayList<AtomLink>();
        }
        return this.link;
    }

    public List<AtomLink> getLinks(String relationPattern, String typePattern) {
        if (relationPattern == null || typePattern == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "pattern"));
        }
        ArrayList<AtomLink> matchingLinks = new ArrayList<AtomLink>();
        List<AtomLink> links = this.getLinks();
        for (AtomLink link : links) {
            String rel = link.getRel();
            String type = link.getType();
            if (rel == null) {
                rel = "";
            }
            if (type == null) {
                type = "";
            }
            if (!rel.matches(relationPattern) || !type.matches(typePattern)) continue;
            matchingLinks.add(link);
        }
        return matchingLinks;
    }

    public List<AtomLink> getLinksByType(String typePattern) {
        return this.getLinks(MATCH_ANY_PATTERN, typePattern);
    }

    public List<AtomLink> getLinksByRelation(String relationPattern) {
        return this.getLinks(relationPattern, MATCH_ANY_PATTERN);
    }

    public List<AtomPerson> getAuthors() {
        if (this.author == null) {
            this.author = new ArrayList<AtomPerson>();
        }
        return this.author;
    }

    public List<AtomPerson> getContributors() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<AtomPerson>();
        }
        return this.contributor;
    }

    public List<AtomCategory> getCategories() {
        if (this.category == null) {
            this.category = new ArrayList<AtomCategory>();
        }
        return this.category;
    }

    public List<Element> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Element>();
        }
        return this.any;
    }

    public AtomContent getContent() {
        return this.content;
    }

    public void setContent(AtomContent value) {
        this.content = value;
    }

    static {
        try {
            atomContext = JAXBContext.newInstance((String)AtomEntry.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new RestException(Messages.getMessage("failedToCreateJAXBContextFor", "AtomEntry"), e);
        }
    }
}

