/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.registry.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.DefaultValue;
import plugin.rtc.javax.ws.rs.Encoded;
import plugin.rtc.javax.ws.rs.HttpMethod;
import plugin.rtc.javax.ws.rs.Path;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.org.apache.wink.common.DynamicResource;
import plugin.rtc.org.apache.wink.common.annotations.Parent;
import plugin.rtc.org.apache.wink.common.annotations.Workspace;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.registry.Injectable;
import plugin.rtc.org.apache.wink.common.internal.registry.InjectableFactory;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.AbstractMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import plugin.rtc.org.apache.wink.common.internal.utils.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMetadataCollector
extends AbstractMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(ResourceMetadataCollector.class);

    private ResourceMetadataCollector(Class<?> clazz) {
        super(clazz);
    }

    public static boolean isResource(Class<?> cls) {
        return ResourceMetadataCollector.isStaticResource(cls) || ResourceMetadataCollector.isDynamicResource(cls);
    }

    public static boolean isStaticResource(Class<?> cls) {
        if (Modifier.isInterface(cls.getModifiers()) || Modifier.isAbstract(cls.getModifiers())) {
            logger.trace("isStaticResource() exit returning false because interface or abstract");
            return false;
        }
        if (cls.getAnnotation(Path.class) != null) {
            logger.trace("isStaticResource() exit returning true");
            return true;
        }
        Class<?> declaringClass = cls;
        while (!declaringClass.equals(Object.class)) {
            Class<?>[] interfaces;
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass.getAnnotation(Path.class) != null) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("rootResourceShouldBeAnnotatedDirectly", cls, superclass));
                }
                logger.trace("isStaticResource() exit returning true because {} has @Path", superclass);
                return true;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                if (interfaceClass.getAnnotation(Path.class) == null) continue;
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("rootResourceShouldBeAnnotatedDirectly", cls, interfaceClass));
                }
                logger.trace("isStaticResource() exit returning true because {} has @Path", interfaceClass);
                return true;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        logger.trace("isStaticResource() exit returning false");
        return false;
    }

    public static boolean isDynamicResource(Class<?> cls) {
        return DynamicResource.class.isAssignableFrom(cls);
    }

    public static ClassMetadata collectMetadata(Class<?> clazz) {
        logger.trace("collectMetadata({}) entry", clazz);
        ResourceMetadataCollector collector = new ResourceMetadataCollector(clazz);
        collector.parseClass();
        collector.parseFields();
        collector.parseConstructors();
        collector.parseMethods();
        ClassMetadata md = collector.getMetadata();
        logger.trace("collectMetadata() exit returning {}", (Object)md);
        return md;
    }

    @Override
    protected final Injectable parseAccessibleObject(AccessibleObject field, Type fieldType) {
        Injectable injectable = InjectableFactory.getInstance().create(fieldType, field.getAnnotations(), (Member)((Object)field), this.getMetadata().isEncoded(), null);
        if (injectable.getParamType() == Injectable.ParamType.ENTITY) {
            return null;
        }
        return injectable;
    }

    private void parseClass() {
        Class<?> cls = this.getMetadata().getResourceClass();
        this.parseClass(cls);
    }

    private boolean parseClass(Class<?> cls) {
        logger.trace("parseClass({})", cls);
        boolean workspacePresent = this.parseWorkspace(cls);
        boolean pathPresent = this.parsePath(cls);
        boolean consumesPresent = this.parseClassConsumes(cls);
        boolean producesPresent = this.parseClassProduces(cls);
        Parent parent = cls.getAnnotation(Parent.class);
        if (parent != null) {
            this.getMetadata().getParents().add(parent.value());
        }
        this.parseEncoded(cls);
        return workspacePresent || pathPresent || consumesPresent || producesPresent;
    }

    private boolean parseWorkspace(Class<?> cls) {
        Workspace workspace = cls.getAnnotation(Workspace.class);
        if (workspace != null) {
            this.getMetadata().setWorkspaceName(workspace.workspaceTitle());
            this.getMetadata().setCollectionTitle(workspace.collectionTitle());
            return true;
        }
        return false;
    }

    private boolean parsePath(Class<?> cls) {
        Path path = cls.getAnnotation(Path.class);
        if (path != null) {
            this.getMetadata().addPath(path.value());
            logger.trace("parseClass() returning true for class direct");
            return true;
        }
        Class<?> declaringClass = cls;
        while (!declaringClass.equals(Object.class)) {
            Class<?>[] interfaces;
            Class<?> superclass = declaringClass.getSuperclass();
            path = superclass.getAnnotation(Path.class);
            if (path != null) {
                this.getMetadata().addPath(path.value());
                logger.trace("parseClass() returning true for superclass {}", superclass);
                return true;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                path = interfaceClass.getAnnotation(Path.class);
                if (path == null) continue;
                this.getMetadata().addPath(path.value());
                logger.trace("parseClass() returning true for interface {}", interfaceClass);
                return true;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        logger.trace("parseClass() returning false");
        return false;
    }

    private void parseMethods() {
        logger.trace("entry");
        block0: for (Method method : this.getMetadata().getResourceClass().getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) continue;
            MethodMetadata methodMetadata = this.createMethodMetadata(method);
            logger.trace("Found methodMetadata {} for method {}", (Object)methodMetadata, (Object)method);
            if (methodMetadata == null) continue;
            String path = methodMetadata.getPath();
            String httpMethod = methodMetadata.getHttpMethod();
            if (path != null) {
                if (httpMethod != null) {
                    logger.trace("Was subresource method");
                    this.getMetadata().getSubResourceMethods().add(methodMetadata);
                    continue;
                }
                logger.trace("Was subresource locator");
                String methodName = String.format("%s.%s", declaringClass.getName(), method.getName());
                for (Injectable id : methodMetadata.getFormalParameters()) {
                    if (id.getParamType() != Injectable.ParamType.ENTITY) continue;
                    if (!logger.isWarnEnabled()) continue block0;
                    logger.warn(Messages.getMessage("subresourceLocatorIllegalEntityParameter", methodName));
                    continue block0;
                }
                if (!(methodMetadata.getConsumes().isEmpty() && methodMetadata.getProduces().isEmpty() || !logger.isWarnEnabled())) {
                    logger.warn(Messages.getMessage("subresourceLocatorAnnotatedConsumesProduces", methodName));
                }
                this.getMetadata().getSubResourceLocators().add(methodMetadata);
                continue;
            }
            logger.trace("Was resource method");
            this.getMetadata().getResourceMethods().add(methodMetadata);
        }
        logger.trace("exit");
    }

    private MethodMetadata createMethodMetadata(Method method) {
        String[] produces;
        String[] consumes;
        Path path;
        logger.trace("createMethodMetadata({})", (Object)method);
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            return null;
        }
        MethodMetadata metadata = new MethodMetadata(this.getMetadata());
        metadata.setReflectionMethod(method);
        boolean hasAnnotation = false;
        HttpMethod httpMethod = this.getHttpMethod(method);
        if (httpMethod != null) {
            hasAnnotation = true;
            metadata.setHttpMethod(httpMethod.value());
        }
        if ((path = this.getPath(method)) != null) {
            hasAnnotation = true;
            metadata.addPath(path.value());
        }
        for (String mediaType : consumes = this.getConsumes(method)) {
            hasAnnotation = true;
            metadata.addConsumes(MediaType.valueOf(mediaType));
        }
        for (String mediaType : produces = this.getProduces(method)) {
            hasAnnotation = true;
            metadata.addProduces(MediaType.valueOf(mediaType));
        }
        String defaultValue = this.getDefaultValue(method);
        if (defaultValue != null) {
            metadata.setDefaultValue(defaultValue);
            hasAnnotation = true;
        }
        if (method.getAnnotation(Encoded.class) != null) {
            metadata.setEncoded(true);
            hasAnnotation = true;
        }
        if (!hasAnnotation) {
            Class<?>[] interfaces;
            MethodMetadata createdMetadata;
            logger.trace("Method did not directly have annotation so going up the class hierarchy chain");
            Class<?> declaringClass = method.getDeclaringClass();
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass != null && superclass != Object.class && (createdMetadata = this.createMethodMetadata(superclass, method)) != null) {
                this.mergeFormalParameterMetadata(createdMetadata, method);
                logger.trace("createMethodMetadata() exit returning {} from superclass {}", (Object)createdMetadata, superclass);
                return createdMetadata;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                MethodMetadata createdMetadata2 = this.createMethodMetadata(interfaceClass, method);
                if (createdMetadata2 == null) continue;
                this.mergeFormalParameterMetadata(createdMetadata2, method);
                logger.trace("createMethodMetadata() exit returning {} from interface {}", (Object)createdMetadata2, interfaceClass);
                return createdMetadata2;
            }
            logger.trace("createdMethodMetadata() returning null");
            return null;
        }
        if (metadata.getHttpMethod() == null && metadata.getPath() == null) {
            if (metadata.isEncoded() || defaultValue != null) {
                logger.trace("createdMethodMetadata() returning null");
                return null;
            }
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("methodNotAnnotatedCorrectly", method.getName(), method.getDeclaringClass().getCanonicalName()));
            }
            logger.trace("createdMethodMetadata() returning null");
            return null;
        }
        this.parseMethodParameters(method, metadata);
        logger.trace("createMethodMetadata() exit returning {}", (Object)metadata);
        return metadata;
    }

    private MethodMetadata createMethodMetadata(Class<?> declaringClass, Method method) {
        logger.trace("createMethodMetadata({}, {}) entry", declaringClass, (Object)method);
        try {
            Method declaredMethod = declaringClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return this.createMethodMetadata(declaredMethod);
        }
        catch (SecurityException e) {
            logger.trace("createMethodMetadata() exit returning null because of SecurityException");
            return null;
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method candidateMethod : methods = declaringClass.getMethods()) {
                boolean matchFound = true;
                if (!candidateMethod.getName().equals(method.getName()) || candidateMethod.getParameterTypes().length != method.getParameterTypes().length) continue;
                for (int i = 0; i < candidateMethod.getParameterTypes().length; ++i) {
                    Class<?> clazz = candidateMethod.getParameterTypes()[i];
                    if (clazz.isPrimitive() && !clazz.equals(candidateMethod.getParameterTypes()[i])) {
                        matchFound = false;
                    }
                    if (clazz.isAssignableFrom(method.getParameterTypes()[i])) continue;
                    matchFound = false;
                }
                if (!matchFound) continue;
                return this.createMethodMetadata(candidateMethod);
            }
            logger.trace("createMethodMetadata() exit returning null because of NoSuchMethodException");
            return null;
        }
    }

    private boolean parseClassConsumes(Class<?> cls) {
        String[] consumes;
        for (String mediaType : consumes = this.getConsumes(cls)) {
            this.getMetadata().addConsumes(MediaType.valueOf(mediaType));
        }
        return true;
    }

    private boolean parseClassProduces(Class<?> cls) {
        String[] consumes;
        for (String mediaType : consumes = this.getProduces(cls)) {
            this.getMetadata().addProduces(MediaType.valueOf(mediaType));
        }
        return true;
    }

    private String[] getConsumes(AnnotatedElement element) {
        Consumes consumes = element.getAnnotation(Consumes.class);
        if (consumes != null) {
            return AnnotationUtils.parseConsumesProducesValues(consumes.value());
        }
        return new String[0];
    }

    private String[] getProduces(AnnotatedElement element) {
        Produces produces = element.getAnnotation(Produces.class);
        if (produces != null) {
            return AnnotationUtils.parseConsumesProducesValues(produces.value());
        }
        return new String[0];
    }

    private Path getPath(Method method) {
        return method.getAnnotation(Path.class);
    }

    private HttpMethod getHttpMethod(Method method) {
        HttpMethod httpMethod = null;
        for (Annotation annotation : method.getAnnotations()) {
            HttpMethod httpMethodCurr = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethodCurr == null) continue;
            if (httpMethod != null) {
                throw new IllegalStateException(Messages.getMessage("multipleHttpMethodAnnotations", method.getName(), method.getDeclaringClass().getCanonicalName()));
            }
            httpMethod = httpMethodCurr;
        }
        return httpMethod;
    }

    private String getDefaultValue(Method method) {
        DefaultValue defaultValueAnn = method.getAnnotation(DefaultValue.class);
        if (defaultValueAnn != null) {
            return defaultValueAnn.value();
        }
        return null;
    }

    private void parseMethodParameters(Method method, MethodMetadata methodMetadata) {
        logger.trace("parseMethodParameters({}, {}), entry", (Object)method, (Object)methodMetadata);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Type[] paramTypes = this.getParamTypesFilterByXmlElementAnnotation(method);
        boolean entityParamExists = false;
        int limit = paramTypes.length;
        for (int pos = 0; pos < limit; ++pos) {
            Injectable fp = InjectableFactory.getInstance().create(paramTypes[pos], parameterAnnotations[pos], method, this.getMetadata().isEncoded() || methodMetadata.isEncoded(), methodMetadata.getDefaultValue());
            if (fp.getParamType() == Injectable.ParamType.ENTITY) {
                if (entityParamExists) {
                    String methodName = method.getDeclaringClass().getName() + "." + method.getName();
                    throw new IllegalStateException(Messages.getMessage("resourceMethodMoreThanOneEntityParam", methodName));
                }
                entityParamExists = true;
            }
            methodMetadata.getFormalParameters().add(fp);
            logger.trace("Adding formal parameter {}", (Object)fp);
        }
        logger.trace("parseMethodParameters(), exit");
    }

    private Type[] getParamTypesFilterByXmlElementAnnotation(Method method) {
        Annotation[][] paramAnnotations;
        int index = 0;
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] arr$ = paramAnnotations = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annos;
            for (Annotation anno : annos = arr$[i$]) {
                XmlElement xmlElement;
                Class type;
                if (!anno.annotationType().equals(XmlElement.class) || (type = (xmlElement = (XmlElement)anno).type()) == null) continue;
                paramTypes[index] = type;
            }
            ++index;
        }
        return paramTypes;
    }

    private void mergeFormalParameterMetadata(MethodMetadata metadata, Method method) {
        logger.trace("mergeFormalParameterMetadata({})", new Object[]{metadata, method});
        Type[] parameterTypes = method.getGenericParameterTypes();
        ArrayList<Injectable> currentParameters = new ArrayList<Injectable>(metadata.getFormalParameters());
        metadata.getFormalParameters().clear();
        int i = 0;
        for (Injectable injectable : currentParameters) {
            Injectable fp = InjectableFactory.getInstance().create(parameterTypes[i], injectable.getAnnotations(), method, this.getMetadata().isEncoded() || metadata.isEncoded(), metadata.getDefaultValue());
            metadata.getFormalParameters().add(fp);
            ++i;
        }
        logger.trace("mergeFormalParameterMetadata exit");
    }

    @Override
    protected final boolean isConstructorParameterValid(Injectable fp) {
        return fp.getParamType() != Injectable.ParamType.ENTITY;
    }
}

