/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.header;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;
import plugin.rtc.org.apache.wink.common.internal.http.AcceptCharset;
import plugin.rtc.org.apache.wink.common.internal.utils.SoftConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptCharsetHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<AcceptCharset> {
    private static final SoftConcurrentMap<String, AcceptCharset> cache = new SoftConcurrentMap();

    @Override
    public AcceptCharset fromString(String value) throws IllegalArgumentException {
        AcceptCharset cached = cache.get(value);
        if (cached != null) {
            return cached;
        }
        LinkedList<String> acceptable = new LinkedList<String>();
        LinkedList<String> banned = new LinkedList<String>();
        boolean anyAllowed = value == null;
        List<AcceptCharset.ValuedCharset> vCharsets = this.parseAcceptCharset(value);
        for (AcceptCharset.ValuedCharset qCharset : vCharsets) {
            if (anyAllowed) {
                if (qCharset.qValue != 0.0 || qCharset.isWildcard()) continue;
                banned.add(qCharset.charset);
                continue;
            }
            if (qCharset.qValue == 0.0) break;
            if (qCharset.isWildcard()) {
                anyAllowed = true;
                continue;
            }
            acceptable.add(qCharset.charset);
        }
        return cache.put(value, new AcceptCharset(value, acceptable, banned, anyAllowed, vCharsets));
    }

    private List<AcceptCharset.ValuedCharset> parseAcceptCharset(String acceptableCharsetValue) {
        LinkedList<AcceptCharset.ValuedCharset> qCharsets = new LinkedList<AcceptCharset.ValuedCharset>();
        if (acceptableCharsetValue == null) {
            return qCharsets;
        }
        for (String charsetRange : acceptableCharsetValue.split(",")) {
            String charsetSpec;
            double qValue;
            int semicolonIndex = charsetRange.indexOf(59);
            if (semicolonIndex == -1) {
                qValue = 1.0;
                charsetSpec = charsetRange;
            } else {
                charsetSpec = charsetRange.substring(0, semicolonIndex);
                int equalsIndex = charsetRange.indexOf(61, semicolonIndex + 1);
                String qString = charsetRange.substring(equalsIndex != -1 ? equalsIndex + 1 : charsetRange.length());
                try {
                    qValue = Double.parseDouble(qString.trim());
                }
                catch (NumberFormatException nfe) {
                    qValue = 1.0;
                }
            }
            charsetSpec = charsetSpec.trim();
            if (charsetSpec.length() == 0) continue;
            if (charsetSpec.equals("*")) {
                qCharsets.add(new AcceptCharset.ValuedCharset(qValue, null));
                continue;
            }
            qCharsets.add(new AcceptCharset.ValuedCharset(qValue, charsetSpec));
        }
        Collections.sort(qCharsets, Collections.reverseOrder());
        return qCharsets;
    }

    @Override
    public String toString(AcceptCharset value) {
        return value.getAcceptCharsetHeader();
    }
}

