/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.validators.helper.IterationValidationHelper;

@Component
public class IterationPatchValidator
implements Validator {
    private static final String NON_PATCHABLE_ATTRIBUTE = "non patchable attribute";
    @Inject
    private IterationValidationHelper iterationValidationHelper;

    public boolean supports(Class<?> clazz) {
        return IterationDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        IterationDto patch = (IterationDto)target;
        this.iterationValidationHelper.checkProject(patch);
        this.iterationValidationHelper.checkAndAssignStatus(errors, patch);
        List<CustomFieldValueDto> customFieldValueDtos = patch.getCustomFields();
        this.iterationValidationHelper.checkCufs(errors, customFieldValueDtos, patch.getProjectId(), BindableEntity.ITERATION);
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkForbiddenPatchAttributes(Errors errors, IterationDto post) {
        if (post.getTestSuites() != null) {
            errors.rejectValue("test-suites", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the iteration itself can be patched. The attribute test suite cannot be patched. Use direct url to the test suites entity instead");
        }
        if (post.getTestPlan() != null) {
            errors.rejectValue("test-plan", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the iteration itself can be patched. The attribute test plan cannot be patched. Use direct url to the test plan entity instead");
        }
    }
}

