/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.validation.HintedValidator;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.WrappedDtoWithCustomFields;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;

@Component
public class CustomFieldValueHintedValidator
implements HintedValidator {
    @Inject
    private CustomFieldValueFinderService cufService;
    @Inject
    private CustomFieldBindingFinderService bindingService;

    public boolean supports(Class<?> clazz) {
        return WrappedDtoWithCustomFields.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
    }

    public void validateWithHints(Object target, Errors errors, DeserializationHints hints) {
        WrappedDtoWithCustomFields wrapped = (WrappedDtoWithCustomFields)((Object)target);
        Project project = hints.getProject();
        Object entity = wrapped.getWrapped();
        List<CustomFieldValueDto> dtos = wrapped.getCustomFields();
        List customFields = this.bindingService.findBoundCustomFields(project.getId().longValue(), entity.getBoundEntityType());
        CustomFieldValueValidationHelper helper = new CustomFieldValueValidationHelper(entity.getBoundEntityType(), project.getId(), customFields, dtos, errors);
        helper.validate();
    }
}

